/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.waypoint;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.persistence.PersistenceLoader;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.trait.waypoint.triggers.DelayTrigger;
import net.citizensnpcs.trait.waypoint.triggers.WaypointTrigger;
import net.citizensnpcs.trait.waypoint.triggers.WaypointTriggerRegistry;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;

public class Waypoint {
    @Persist(required=true)
    private Location location;
    @Persist
    private List<WaypointTrigger> triggers;

    public Waypoint() {
    }

    public Waypoint(Location location) {
        this.location = location.clone();
    }

    public void addTrigger(WaypointTrigger waypointTrigger) {
        if (this.triggers == null) {
            this.triggers = Lists.newArrayList();
        }
        this.triggers.add(waypointTrigger);
    }

    public void describeTriggers(CommandSender commandSender) {
        String string = " ";
        if (this.triggers == null) {
            return;
        }
        for (int i = 0; i < this.triggers.size(); ++i) {
            string = string + "\n    - " + this.triggers.get(i).description() + " [<hover:show_text:Remove trigger><click:run_command:/npc path remove_trigger " + i + "><u><red>-</click></hover>]";
        }
        Messaging.sendTr(commandSender, "citizens.editors.waypoints.triggers.list", string);
    }

    public double distance(Waypoint waypoint) {
        return this.location.distance(waypoint.location);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Waypoint waypoint = (Waypoint)object;
        return Objects.equals(this.location, waypoint.location) && Objects.equals(this.triggers, waypoint.triggers);
    }

    public Location getLocation() {
        return this.location.clone();
    }

    public List<WaypointTrigger> getTriggers() {
        return this.triggers == null ? Collections.emptyList() : this.triggers;
    }

    public int hashCode() {
        int n = 31;
        int n2 = n + (this.location == null ? 0 : this.location.hashCode());
        return n * n2 + (this.triggers == null ? 0 : this.triggers.hashCode());
    }

    public void onReach(NPC nPC) {
        if (this.triggers == null) {
            return;
        }
        this.runTriggers(nPC, 0);
    }

    private void runTriggers(NPC nPC, int n) {
        ArrayList arrayList = Lists.newArrayList(this.triggers);
        for (int i = n; i < arrayList.size(); ++i) {
            int n2;
            WaypointTrigger waypointTrigger = (WaypointTrigger)arrayList.get(i);
            waypointTrigger.onWaypointReached(nPC, this.location.clone());
            if (!(waypointTrigger instanceof DelayTrigger) || (n2 = ((DelayTrigger)waypointTrigger).getDelay()) <= 0) continue;
            int n3 = i + 1;
            Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), () -> this.runTriggers(nPC, n3), (long)n2);
            break;
        }
    }

    public String toString() {
        return "Waypoint [" + this.location + (this.triggers == null ? "]" : ", " + this.triggers.size() + " triggers]");
    }

    static {
        PersistenceLoader.registerPersistDelegate(WaypointTrigger.class, WaypointTriggerRegistry.class);
    }
}

