/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.waypoint;

import com.google.common.collect.Maps;
import java.util.Map;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.persistence.PersistenceLoader;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.editor.Editor;
import net.citizensnpcs.trait.waypoint.GuidedWaypointProvider;
import net.citizensnpcs.trait.waypoint.LinearWaypointProvider;
import net.citizensnpcs.trait.waypoint.WanderWaypointProvider;
import net.citizensnpcs.trait.waypoint.WaypointProvider;
import net.citizensnpcs.util.StringHelper;
import org.bukkit.command.CommandSender;

@TraitName(value="waypoints")
public class Waypoints
extends Trait {
    private WaypointProvider provider;
    private final Map<String, WaypointProvider> providerCache = Maps.newHashMap();
    private String providerName = "linear";
    private static Map<String, Class<? extends WaypointProvider>> PROVIDERS = Maps.newHashMap();

    public Waypoints() {
        super("waypoints");
    }

    private WaypointProvider create(String string2, Class<? extends WaypointProvider> clazz) {
        return this.providerCache.computeIfAbsent(string2, string -> {
            try {
                return (WaypointProvider)clazz.newInstance();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        });
    }

    public void describeProviders(CommandSender commandSender) {
        Messaging.sendTr(commandSender, "citizens.waypoints.available-providers-header", new Object[0]);
        for (String string : PROVIDERS.keySet()) {
            Messaging.send(commandSender, "    - " + StringHelper.wrap(string));
        }
    }

    public WaypointProvider getCurrentProvider() {
        return this.provider;
    }

    public String getCurrentProviderName() {
        return this.providerName;
    }

    public Editor getEditor(CommandSender commandSender, CommandContext commandContext) {
        return this.provider.createEditor(commandSender, commandContext);
    }

    @Override
    public void load(DataKey dataKey) {
        this.provider = null;
        this.providerName = dataKey.getString("provider", "linear");
        Class<? extends WaypointProvider> clazz = PROVIDERS.get(this.providerName);
        this.provider = this.create(this.providerName, clazz);
        if (this.provider == null) {
            return;
        }
        PersistenceLoader.load(this.provider, dataKey.getRelative(this.providerName));
        if (this.npc != null) {
            this.provider.onSpawn(this.npc);
        }
    }

    @Override
    public void onAttach() {
        this.provider = new LinearWaypointProvider(this.npc);
    }

    @Override
    public void onSpawn() {
        if (this.provider != null) {
            this.provider.onSpawn(this.getNPC());
        }
    }

    @Override
    public void save(DataKey dataKey) {
        if (this.provider == null) {
            return;
        }
        PersistenceLoader.save(this.provider, dataKey.getRelative(this.providerName));
        dataKey.setString("provider", this.providerName);
    }

    public boolean setWaypointProvider(String string) {
        string = string.toLowerCase();
        Class<? extends WaypointProvider> clazz = PROVIDERS.get(string);
        if (this.provider != null) {
            this.provider.onRemove();
        }
        if (clazz == null || (this.provider = this.create(string, clazz)) == null) {
            return false;
        }
        this.providerName = string;
        if (this.npc != null && this.npc.isSpawned()) {
            this.provider.onSpawn(this.npc);
        }
        return true;
    }

    public static void registerWaypointProvider(Class<? extends WaypointProvider> clazz, String string) {
        PROVIDERS.put(string, clazz);
    }

    static {
        PROVIDERS.put("linear", LinearWaypointProvider.class);
        PROVIDERS.put("wander", WanderWaypointProvider.class);
        PROVIDERS.put("guided", GuidedWaypointProvider.class);
    }
}

