/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.waypoint.triggers;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.trait.waypoint.triggers.WaypointTrigger;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ChatTrigger
implements WaypointTrigger {
    @Persist(required=true)
    private List<String> lines;
    @Persist
    private double radius = -1.0;

    public ChatTrigger() {
    }

    public ChatTrigger(double d, Collection<String> collection) {
        this.radius = d;
        this.lines = Lists.newArrayList(collection);
    }

    @Override
    public String description() {
        return String.format("[[Chat]] [radius %f, %s]", this.radius, Joiner.on((String)", ").join(this.lines));
    }

    @Override
    public void onWaypointReached(NPC nPC, Location location) {
        if (this.radius <= 0.0) {
            for (Player player : nPC.getEntity().getWorld().getPlayers()) {
                for (String string : this.lines) {
                    Messaging.send((CommandSender)player, string);
                }
            }
        } else {
            for (Player player : CitizensAPI.getLocationLookup().getNearbyVisiblePlayers(nPC.getEntity(), this.radius)) {
                for (String string : this.lines) {
                    Messaging.send((CommandSender)player, string);
                }
            }
        }
    }
}

