/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.waypoint.triggers;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.List;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.trait.waypoint.triggers.ChatTrigger;
import net.citizensnpcs.trait.waypoint.triggers.WaypointTrigger;
import net.citizensnpcs.trait.waypoint.triggers.WaypointTriggerPrompt;
import org.bukkit.command.CommandSender;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.Prompt;
import org.bukkit.conversations.StringPrompt;

public class ChatTriggerPrompt
extends StringPrompt
implements WaypointTriggerPrompt {
    private final List<String> lines = Lists.newArrayList();
    private double radius = -1.0;

    public Prompt acceptInput(ConversationContext conversationContext, String string) {
        if (string.equalsIgnoreCase("back")) {
            return (Prompt)conversationContext.getSessionData((Object)"previous");
        }
        if (string.startsWith("radius")) {
            try {
                this.radius = Double.parseDouble(string.split(" ")[1]);
                Messaging.sendTr((CommandSender)conversationContext.getForWhom(), "citizens.editors.waypoints.triggers.chat.radius-set", this.radius);
            }
            catch (NumberFormatException numberFormatException) {
                Messaging.sendErrorTr((CommandSender)conversationContext.getForWhom(), "citizens.editors.waypoints.triggers.chat.invalid-radius", new Object[0]);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                Messaging.sendErrorTr((CommandSender)conversationContext.getForWhom(), "citizens.editors.waypoints.triggers.chat.missing-radius", new Object[0]);
            }
            return this;
        }
        if (string.equalsIgnoreCase("finish")) {
            conversationContext.setSessionData((Object)"created-trigger", (Object)new ChatTrigger(this.radius, this.lines));
            return (Prompt)conversationContext.getSessionData((Object)"return-to");
        }
        this.lines.add(string);
        Messaging.sendTr((CommandSender)conversationContext.getForWhom(), "citizens.editors.waypoints.triggers.chat.message-added", string);
        return this;
    }

    @Override
    public WaypointTrigger createFromShortInput(ConversationContext conversationContext, String string) {
        return null;
    }

    public String getPromptText(ConversationContext conversationContext) {
        if (conversationContext.getSessionData((Object)"said") == Boolean.TRUE) {
            Messaging.send((CommandSender)conversationContext.getForWhom(), "Current lines:<br>-   " + Joiner.on((String)"<br>-   ").join(this.lines));
        } else {
            Messaging.sendTr((CommandSender)conversationContext.getForWhom(), "citizens.editors.waypoints.triggers.chat.prompt", new Object[0]);
        }
        return "";
    }
}

