/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.waypoint.triggers;

import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.trait.waypoint.WaypointProvider;
import net.citizensnpcs.trait.waypoint.Waypoints;
import net.citizensnpcs.trait.waypoint.triggers.WaypointTrigger;
import org.bukkit.Bukkit;
import org.bukkit.Location;

public class DelayTrigger
implements WaypointTrigger {
    @Persist
    private int delay = 0;

    public DelayTrigger() {
    }

    public DelayTrigger(int n) {
        this.delay = n;
    }

    private void delay(WaypointProvider waypointProvider) {
        waypointProvider.setPaused(true);
        Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), () -> waypointProvider.setPaused(false), (long)this.delay);
    }

    @Override
    public String description() {
        return String.format("[[Delay]] for [[%d]] ticks", this.delay);
    }

    public int getDelay() {
        return this.delay;
    }

    @Override
    public void onWaypointReached(NPC nPC, Location location) {
        if (this.delay > 0) {
            this.delay(nPC.getOrAddTrait(Waypoints.class).getCurrentProvider());
        }
    }
}

