/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.waypoint.triggers;

import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.trait.waypoint.triggers.SpeedTrigger;
import net.citizensnpcs.trait.waypoint.triggers.WaypointTrigger;
import net.citizensnpcs.trait.waypoint.triggers.WaypointTriggerPrompt;
import org.bukkit.command.CommandSender;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.NumericPrompt;
import org.bukkit.conversations.Prompt;

public class SpeedTriggerPrompt
extends NumericPrompt
implements WaypointTriggerPrompt {
    protected Prompt acceptValidatedInput(ConversationContext conversationContext, Number number) {
        float f = (float)Math.max(number.doubleValue(), 0.0);
        conversationContext.setSessionData((Object)"created-trigger", (Object)new SpeedTrigger(f));
        return (Prompt)conversationContext.getSessionData((Object)"return-to");
    }

    @Override
    public WaypointTrigger createFromShortInput(ConversationContext conversationContext, String string) {
        try {
            float f = (float)Math.max(Double.parseDouble(string), 0.0);
            return new SpeedTrigger(f);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public String getPromptText(ConversationContext conversationContext) {
        Messaging.sendTr((CommandSender)conversationContext.getForWhom(), "citizens.editors.waypoints.triggers.speed.prompt", new Object[0]);
        return "";
    }
}

