/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.waypoint.triggers;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.util.regex.Pattern;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.trait.waypoint.triggers.TeleportTrigger;
import net.citizensnpcs.trait.waypoint.triggers.WaypointTrigger;
import net.citizensnpcs.trait.waypoint.triggers.WaypointTriggerPrompt;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.Prompt;
import org.bukkit.conversations.RegexPrompt;
import org.bukkit.entity.Player;

public class TeleportTriggerPrompt
extends RegexPrompt
implements WaypointTriggerPrompt {
    private static Pattern PATTERN = Pattern.compile("here|back|[\\p{L}]+?:[0-9]+?:[0-9]+?:[0-9]+?", 66);

    public TeleportTriggerPrompt() {
        super(PATTERN);
    }

    protected Prompt acceptValidatedInput(ConversationContext conversationContext, String string) {
        if ((string = string.trim()).equalsIgnoreCase("back")) {
            return (Prompt)conversationContext.getSessionData((Object)"previous");
        }
        if (string.equalsIgnoreCase("here")) {
            Player player = (Player)conversationContext.getForWhom();
            conversationContext.setSessionData((Object)"created-trigger", (Object)new TeleportTrigger(player.getLocation()));
            return (Prompt)conversationContext.getSessionData((Object)"return-to");
        }
        String[] stringArray = (String[])Iterables.toArray((Iterable)Splitter.on((char)':').omitEmptyStrings().split((CharSequence)string), String.class);
        String string2 = stringArray[0];
        World world = Bukkit.getWorld((String)string2);
        if (world == null) {
            Messaging.sendErrorTr((CommandSender)conversationContext.getForWhom(), "citizens.commands.errors.missing-world", new Object[0]);
            return this;
        }
        int n = Integer.parseInt(stringArray[1]);
        int n2 = Integer.parseInt(stringArray[2]);
        int n3 = Integer.parseInt(stringArray[3]);
        conversationContext.setSessionData((Object)"created-trigger", (Object)new Location(world, (double)n, (double)n2, (double)n3));
        return (Prompt)conversationContext.getSessionData((Object)"return-to");
    }

    @Override
    public WaypointTrigger createFromShortInput(ConversationContext conversationContext, String string) {
        return null;
    }

    public String getPromptText(ConversationContext conversationContext) {
        Messaging.sendTr((CommandSender)conversationContext.getForWhom(), "citizens.editors.waypoints.triggers.teleport.prompt", new Object[0]);
        return "";
    }
}

