/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.waypoint.triggers;

import com.google.common.primitives.Ints;
import java.util.List;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.trait.waypoint.Waypoint;
import net.citizensnpcs.trait.waypoint.WaypointEditor;
import net.citizensnpcs.trait.waypoint.triggers.TriggerAddPrompt;
import net.citizensnpcs.trait.waypoint.triggers.WaypointTrigger;
import org.bukkit.command.CommandSender;
import org.bukkit.conversations.Conversable;
import org.bukkit.conversations.Conversation;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.ConversationFactory;
import org.bukkit.conversations.Prompt;
import org.bukkit.conversations.StringPrompt;
import org.bukkit.entity.Player;

public class TriggerEditPrompt
extends StringPrompt {
    private final WaypointEditor editor;

    public TriggerEditPrompt(WaypointEditor waypointEditor) {
        this.editor = waypointEditor;
    }

    public Prompt acceptInput(ConversationContext conversationContext, String string) {
        if ((string = string.toLowerCase().trim()).startsWith("remove_trigger")) {
            Waypoint waypoint = this.editor.getCurrentWaypoint();
            List<WaypointTrigger> list = waypoint.getTriggers();
            int n = Ints.tryParse((String)string.replaceFirst("remove_trigger\\s*", ""));
            if (n < list.size()) {
                list.remove(n);
            }
            return this;
        }
        if (string.contains("add")) {
            conversationContext.setSessionData((Object)"said", (Object)false);
            return new TriggerAddPrompt();
        }
        return this;
    }

    public String getPromptText(ConversationContext conversationContext) {
        WaypointTrigger waypointTrigger = (WaypointTrigger)conversationContext.getSessionData((Object)"created-trigger");
        if (waypointTrigger != null) {
            if (this.editor.getCurrentWaypoint() != null) {
                this.editor.getCurrentWaypoint().addTrigger(waypointTrigger);
                Messaging.sendTr((CommandSender)conversationContext.getForWhom(), "citizens.editors.waypoints.triggers.add.added", waypointTrigger.description());
            } else {
                Messaging.sendErrorTr((CommandSender)conversationContext.getForWhom(), "citizens.editors.waypoints.triggers.main.missing-waypoint", new Object[0]);
            }
            conversationContext.setSessionData((Object)"created-trigger", null);
        }
        conversationContext.setSessionData((Object)"said", (Object)false);
        conversationContext.setSessionData((Object)"previous", (Object)this);
        Messaging.sendTr((CommandSender)conversationContext.getForWhom(), "citizens.editors.waypoints.triggers.main.prompt", new Object[0]);
        if (this.editor.getCurrentWaypoint() != null) {
            this.editor.getCurrentWaypoint().describeTriggers((CommandSender)conversationContext.getForWhom());
        }
        return "";
    }

    public static Conversation start(Player player, WaypointEditor waypointEditor) {
        Conversation conversation = new ConversationFactory(CitizensAPI.getPlugin()).withLocalEcho(false).addConversationAbandonedListener(conversationAbandonedEvent -> Messaging.sendTr((CommandSender)conversationAbandonedEvent.getContext().getForWhom(), "citizens.editors.waypoints.triggers.main.exit", new Object[0])).withEscapeSequence("exit").withEscapeSequence("triggers").withEscapeSequence("/npc path").withModality(false).withFirstPrompt((Prompt)new TriggerEditPrompt(waypointEditor)).buildConversation((Conversable)player);
        conversation.begin();
        return conversation;
    }
}

