/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.waypoint.triggers;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import java.util.Map;
import net.citizensnpcs.api.persistence.PersistenceLoader;
import net.citizensnpcs.api.persistence.Persister;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.trait.waypoint.triggers.AnimationTrigger;
import net.citizensnpcs.trait.waypoint.triggers.AnimationTriggerPrompt;
import net.citizensnpcs.trait.waypoint.triggers.ChatTrigger;
import net.citizensnpcs.trait.waypoint.triggers.ChatTriggerPrompt;
import net.citizensnpcs.trait.waypoint.triggers.CommandTrigger;
import net.citizensnpcs.trait.waypoint.triggers.CommandTriggerPrompt;
import net.citizensnpcs.trait.waypoint.triggers.DelayTrigger;
import net.citizensnpcs.trait.waypoint.triggers.DelayTriggerPrompt;
import net.citizensnpcs.trait.waypoint.triggers.SpeedTrigger;
import net.citizensnpcs.trait.waypoint.triggers.SpeedTriggerPrompt;
import net.citizensnpcs.trait.waypoint.triggers.TeleportTrigger;
import net.citizensnpcs.trait.waypoint.triggers.TeleportTriggerPrompt;
import net.citizensnpcs.trait.waypoint.triggers.WaypointTrigger;
import net.citizensnpcs.trait.waypoint.triggers.WaypointTriggerPrompt;
import org.bukkit.conversations.Prompt;

public class WaypointTriggerRegistry
implements Persister<WaypointTrigger> {
    private static Map<String, Class<? extends Prompt>> TRIGGER_PROMPTS = Maps.newHashMap();
    private static Map<String, Class<? extends WaypointTrigger>> TRIGGERS = Maps.newHashMap();

    @Override
    public WaypointTrigger create(DataKey dataKey) {
        String string = dataKey.getString("type");
        Class<? extends WaypointTrigger> clazz = TRIGGERS.get(string);
        return clazz == null ? null : (WaypointTrigger)((Object)PersistenceLoader.load(clazz, dataKey));
    }

    @Override
    public void save(WaypointTrigger waypointTrigger, DataKey dataKey) {
        PersistenceLoader.save(waypointTrigger, dataKey);
        for (Map.Entry<String, Class<? extends WaypointTrigger>> entry : TRIGGERS.entrySet()) {
            if (entry.getValue() != waypointTrigger.getClass()) continue;
            dataKey.setString("type", entry.getKey());
            break;
        }
    }

    public static void addTrigger(String string, Class<? extends WaypointTrigger> clazz, Class<? extends WaypointTriggerPrompt> clazz2) {
        TRIGGERS.put(string, clazz);
        TRIGGER_PROMPTS.put(string, clazz2);
    }

    public static String describeValidTriggerNames() {
        return Joiner.on((String)", ").join(TRIGGER_PROMPTS.keySet());
    }

    public static Prompt getTriggerPromptFrom(String string) {
        Class<? extends Prompt> clazz = TRIGGER_PROMPTS.get(string);
        if (clazz == null) {
            return null;
        }
        try {
            return clazz.newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    static {
        WaypointTriggerRegistry.addTrigger("animation", AnimationTrigger.class, AnimationTriggerPrompt.class);
        WaypointTriggerRegistry.addTrigger("command", CommandTrigger.class, CommandTriggerPrompt.class);
        WaypointTriggerRegistry.addTrigger("chat", ChatTrigger.class, ChatTriggerPrompt.class);
        WaypointTriggerRegistry.addTrigger("delay", DelayTrigger.class, DelayTriggerPrompt.class);
        WaypointTriggerRegistry.addTrigger("teleport", TeleportTrigger.class, TeleportTriggerPrompt.class);
        WaypointTriggerRegistry.addTrigger("speed", SpeedTrigger.class, SpeedTriggerPrompt.class);
    }
}

