/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.citizensnpcs.util.NMS;
import org.bukkit.entity.Player;

public interface EntityPacketTracker
extends Runnable {
    public void link(Player var1);

    public void unlink(Player var1);

    public void unlinkAll(Consumer<Player> var1);

    public static class PacketAggregator {
        private final Set<PlayerConnection> connections = Sets.newHashSet();
        private List<Object> packets;

        public void add(UUID uUID, Consumer<Object> consumer) {
            this.connections.add(new PlayerConnection(uUID, consumer));
        }

        public void removeConnection(UUID uUID) {
            this.connections.remove(new PlayerConnection(uUID, null));
        }

        public void send(Object object) {
            if (this.packets != null) {
                this.packets.add(object);
                return;
            }
            for (PlayerConnection playerConnection : this.connections) {
                playerConnection.conn.accept(object);
            }
        }

        public void startBundling() {
            this.packets = Lists.newArrayList();
        }

        public void stopBundlingAndSend() {
            Iterable<Object> iterable = NMS.createBundlePacket(this.packets);
            this.packets = null;
            for (Object object : iterable) {
                for (PlayerConnection playerConnection : this.connections) {
                    playerConnection.conn.accept(object);
                }
            }
        }

        private static class PlayerConnection {
            Consumer<Object> conn;
            UUID uuid;

            public PlayerConnection(UUID uUID, Consumer<Object> consumer) {
                this.uuid = uUID;
                this.conn = consumer;
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                PlayerConnection playerConnection = (PlayerConnection)object;
                return Objects.equals(this.uuid, playerConnection.uuid);
            }

            public int hashCode() {
                return 31 + (this.uuid == null ? 0 : this.uuid.hashCode());
            }
        }
    }
}

