/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.util;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.function.Consumer;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class InventoryMultiplexer {
    private final ItemStack[] inventory;
    private final Collection<Inventory> sources;

    public InventoryMultiplexer(Collection<Inventory> collection) {
        this.sources = collection;
        int n = collection.stream().mapToInt(Inventory::getSize).sum();
        this.inventory = new ItemStack[n];
        this.refresh();
    }

    public InventoryMultiplexer(Inventory ... inventoryArray) {
        this((Collection<Inventory>)ImmutableList.copyOf((Object[])inventoryArray));
    }

    public ItemStack[] getInventory() {
        return this.inventory;
    }

    public void refresh() {
        int n = 0;
        for (Inventory inventory : this.sources) {
            ItemStack[] itemStackArray = inventory.getContents();
            System.arraycopy(itemStackArray, 0, this.inventory, n, itemStackArray.length);
            n += itemStackArray.length;
        }
    }

    public void transact(Consumer<ItemStack[]> consumer) {
        consumer.accept(this.inventory);
        int n = 0;
        for (Inventory inventory : this.sources) {
            ItemStack[] itemStackArray = new ItemStack[inventory.getSize()];
            System.arraycopy(this.inventory, n, itemStackArray, 0, itemStackArray.length);
            inventory.setContents(itemStackArray);
            n += itemStackArray.length;
        }
    }
}

