/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.util;

import com.google.common.io.CharStreams;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.citizensnpcs.api.util.Messaging;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class MojangSkinGenerator {
    private static final ExecutorService EXECUTOR = Executors.newSingleThreadExecutor();

    public static JSONObject generateFromPNG(byte[] byArray, boolean bl) {
        return EXECUTOR.submit(() -> {
            FilterOutputStream filterOutputStream = null;
            InputStreamReader inputStreamReader = null;
            URL uRL = new URL("https://api.mineskin.org/generate/upload" + (bl ? "?model=slim" : ""));
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setRequestProperty("User-Agent", "Citizens/2.0");
            httpURLConnection.setRequestProperty("Cache-Control", "no-cache");
            httpURLConnection.setRequestProperty("Content-Type", "multipart/form-data;boundary=*****");
            httpURLConnection.setConnectTimeout(2000);
            httpURLConnection.setReadTimeout(30000);
            filterOutputStream = new DataOutputStream(httpURLConnection.getOutputStream());
            ((DataOutputStream)filterOutputStream).writeBytes("--*****\r\n");
            ((DataOutputStream)filterOutputStream).writeBytes("Content-Disposition: form-data; name=\"file\"; filename=\"skin.png\"\r\n");
            ((DataOutputStream)filterOutputStream).writeBytes("Content-Type: image/png\r\n\r\n");
            filterOutputStream.write(byArray);
            ((DataOutputStream)filterOutputStream).writeBytes("\r\n");
            ((DataOutputStream)filterOutputStream).writeBytes("--*****\r\n");
            ((DataOutputStream)filterOutputStream).writeBytes("Content-Disposition: form-data; name=\"name\";\r\n\r\n\r\n");
            if (bl) {
                ((DataOutputStream)filterOutputStream).writeBytes("--*****\r\n");
                ((DataOutputStream)filterOutputStream).writeBytes("Content-Disposition: form-data; name=\"variant\";\r\n\r\n");
                ((DataOutputStream)filterOutputStream).writeBytes("slim\r\n");
            }
            ((DataOutputStream)filterOutputStream).writeBytes("--*****--\r\n");
            ((DataOutputStream)filterOutputStream).flush();
            filterOutputStream.close();
            inputStreamReader = new InputStreamReader(httpURLConnection.getInputStream());
            String string = CharStreams.toString((Readable)inputStreamReader);
            if (Messaging.isDebugging()) {
                Messaging.debug(string);
            }
            if (httpURLConnection.getResponseCode() != 200) {
                JSONObject jSONObject = null;
                return jSONObject;
            }
            JSONObject jSONObject = (JSONObject)new JSONParser().parse(string);
            JSONObject jSONObject2 = (JSONObject)jSONObject.get((Object)"data");
            httpURLConnection.disconnect();
            JSONObject jSONObject3 = jSONObject2;
            return jSONObject3;
            finally {
                if (filterOutputStream != null) {
                    try {
                        filterOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (inputStreamReader != null) {
                    try {
                        inputStreamReader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }).get();
    }

    public static JSONObject generateFromURL(String string, boolean bl) {
        return EXECUTOR.submit(() -> {
            FilterOutputStream filterOutputStream = null;
            InputStreamReader inputStreamReader = null;
            URL uRL = new URL("https://api.mineskin.org/generate/url");
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setRequestProperty("User-Agent", "Citizens/2.0");
            httpURLConnection.setRequestProperty("Cache-Control", "no-cache");
            httpURLConnection.setRequestProperty("Accept", "application/json");
            httpURLConnection.setRequestProperty("Content-Type", "application/json");
            httpURLConnection.setConnectTimeout(2000);
            httpURLConnection.setReadTimeout(30000);
            filterOutputStream = new DataOutputStream(httpURLConnection.getOutputStream());
            JSONObject jSONObject = new JSONObject();
            jSONObject.put((Object)"url", (Object)string);
            jSONObject.put((Object)"name", (Object)"");
            if (bl) {
                jSONObject.put((Object)"variant", (Object)"slim");
            }
            ((DataOutputStream)filterOutputStream).writeBytes(jSONObject.toJSONString().replace("\\", ""));
            filterOutputStream.close();
            inputStreamReader = new InputStreamReader(httpURLConnection.getInputStream());
            String string2 = CharStreams.toString((Readable)inputStreamReader);
            if (Messaging.isDebugging()) {
                Messaging.debug(string2);
            }
            if (httpURLConnection.getResponseCode() != 200) {
                JSONObject jSONObject2 = null;
                return jSONObject2;
            }
            JSONObject jSONObject3 = (JSONObject)new JSONParser().parse(string2);
            JSONObject jSONObject4 = (JSONObject)jSONObject3.get((Object)"data");
            httpURLConnection.disconnect();
            JSONObject jSONObject5 = jSONObject4;
            return jSONObject5;
            finally {
                if (filterOutputStream != null) {
                    try {
                        filterOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (inputStreamReader != null) {
                    try {
                        inputStreamReader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }).get();
    }
}

