/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.util;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.invoke.MethodHandle;
import java.util.Collection;
import net.citizensnpcs.util.NMS;

public class SkinProperty {
    public final String name;
    public final String signature;
    public final String value;
    private static MethodHandle GET_NAME_METHOD = null;
    private static MethodHandle GET_SIGNATURE_METHOD = null;
    private static MethodHandle GET_VALUE_METHOD = null;

    public SkinProperty(String string, String string2, String string3) {
        this.name = string;
        this.value = string2;
        this.signature = string3;
    }

    public void apply(GameProfile gameProfile) {
        gameProfile.getProperties().removeAll((Object)"textures");
        gameProfile.getProperties().put((Object)"textures", (Object)new Property(this.name, this.value, this.signature));
    }

    public static SkinProperty fromMojang(Object object) {
        if (object == null) {
            return null;
        }
        try {
            return new SkinProperty(GET_NAME_METHOD.invoke(object), GET_VALUE_METHOD.invoke(object), GET_SIGNATURE_METHOD.invoke(object));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public static SkinProperty fromMojangProfile(GameProfile gameProfile) {
        if (gameProfile == null) {
            return null;
        }
        Collection collection = gameProfile.getProperties().get((Object)"textures");
        if (collection == null || collection.size() == 0) {
            return null;
        }
        return SkinProperty.fromMojang(collection.iterator().next());
    }

    static {
        GET_NAME_METHOD = NMS.getMethodHandle(Property.class, "getName", false, new Class[0]);
        if (GET_NAME_METHOD == null) {
            GET_NAME_METHOD = NMS.getMethodHandle(Property.class, "name", false, new Class[0]);
        }
        if ((GET_SIGNATURE_METHOD = NMS.getMethodHandle(Property.class, "getSignature", false, new Class[0])) == null) {
            GET_SIGNATURE_METHOD = NMS.getMethodHandle(Property.class, "signature", false, new Class[0]);
        }
        if ((GET_VALUE_METHOD = NMS.getMethodHandle(Property.class, "getValue", false, new Class[0])) == null) {
            GET_VALUE_METHOD = NMS.getMethodHandle(Property.class, "value", false, new Class[0]);
        }
    }
}

