/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.util;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.google.common.primitives.Ints;
import java.text.DecimalFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.speech.SpeechContext;
import net.citizensnpcs.api.ai.speech.Talkable;
import net.citizensnpcs.api.ai.speech.TalkableEntity;
import net.citizensnpcs.api.event.NPCCollisionEvent;
import net.citizensnpcs.api.event.NPCPistonPushEvent;
import net.citizensnpcs.api.event.NPCPushEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.util.BoundingBox;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.api.util.Placeholders;
import net.citizensnpcs.api.util.SpigotUtil;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.XORShiftRNG;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.util.Vector;

public class Util {
    private static final Scoreboard DUMMY_SCOREBOARD = Bukkit.getScoreboardManager().getNewScoreboard();
    private static boolean SUPPORTS_BUKKIT_GETENTITY = true;
    private static final DecimalFormat TWO_DIGIT_DECIMAL = new DecimalFormat();

    private Util() {
    }

    public static void callCollisionEvent(NPC nPC, Entity entity) {
        if (NPCCollisionEvent.getHandlerList().getRegisteredListeners().length > 0) {
            Bukkit.getPluginManager().callEvent((Event)new NPCCollisionEvent(nPC, entity));
        }
    }

    public static boolean callPistonPushEvent(NPC nPC) {
        if (nPC == null) {
            return false;
        }
        NPCPistonPushEvent nPCPistonPushEvent = new NPCPistonPushEvent(nPC);
        if (nPC.isProtected()) {
            nPCPistonPushEvent.setCancelled(true);
        }
        Bukkit.getPluginManager().callEvent((Event)nPCPistonPushEvent);
        return nPCPistonPushEvent.isCancelled();
    }

    public static <T> T callPossiblySync(Callable<T> callable, boolean bl) {
        if (!bl) {
            try {
                return callable.call();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        try {
            return (T)Bukkit.getScheduler().callSyncMethod(CitizensAPI.getPlugin(), callable).get();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static Vector callPushEvent(NPC nPC, double d, double d2, double d3) {
        boolean bl;
        boolean bl2 = bl = nPC == null || !nPC.isProtected() || nPC.data().has(NPC.Metadata.COLLIDABLE) && (Boolean)nPC.data().get(NPC.Metadata.COLLIDABLE) != false;
        if (NPCPushEvent.getHandlerList().getRegisteredListeners().length == 0) {
            return bl ? new Vector(d, d2, d3) : null;
        }
        Vector vector = new Vector(d, d2, d3);
        NPCPushEvent nPCPushEvent = new NPCPushEvent(nPC, vector, null);
        nPCPushEvent.setCancelled(!bl);
        Bukkit.getPluginManager().callEvent((Event)nPCPushEvent);
        return !nPCPushEvent.isCancelled() ? nPCPushEvent.getCollisionVector() : null;
    }

    public static float clamp(float f) {
        while (f < -180.0f) {
            f += 360.0f;
        }
        while (f >= 180.0f) {
            f -= 360.0f;
        }
        return f;
    }

    public static float clamp(float f, float f2, float f3, float f4) {
        while (f < f2) {
            f += f4;
        }
        while (f >= f3) {
            f -= f4;
        }
        return f;
    }

    public static int convert(TimeUnit timeUnit, Duration duration) {
        return (int)(timeUnit.convert(duration.getSeconds(), TimeUnit.SECONDS) + timeUnit.convert(duration.getNano(), TimeUnit.NANOSECONDS));
    }

    public static ItemStack createItem(Material material, String string) {
        return Util.createItem(material, string, null);
    }

    public static ItemStack createItem(Material material, String string, String string2) {
        ItemStack itemStack = new ItemStack(material, 1);
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(ChatColor.RESET + Messaging.parseComponents(string));
        if (string2 != null) {
            itemMeta.setLore(Arrays.asList(Messaging.parseComponents(string2).split("\n")));
        }
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    public static ItemStack editTitle(ItemStack itemStack, Function<String, String> function) {
        ItemMeta itemMeta;
        itemMeta.setDisplayName(function.apply((itemMeta = itemStack.getItemMeta()).hasDisplayName() ? itemMeta.getDisplayName() : ""));
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    public static void face(Entity entity, float f, float f2) {
        double d = Math.cos(Math.toRadians(f2));
        Vector vector = new Vector(Math.sin(Math.toRadians(f)) * -d, -Math.sin(Math.toRadians(f2)), Math.cos(Math.toRadians(f)) * d).normalize();
        Util.faceLocation(entity, entity.getLocation().clone().add(vector));
    }

    public static void faceEntity(Entity entity, Entity entity2) {
        if (entity2 == null || entity == null || entity.getWorld() != entity2.getWorld()) {
            return;
        }
        if (entity2 instanceof LivingEntity) {
            NMS.look(entity, entity2);
        } else {
            Util.faceLocation(entity, entity2.getLocation());
        }
    }

    public static void faceLocation(Entity entity, Location location) {
        Util.faceLocation(entity, location, false);
    }

    public static void faceLocation(Entity entity, Location location, boolean bl) {
        Util.faceLocation(entity, location, bl, true);
    }

    public static void faceLocation(Entity entity, Location location, boolean bl, boolean bl2) {
        if (location == null || entity.getWorld() != location.getWorld()) {
            return;
        }
        NMS.look(entity, location, bl, bl2);
    }

    public static Location getCenterLocation(Block block) {
        Location location = block.getLocation();
        Location location2 = new Location(location.getWorld(), (double)location.getBlockX() + 0.5, (double)location.getBlockY(), (double)location.getBlockZ() + 0.5);
        BoundingBox boundingBox = NMS.getCollisionBox(block);
        if (boundingBox != null && boundingBox.maxY - boundingBox.minY < 0.6) {
            location2.setY(location2.getY() + (boundingBox.maxY - boundingBox.minY));
        }
        return location2;
    }

    public static float getDragonYaw(Entity entity, double d, double d2) {
        Location location = entity.getLocation();
        double d3 = location.getX();
        double d4 = location.getZ();
        double d5 = d3 + d;
        double d6 = d4 + d2;
        if (d4 > d6) {
            return (float)(-Math.toDegrees(Math.atan((d3 - d5) / (d4 - d6))));
        }
        if (d4 < d6) {
            return (float)(-Math.toDegrees(Math.atan((d3 - d5) / (d4 - d6)))) + 180.0f;
        }
        return location.getYaw();
    }

    public static Scoreboard getDummyScoreboard() {
        return DUMMY_SCOREBOARD;
    }

    public static Entity getEntity(UUID uUID) {
        if (SUPPORTS_BUKKIT_GETENTITY) {
            try {
                return Bukkit.getEntity((UUID)uUID);
            }
            catch (Throwable throwable) {
                SUPPORTS_BUKKIT_GETENTITY = false;
            }
        }
        for (World world : Bukkit.getWorlds()) {
            for (Entity entity : world.getEntities()) {
                if (!entity.getUniqueId().equals(uUID)) continue;
                return entity;
            }
        }
        return null;
    }

    public static Location getEyeLocation(Entity entity) {
        return entity instanceof LivingEntity ? ((LivingEntity)entity).getEyeLocation() : entity.getLocation();
    }

    public static EntityType getFallbackEntityType(String string, String ... stringArray) {
        try {
            return EntityType.valueOf((String)string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            for (String string2 : stringArray) {
                try {
                    return EntityType.valueOf((String)string2);
                }
                catch (IllegalArgumentException illegalArgumentException2) {
                }
            }
            return null;
        }
    }

    public static Material getFallbackMaterial(String string, String ... stringArray) {
        try {
            return Material.valueOf((String)string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            for (String string2 : stringArray) {
                try {
                    return Material.valueOf((String)string2);
                }
                catch (IllegalArgumentException illegalArgumentException2) {
                }
            }
            return null;
        }
    }

    public static Random getFastRandom() {
        return new XORShiftRNG();
    }

    public static String getTeamName(UUID uUID) {
        return "CIT-" + uUID.toString().replace("-", "").substring(0, 12);
    }

    public static boolean inBlock(Entity entity) {
        Location location = entity.getLocation();
        if (!Util.isLoaded(location)) {
            return false;
        }
        Block block = location.getBlock();
        Block block2 = block.getRelative(BlockFace.UP);
        return block.getType().isSolid() && block2.getType().isSolid() && NMS.isSolid(block) && NMS.isSolid(block2);
    }

    public static boolean isAlwaysFlyable(EntityType entityType) {
        if (entityType.name().equals("VEX") || entityType.name().equals("PARROT") || entityType.name().equals("ALLAY") || entityType.name().equals("BEE") || entityType.name().equals("PHANTOM") || entityType.name().equals("BREEZE")) {
            return true;
        }
        switch (entityType) {
            case BAT: 
            case BLAZE: 
            case ENDER_DRAGON: 
            case GHAST: 
            case WITHER: {
                return true;
            }
        }
        return false;
    }

    public static boolean isHorse(EntityType entityType) {
        String string = entityType.name();
        return entityType == EntityType.HORSE || string.contains("_HORSE") || string.equals("DONKEY") || string.equals("MULE") || string.equals("LLAMA") || string.equals("TRADER_LLAMA") || string.equals("CAMEL");
    }

    public static boolean isLoaded(Location location) {
        if (location.getWorld() == null) {
            return false;
        }
        int n = location.getBlockX() >> 4;
        int n2 = location.getBlockZ() >> 4;
        return location.getWorld().isChunkLoaded(n, n2);
    }

    public static boolean isOffHand(PlayerInteractEntityEvent playerInteractEntityEvent) {
        try {
            return playerInteractEntityEvent.getHand() == EquipmentSlot.OFF_HAND;
        }
        catch (NoSuchMethodError noSuchMethodError) {
            return false;
        }
        catch (NoSuchFieldError noSuchFieldError) {
            return false;
        }
    }

    public static boolean isOffHand(PlayerInteractEvent playerInteractEvent) {
        try {
            return playerInteractEvent.getHand() == EquipmentSlot.OFF_HAND;
        }
        catch (NoSuchMethodError noSuchMethodError) {
            return false;
        }
        catch (NoSuchFieldError noSuchFieldError) {
            return false;
        }
    }

    public static String listValuesPretty(Enum<?>[] enumArray) {
        return "<yellow>" + Joiner.on((String)"<green>, <yellow>").join((Object[])enumArray).toLowerCase();
    }

    public static boolean locationWithinRange(Location location, Location location2, double d) {
        if (location == null || location2 == null || location.getWorld() != location2.getWorld()) {
            return false;
        }
        return location.distance(location2) <= d;
    }

    public static <T extends Enum<?>> T matchEnum(T[] TArray, String string) {
        string = string.toLowerCase().replace('-', '_').replace(' ', '_');
        for (T t : TArray) {
            if (!string.equals(((Enum)t).name().toLowerCase()) && (!string.equals("item") || !((Enum)t).name().equals("DROPPED_ITEM"))) continue;
            return t;
        }
        for (T t : TArray) {
            String string2 = ((Enum)t).name().toLowerCase();
            if (!string2.replace("_", "").equals(string) && !string2.startsWith(string)) continue;
            return t;
        }
        return null;
    }

    public static boolean matchesItemInHand(Player player, String string) {
        String string2 = string;
        if (string2.contains("*") || string2.isEmpty()) {
            return true;
        }
        for (String string3 : Splitter.on((char)',').split((CharSequence)string2)) {
            Material material;
            Material material2 = material = SpigotUtil.isUsing1_13API() ? Material.matchMaterial((String)string3, (boolean)false) : Material.matchMaterial((String)string3);
            if (material == null) {
                if (string3.equals("280")) {
                    material = Material.STICK;
                } else if (string3.equals("340")) {
                    material = Material.BOOK;
                }
            }
            if (material != player.getInventory().getItemInHand().getType()) continue;
            return true;
        }
        return false;
    }

    public static Set<EntityType> optionalEntitySet(String ... stringArray) {
        EnumSet<EntityType> enumSet = EnumSet.noneOf(EntityType.class);
        for (String string : stringArray) {
            try {
                enumSet.add(EntityType.valueOf((String)string));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return enumSet;
    }

    public static Color parseColor(String string) {
        if (!string.contains(",")) {
            return Color.fromRGB((int)Integer.decode(string));
        }
        List list = Splitter.on((char)',').splitToStream((CharSequence)string).map(Integer::parseInt).collect(Collectors.toList());
        if (list.size() == 3) {
            return Color.fromRGB((int)((Integer)list.get(0)), (int)((Integer)list.get(1)), (int)((Integer)list.get(2)));
        }
        if (list.size() == 4) {
            return Color.fromARGB((int)((Integer)list.get(0)), (int)((Integer)list.get(1)), (int)((Integer)list.get(2)), (int)((Integer)list.get(3)));
        }
        throw new NumberFormatException();
    }

    public static ItemStack parseItemStack(ItemStack itemStack, String string) {
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            itemStack = new ItemStack(Material.STONE, 1);
        }
        if (string.charAt(0) == '{') {
            try {
                Bukkit.getUnsafe().modifyItemStack(itemStack, string);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        } else if (!string.isEmpty()) {
            String[] stringArray = (String[])Iterables.toArray((Iterable)Splitter.on((char)',').split((CharSequence)string), String.class);
            if (stringArray.length == 0) {
                return itemStack;
            }
            itemStack.setType(Material.matchMaterial((String)stringArray[0]));
            if (stringArray.length > 1) {
                itemStack.setAmount(Ints.tryParse((String)stringArray[1]).intValue());
            }
            if (stringArray.length > 2) {
                Integer n = Ints.tryParse((String)stringArray[2]);
                itemStack.setDurability(n.shortValue());
            }
        }
        return itemStack;
    }

    public static int parseTicks(String string) {
        Duration duration = SpigotUtil.parseDuration(string, null);
        return duration == null ? -1 : Util.toTicks(duration);
    }

    public static String prettyEnum(Enum<?> enum_) {
        return enum_.name().toLowerCase().replace('_', ' ');
    }

    public static String prettyPrintLocation(Location location) {
        return String.format("%s at %s, %s, %s (%s, %s)", location.getWorld().getName(), TWO_DIGIT_DECIMAL.format(location.getX()), TWO_DIGIT_DECIMAL.format(location.getY()), TWO_DIGIT_DECIMAL.format(location.getZ()), TWO_DIGIT_DECIMAL.format(location.getYaw()), TWO_DIGIT_DECIMAL.format(location.getPitch()));
    }

    public static String rawtype(Enum<?>[] enumArray) {
        return "<yellow>" + Joiner.on((String)"<green>, <yellow>").join((Object[])enumArray).toLowerCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runCommand(NPC nPC, Player player, String string, boolean bl, boolean bl2) {
        List list = Splitter.on((char)' ').omitEmptyStrings().trimResults().limit(2).splitToList((CharSequence)string);
        String string2 = list.size() == 2 && ((String)list.get(0)).equalsIgnoreCase("server") ? (String)list.get(1) : null;
        String string3 = string;
        if (string.startsWith("say")) {
            string3 = "npc speak " + string.replaceFirst("say", "").trim() + " --target <p>";
        }
        if ((string3.startsWith("npc ") || string3.startsWith("waypoints ") || string3.startsWith("wp ")) && !string3.contains("--id ")) {
            string3 = string3 + " --id <id>";
        }
        String string4 = Placeholders.replace(string3, (CommandSender)player, nPC);
        Messaging.idebug(() -> "Running command " + string4 + " on NPC " + (nPC == null ? -1 : nPC.getId()) + " clicker " + player);
        if (!bl2) {
            Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), string4);
            return;
        }
        boolean bl3 = player.isOp();
        if (bl) {
            player.setOp(true);
        }
        try {
            if (string2 != null) {
                ByteArrayDataOutput byteArrayDataOutput = ByteStreams.newDataOutput();
                byteArrayDataOutput.writeUTF("Connect");
                byteArrayDataOutput.writeUTF(string2);
                player.sendPluginMessage(CitizensAPI.getPlugin(), "BungeeCord", byteArrayDataOutput.toByteArray());
            } else {
                player.chat("/" + string4);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        finally {
            if (bl) {
                player.setOp(bl3);
            }
        }
    }

    public static void sendBlockChanges(List<Block> list, Material material) {
        if (list.isEmpty()) {
            return;
        }
        Location location = new Location(null, 0.0, 0.0, 0.0);
        for (Player player : list.get(0).getWorld().getPlayers()) {
            for (Block block : list) {
                if (material != null) {
                    player.sendBlockChange(block.getLocation(location), material, (byte)0);
                    continue;
                }
                if (SpigotUtil.isUsing1_13API()) {
                    player.sendBlockChange(block.getLocation(location), block.getBlockData());
                    continue;
                }
                player.sendBlockChange(block.getLocation(location), block.getType(), block.getData());
            }
        }
    }

    public static void talk(SpeechContext speechContext) {
        if (speechContext.getTalker() == null) {
            return;
        }
        NPC nPC = CitizensAPI.getNPCRegistry().getNPC(speechContext.getTalker().getEntity());
        if (nPC == null) {
            return;
        }
        if (!speechContext.hasRecipients()) {
            String string = Settings.Setting.CHAT_FORMAT.asString().replace("<text>", speechContext.getMessage());
            Util.talkToBystanders(nPC, string, speechContext);
            return;
        }
        if (speechContext.size() <= 1) {
            String string = Settings.Setting.CHAT_FORMAT_TO_TARGET.asString().replace("<text>", speechContext.getMessage());
            String string2 = "";
            for (Talkable talkable : speechContext) {
                talkable.talkTo(speechContext, string);
                string2 = talkable.getName();
            }
            if (!Settings.Setting.CHAT_BYSTANDERS_HEAR_TARGETED_CHAT.asBoolean()) {
                return;
            }
            String string3 = Settings.Setting.CHAT_FORMAT_TO_BYSTANDERS.asString().replace("<target>", string2).replace("<text>", speechContext.getMessage());
            Util.talkToBystanders(nPC, string3, speechContext);
            return;
        }
        String string = Settings.Setting.CHAT_FORMAT_TO_TARGET.asString().replace("<text>", speechContext.getMessage());
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Talkable talkable : speechContext) {
            talkable.talkTo(speechContext, string);
            arrayList.add(talkable.getName());
        }
        if (!Settings.Setting.CHAT_BYSTANDERS_HEAR_TARGETED_CHAT.asBoolean()) {
            return;
        }
        Object object = "";
        int n = Settings.Setting.CHAT_MAX_NUMBER_OF_TARGETS.asInt();
        String[] stringArray = Settings.Setting.CHAT_MULTIPLE_TARGETS_FORMAT.asString().split("\\|");
        if (stringArray.length != 4) {
            Messaging.severe("npc.chat.options.multiple-targets-format invalid!");
        }
        if (n == 1) {
            object = stringArray[0].replace("<target>", (CharSequence)arrayList.get(0)) + stringArray[3];
        } else if (n == 2 || arrayList.size() == 2) {
            object = arrayList.size() == 2 ? stringArray[0].replace("<target>", (CharSequence)arrayList.get(0)) + stringArray[2].replace("<target>", (CharSequence)arrayList.get(1)) : stringArray[0].replace("<target>", (CharSequence)arrayList.get(0)) + stringArray[1].replace("<target>", (CharSequence)arrayList.get(1)) + stringArray[3];
        } else if (n >= 3) {
            object = stringArray[0].replace("<target>", (CharSequence)arrayList.get(0));
            int n2 = 1;
            for (n2 = 1; n2 < n - 1 && arrayList.size() - 1 != n2; ++n2) {
                object = (String)object + stringArray[1].replace("<npc>", (CharSequence)arrayList.get(n2));
            }
            object = arrayList.size() == n ? (String)object + stringArray[2].replace("<npc>", (CharSequence)arrayList.get(n2)) : (String)object + stringArray[3];
        }
        String string4 = Settings.Setting.CHAT_FORMAT_WITH_TARGETS_TO_BYSTANDERS.asString().replace("<targets>", (CharSequence)object).replace("<text>", speechContext.getMessage());
        Util.talkToBystanders(nPC, string4, speechContext);
    }

    private static void talkToBystanders(NPC nPC, String string, SpeechContext speechContext) {
        List list = nPC.getEntity().getNearbyEntities(Settings.Setting.CHAT_RANGE.asDouble(), Settings.Setting.CHAT_RANGE.asDouble(), Settings.Setting.CHAT_RANGE.asDouble());
        for (Entity entity : list) {
            boolean bl = true;
            if (!Settings.Setting.TALK_CLOSE_TO_NPCS.asBoolean() && CitizensAPI.getNPCRegistry().isNPC(entity)) {
                bl = false;
            }
            if (speechContext.hasRecipients()) {
                for (Talkable talkable : speechContext) {
                    if (!talkable.getEntity().equals((Object)entity)) continue;
                    bl = false;
                    break;
                }
            }
            if (!bl) continue;
            new TalkableEntity(entity).talkNear(speechContext, string);
        }
    }

    public static int toTicks(Duration duration) {
        return (int)(TimeUnit.MILLISECONDS.convert(duration.getSeconds(), TimeUnit.SECONDS) + TimeUnit.MILLISECONDS.convert(duration.getNano(), TimeUnit.NANOSECONDS)) / 50;
    }

    static {
        TWO_DIGIT_DECIMAL.setMaximumFractionDigits(2);
    }
}

