/*
 * Decompiled with CFR 0.152.
 */
package ct.ajneb97;

import ct.ajneb97.Comando;
import ct.ajneb97.api.ComplexTurretsAPI;
import ct.ajneb97.configs.ConfigsManager;
import ct.ajneb97.listeners.Entrar;
import ct.ajneb97.listeners.InventoryListener;
import ct.ajneb97.listeners.JugadorListener;
import ct.ajneb97.listeners.OtherTurretsListener;
import ct.ajneb97.managers.DependencyManager;
import ct.ajneb97.managers.ErrorManager;
import ct.ajneb97.managers.InventoryManager;
import ct.ajneb97.managers.ItemManager;
import ct.ajneb97.managers.JugadorManager;
import ct.ajneb97.managers.MensajesManager;
import ct.ajneb97.managers.ShootManager;
import ct.ajneb97.managers.TurretsManager;
import ct.ajneb97.managers.VerifyManager;
import ct.ajneb97.tasks.GlobalCheckTask;
import ct.ajneb97.tasks.HealthRecoveryTask;
import ct.ajneb97.tasks.SavePlayersTask;
import ct.ajneb97.utils.ServerVersion;
import ct.ajneb97.utils.UtilsEntities;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class ComplexTurrets
extends JavaPlugin {
    PluginDescriptionFile pdfFile = this.getDescription();
    public String version = this.pdfFile.getVersion();
    public String latestversion;
    public String rutaConfig;
    private MensajesManager mensajesManager;
    private TurretsManager turretsManager;
    private ConfigsManager configsManager;
    private ItemManager itemManager;
    private JugadorManager jugadorManager;
    private VerifyManager verifyManager;
    private InventoryManager inventoryManager;
    private DependencyManager dependencyManager;
    private ShootManager shootManager;
    private ErrorManager errorManager;
    private HealthRecoveryTask healthRecoveryTask;
    private GlobalCheckTask globalCheckTask;
    private SavePlayersTask savePlayersTask;
    public static String nombrePlugin = ChatColor.translateAlternateColorCodes((char)'&', (String)"&8[&5ComplexTurret&8] ");
    public static ServerVersion serverVersion;

    public void onEnable() {
        ComplexTurrets.loadConfig0();
        this.setVersion();
        this.errorManager = new ErrorManager(this);
        this.dependencyManager = new DependencyManager(this);
        this.turretsManager = new TurretsManager(this);
        this.inventoryManager = new InventoryManager(this);
        this.jugadorManager = new JugadorManager(this);
        boolean bl = this.registerConfig();
        this.configsManager = new ConfigsManager(this, bl);
        this.configsManager.configurar();
        this.itemManager = new ItemManager(this);
        this.verifyManager = new VerifyManager(this);
        this.shootManager = new ShootManager(this);
        this.restartHealthRecoveryTask();
        this.restartGlobalCheckTask();
        this.restartSavePlayersTask();
        this.registerEvents();
        this.registerCommands();
        this.errorManager.reiniciar();
        this.jugadorManager.fixTurretsAmmo();
        this.dependencyManager.getHologramsManager().reloadHolograms();
        this.checkMessagesUpdate();
        new ComplexTurretsAPI(this);
        new UtilsEntities();
        Bukkit.getConsoleSender().sendMessage(String.valueOf(nombrePlugin) + ChatColor.YELLOW + "Has been enabled! " + ChatColor.WHITE + "Version: " + this.version);
        Bukkit.getConsoleSender().sendMessage(String.valueOf(nombrePlugin) + ChatColor.YELLOW + "Thanks for using my plugin!  " + ChatColor.WHITE + "~Ajneb97");
        this.updateChecker();
    }

    public void onDisable() {
        this.configsManager.getPlayerConfigsManager().guardarJugadores();
        Bukkit.getConsoleSender().sendMessage(String.valueOf(nombrePlugin) + ChatColor.YELLOW + "Has been disabled! " + ChatColor.WHITE + "Version: " + this.version);
    }

    public void setVersion() {
        String string = Bukkit.getServer().getClass().getPackage().getName();
        serverVersion = ServerVersion.valueOf(string.replace("org.bukkit.craftbukkit.", ""));
    }

    public void registerCommands() {
        this.getCommand("ct").setExecutor((CommandExecutor)new Comando(this));
    }

    public void registerEvents() {
        PluginManager pluginManager = this.getServer().getPluginManager();
        pluginManager.registerEvents((Listener)new JugadorListener(this), (Plugin)this);
        pluginManager.registerEvents((Listener)new InventoryListener(this), (Plugin)this);
        pluginManager.registerEvents((Listener)new OtherTurretsListener(this), (Plugin)this);
        pluginManager.registerEvents((Listener)new Entrar(this), (Plugin)this);
    }

    public boolean registerConfig() {
        File file = new File(this.getDataFolder(), "config.yml");
        this.rutaConfig = file.getPath();
        if (!file.exists()) {
            this.getConfig().options().copyDefaults(true);
            this.saveConfig();
            return true;
        }
        return false;
    }

    public void recargarConfigs() {
        this.getConfigsManager().getMensajesConfigManager().reloadMessages();
        this.getConfigsManager().getTurretsConfigsManager().reloadTurrets();
        this.getConfigsManager().getPlayerConfigsManager().guardarJugadores();
        this.reloadConfig();
        this.getConfigsManager().getMainConfigManager().configurar();
        this.getConfigsManager().getInventoryConfigManager().recargar();
        this.getJugadorManager().restartCooldowns();
        this.restartHealthRecoveryTask();
        this.restartGlobalCheckTask();
        this.restartSavePlayersTask();
        this.errorManager.reiniciar();
        this.jugadorManager.fixTurretsAmmo();
        this.dependencyManager.getHologramsManager().reloadHolograms();
    }

    public void restartHealthRecoveryTask() {
        if (this.healthRecoveryTask != null) {
            this.healthRecoveryTask.end();
        }
        this.healthRecoveryTask = new HealthRecoveryTask(this);
        this.healthRecoveryTask.start();
    }

    public void restartGlobalCheckTask() {
        if (this.globalCheckTask != null) {
            this.globalCheckTask.end();
        }
        this.globalCheckTask = new GlobalCheckTask(this);
        this.globalCheckTask.start();
    }

    public void restartSavePlayersTask() {
        if (this.savePlayersTask != null) {
            this.savePlayersTask.end();
        }
        this.savePlayersTask = new SavePlayersTask(this);
        this.savePlayersTask.start();
    }

    public MensajesManager getMensajesManager() {
        return this.mensajesManager;
    }

    public FileConfiguration getMessages() {
        return this.configsManager.getMensajesConfigManager().getMessages();
    }

    public TurretsManager getTurretsManager() {
        return this.turretsManager;
    }

    public ConfigsManager getConfigsManager() {
        return this.configsManager;
    }

    public void setMensajesManager(MensajesManager mensajesManager) {
        this.mensajesManager = mensajesManager;
    }

    public ItemManager getItemManager() {
        return this.itemManager;
    }

    public JugadorManager getJugadorManager() {
        return this.jugadorManager;
    }

    public VerifyManager getVerifyManager() {
        return this.verifyManager;
    }

    public InventoryManager getInventoryManager() {
        return this.inventoryManager;
    }

    public DependencyManager getDependencyManager() {
        return this.dependencyManager;
    }

    public ShootManager getShootManager() {
        return this.shootManager;
    }

    public ErrorManager getErrorManager() {
        return this.errorManager;
    }

    public boolean isPluginDisabled() {
        return this.errorManager.isPluginDisabled();
    }

    public void checkMessagesUpdate() {
        Path path = Paths.get(this.rutaConfig, new String[0]);
        Path path2 = Paths.get(this.configsManager.getMensajesConfigManager().getPath(), new String[0]);
        Path path3 = Paths.get(this.configsManager.getInventoryConfigManager().getPath(), new String[0]);
        try {
            String string = new String(Files.readAllBytes(path));
            String string2 = new String(Files.readAllBytes(path2));
            new String(Files.readAllBytes(path3));
            FileConfiguration fileConfiguration = this.configsManager.getMensajesConfigManager().getMessages();
            FileConfiguration fileConfiguration2 = this.configsManager.getInventoryConfigManager().getInventory();
            if (!string.contains("force_particles:")) {
                this.getConfig().set("force_particles", (Object)false);
                this.saveConfig();
                this.getConfigsManager().getMainConfigManager().configurar();
            }
            if (!string.contains("remove_player_from_whitelist_click_type:")) {
                this.getConfig().set("remove_player_from_whitelist_click_type", (Object)"RIGHT");
                this.saveConfig();
            }
            if (!string2.contains("informationHologramActivationDelayError:")) {
                fileConfiguration.set("informationHologramActivationDelayError", (Object)"&cActivating in &7%time%s&c!");
                this.configsManager.getMensajesConfigManager().saveMessages();
            }
            if (!string.contains("no_ammo_required_to_remove:")) {
                this.getConfig().set("no_ammo_required_to_remove", (Object)true);
                fileConfiguration.set("turretRemoveIsNotEmptyAmmo", (Object)"&cTo remove this turret you must take the ammo first.");
                this.saveConfig();
                this.configsManager.getMensajesConfigManager().saveMessages();
            }
            if (!string.contains("remove_arrows_on_turret_damage:")) {
                this.getConfig().set("remove_arrows_on_turret_damage", (Object)true);
                this.saveConfig();
                this.getConfigsManager().getMainConfigManager().configurar();
            }
            if (!string.contains("crossbow:")) {
                this.getConfig().set("turret_damage.crossbow", (Object)"15-20");
                this.saveConfig();
                this.getConfigsManager().getMainConfigManager().configurar();
            }
            if (!string.contains("drop_ammo_on_destroy:")) {
                this.getConfig().set("receive_turret_on_remove", (Object)true);
                this.getConfig().set("save_properties_on_remove", (Object)true);
                this.getConfig().set("drop_turret_on_destroy", (Object)true);
                this.getConfig().set("drop_ammo_on_destroy", (Object)false);
                this.getConfig().set("save_properties_on_destroy", (Object)false);
                this.getConfig().set("receive_turret_on_destroy", null);
                this.getConfig().set("protect_turrets_from_explosions", null);
                this.saveConfig();
            }
            if (!string.contains("default_max_ammo:")) {
                this.getConfig().set("default_max_ammo", (Object)2880);
                this.saveConfig();
            }
            if (!string.contains("ammo_next_page:")) {
                this.getConfig().set("items.ammo_next_page.id", (Object)"ARROW");
                this.getConfig().set("items.ammo_next_page.name", (Object)"&7Next page");
                this.getConfig().set("items.ammo_previous_page.id", (Object)"ARROW");
                this.getConfig().set("items.ammo_previous_page.name", (Object)"&7Previous page");
                this.saveConfig();
                fileConfiguration2.set("Inventories.ammunition", null);
                fileConfiguration2.set("Inventories.ammunition.title", (Object)"&9Turret Ammunition");
                fileConfiguration2.set("Inventories.ammunition.1-7.id", (Object)"BLACK_STAINED_GLASS_PANE");
                fileConfiguration2.set("Inventories.ammunition.1-7.name", (Object)" ");
                fileConfiguration2.set("Inventories.ammunition.0.id", (Object)"ARROW");
                fileConfiguration2.set("Inventories.ammunition.0.name", (Object)"&7Back");
                fileConfiguration2.set("Inventories.ammunition.0.open_inventory", (Object)"options");
                fileConfiguration2.set("Inventories.ammunition.6.type", (Object)"ammo_previous_page");
                fileConfiguration2.set("Inventories.ammunition.7.type", (Object)"ammo_next_page");
                fileConfiguration2.set("Inventories.ammunition.8.type", (Object)"infinite_ammo_item");
                this.configsManager.getInventoryConfigManager().saveInventory();
                this.configsManager.getInventoryConfigManager().cargarInventarios();
            }
            if (!string.contains("save_properties_on_destroy:")) {
                this.getConfig().set("save_properties_on_destroy", (Object)false);
                this.saveConfig();
            }
            if (!string.contains("information_holograms_always_visible:")) {
                this.getConfig().set("information_holograms_always_visible", (Object)false);
                this.saveConfig();
            }
            if (!string.contains("reduce_durability_one_armor_slot_per_hit:")) {
                this.getConfig().set("armor_durability.reduce_durability_one_armor_slot_per_hit", (Object)false);
                this.saveConfig();
            }
            if (!string2.contains("placeTurretInvalidPositionBlocksNearby:")) {
                fileConfiguration.set("placeTurretInvalidPositionBlocksNearby", (Object)"&cTurrets must be placed at a minimum distance of &7%distance% &cblocks away from other blocks!");
                fileConfiguration.set("placeBlockTurretNearby", (Object)"&cBlocks must be placed at a minimum distance of &7%distance% &cblocks away from turrets!");
                this.getConfig().set("turret_blocks_nearby_min_distance", (Object)0);
                this.saveConfig();
                this.configsManager.getMensajesConfigManager().saveMessages();
            }
            if (!string2.contains("placeTurretTooHigh:")) {
                fileConfiguration.set("placeTurretTooHigh", (Object)"&cYou are trying to place the turret too high!");
                this.configsManager.getMensajesConfigManager().saveMessages();
            }
            if (!string2.contains("setDamageCommandError:")) {
                fileConfiguration.set("setDamageCommandError", (Object)"&cYou need to use &7/ct setdamage <min_damage> <max_damage>");
                fileConfiguration.set("setDamageCommandInvalidDamage", (Object)"&cUse valid numbers for min and max damage.");
                fileConfiguration.set("setDamageCommandNoItem", (Object)"&cYou must have an item in your hand.");
                fileConfiguration.set("setDamageCommandInvalidItem", (Object)"&cYou can only set the turret damage to bows.");
                fileConfiguration.set("setDamageCommandCorrect", (Object)"&aTurret damage set correctly for this item: &7%min%&8-&7%max%");
                fileConfiguration.set("setDamageCommandRemoved", (Object)"&aTurret damage for this item was removed.");
                this.configsManager.getMensajesConfigManager().saveMessages();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void updateChecker() {
        try {
            HttpURLConnection httpURLConnection = (HttpURLConnection)new URL("https://api.spigotmc.org/legacy/update.php?resource=92756").openConnection();
            int n = 1250;
            httpURLConnection.setConnectTimeout(n);
            httpURLConnection.setReadTimeout(n);
            this.latestversion = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream())).readLine();
            if (this.latestversion.length() <= 7 && !this.version.equals(this.latestversion)) {
                Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "There is a new version available. " + ChatColor.YELLOW + "(" + ChatColor.GRAY + this.latestversion + ChatColor.YELLOW + ")");
                Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "You can download it at: " + ChatColor.WHITE + "https://www.spigotmc.org/resources/92756/");
            }
        }
        catch (Exception exception) {
            Bukkit.getConsoleSender().sendMessage(String.valueOf(nombrePlugin) + ChatColor.RED + "Error while checking update.");
        }
    }

    private static /* bridge */ /* synthetic */ void loadConfig0() {
        try {
            URLConnection con = new URL("https://api.spigotmc.org/legacy/premium.php?user_id=1717051&resource_id=92756&nonce=-239145616").openConnection();
            con.setConnectTimeout(1000);
            con.setReadTimeout(1000);
            ((HttpURLConnection)con).setInstanceFollowRedirects(true);
            String response = new BufferedReader(new InputStreamReader(con.getInputStream())).readLine();
            if ("false".equals(response)) {
                throw new RuntimeException("Access to this plugin has been disabled! Please contact the author!");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

