/*
 * Decompiled with CFR 0.152.
 */
package ct.ajneb97.configs;

import ct.ajneb97.ComplexTurrets;
import ct.ajneb97.managers.ItemManager;
import ct.ajneb97.model.InventoryTurret;
import ct.ajneb97.model.ItemInventoryTurret;
import ct.ajneb97.utils.UtilsOthers;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;

public class InventoryConfigManager {
    private ComplexTurrets plugin;
    private FileConfiguration inventory = null;
    private File inventoryFile = null;
    private boolean firstTime;
    private String rutaInventories;

    public InventoryConfigManager(ComplexTurrets complexTurrets) {
        this.plugin = complexTurrets;
        this.firstTime = false;
    }

    public void configurar() {
        this.registerInventory();
        if (this.firstTime && UtilsOthers.isLegacy()) {
            this.checkAndFix(this.getInventory());
        }
        this.firstTime = false;
        this.cargarInventarios();
    }

    public void checkAndFix(FileConfiguration fileConfiguration) {
        for (String string : fileConfiguration.getConfigurationSection("Inventories").getKeys(false)) {
            String string2 = "Inventories." + string;
            for (String string3 : fileConfiguration.getConfigurationSection(string2).getKeys(false)) {
                String string4 = String.valueOf(string2) + "." + string3;
                if (!fileConfiguration.contains(String.valueOf(string4) + ".id")) continue;
                String string5 = fileConfiguration.getString(String.valueOf(string4) + ".id");
                if (string5.equals("BLACK_STAINED_GLASS_PANE")) {
                    fileConfiguration.set(String.valueOf(string4) + ".id", (Object)"STAINED_GLASS_PANE:15");
                    continue;
                }
                if (string5.equals("BLUE_STAINED_GLASS_PANE")) {
                    fileConfiguration.set(String.valueOf(string4) + ".id", (Object)"STAINED_GLASS_PANE:11");
                    continue;
                }
                if (!string5.equals("WHITE_STAINED_GLASS_PANE")) continue;
                fileConfiguration.set(String.valueOf(string4) + ".id", (Object)"STAINED_GLASS_PANE");
            }
        }
        this.saveInventory();
        this.firstTime = false;
    }

    public void registerInventory() {
        this.inventoryFile = new File(this.plugin.getDataFolder(), "inventory.yml");
        this.rutaInventories = this.inventoryFile.getPath();
        if (!this.inventoryFile.exists()) {
            this.firstTime = true;
            this.getInventory().options().copyDefaults(true);
            this.saveInventory();
        }
    }

    public void saveInventory() {
        try {
            this.inventory.save(this.inventoryFile);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public FileConfiguration getInventory() {
        if (this.inventory == null) {
            this.reloadInventory();
        }
        return this.inventory;
    }

    public void reloadInventory() {
        if (this.inventory == null) {
            this.inventoryFile = new File(this.plugin.getDataFolder(), "inventory.yml");
        }
        this.inventory = YamlConfiguration.loadConfiguration((File)this.inventoryFile);
        if (this.firstTime) {
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(this.plugin.getResource("inventory.yml"), "UTF8");
                if (inputStreamReader != null) {
                    YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((Reader)inputStreamReader);
                    this.inventory.setDefaults((Configuration)yamlConfiguration);
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
        }
    }

    public String getPath() {
        return this.rutaInventories;
    }

    public void recargar() {
        this.reloadInventory();
        this.cargarInventarios();
    }

    public void cargarInventarios() {
        ArrayList<InventoryTurret> arrayList = new ArrayList<InventoryTurret>();
        FileConfiguration fileConfiguration = this.getInventory();
        if (fileConfiguration.contains("Inventories")) {
            for (String string : fileConfiguration.getConfigurationSection("Inventories").getKeys(false)) {
                Object object2;
                int n = 0;
                if (fileConfiguration.contains("Inventories." + string + ".slots")) {
                    n = Integer.valueOf(fileConfiguration.getString("Inventories." + string + ".slots"));
                }
                String string2 = fileConfiguration.getString("Inventories." + string + ".title");
                ArrayList<ItemInventoryTurret> arrayList2 = new ArrayList<ItemInventoryTurret>();
                for (Object object2 : fileConfiguration.getConfigurationSection("Inventories." + string).getKeys(false)) {
                    Object object3;
                    Object object4;
                    if (((String)object2).equals("slots") || ((String)object2).equals("title")) continue;
                    ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
                    String[] stringArray = ((String)object2).split(";");
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        if (stringArray[n2].contains("-")) {
                            object4 = stringArray[n2].split("-");
                            int n3 = Integer.valueOf(object4[0]);
                            int n4 = Integer.valueOf(object4[1]);
                            int n5 = n3;
                            while (n5 <= n4) {
                                arrayList3.add(n5);
                                ++n5;
                            }
                        } else {
                            arrayList3.add(Integer.valueOf(stringArray[n2]));
                        }
                        ++n2;
                    }
                    String string3 = "Inventories." + string + "." + (String)object2;
                    object4 = null;
                    if (fileConfiguration.contains(String.valueOf(string3) + ".type")) {
                        object4 = fileConfiguration.getString(String.valueOf(string3) + ".type");
                    }
                    String string4 = null;
                    if (fileConfiguration.contains(String.valueOf(string3) + ".name")) {
                        string4 = fileConfiguration.getString(String.valueOf(string3) + ".name");
                    }
                    List list = null;
                    if (fileConfiguration.contains(String.valueOf(string3) + ".lore")) {
                        list = fileConfiguration.getStringList(String.valueOf(string3) + ".lore");
                    }
                    ArrayList<String> arrayList4 = new ArrayList();
                    if (fileConfiguration.contains(String.valueOf(string3) + ".click_commands")) {
                        arrayList4 = fileConfiguration.getStringList(String.valueOf(string3) + ".click_commands");
                    }
                    ItemStack itemStack = null;
                    if (fileConfiguration.contains(String.valueOf(string3) + ".id")) {
                        try {
                            itemStack = ItemManager.crearItemInventory(fileConfiguration.getString(String.valueOf(string3) + ".id"));
                        }
                        catch (Exception exception) {}
                    }
                    if (fileConfiguration.contains(String.valueOf(string3) + ".custom_model_data")) {
                        int n6 = Integer.valueOf(fileConfiguration.getString(String.valueOf(string3) + ".custom_model_data"));
                        object3 = itemStack.getItemMeta();
                        object3.setCustomModelData(Integer.valueOf(n6));
                        itemStack.setItemMeta(object3);
                    }
                    String string5 = null;
                    if (fileConfiguration.contains(String.valueOf(string3) + ".open_inventory")) {
                        string5 = fileConfiguration.getString(String.valueOf(string3) + ".open_inventory");
                    }
                    object3 = new ItemInventoryTurret(arrayList3, (String)object4, itemStack, string4, list, arrayList4, string5);
                    arrayList2.add((ItemInventoryTurret)object3);
                }
                object2 = new InventoryTurret(string, n, string2, arrayList2);
                arrayList.add((InventoryTurret)object2);
            }
        }
        this.plugin.getInventoryManager().setInventories(arrayList);
    }
}

