/*
 * Decompiled with CFR 0.152.
 */
package ct.ajneb97.managers;

import ct.ajneb97.ComplexTurrets;
import ct.ajneb97.configs.InventoryConfigManager;
import ct.ajneb97.configs.TurretConfig;
import ct.ajneb97.managers.ItemManager;
import ct.ajneb97.managers.MensajesManager;
import ct.ajneb97.model.PlayerData;
import ct.ajneb97.model.PlayerTurret;
import ct.ajneb97.model.PluginError;
import ct.ajneb97.model.PluginErrorType;
import ct.ajneb97.model.estructura.Turret;
import ct.ajneb97.utils.UtilsEffects;
import ct.ajneb97.utils.UtilsOthers;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Sound;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class ErrorManager {
    private ComplexTurrets plugin;
    private ArrayList<PluginError> errors;
    private boolean pluginDisabled;

    public ErrorManager(ComplexTurrets complexTurrets) {
        this.plugin = complexTurrets;
        this.pluginDisabled = false;
    }

    public void reiniciar() {
        this.errors = new ArrayList();
        this.pluginDisabled = false;
        this.checkAll();
    }

    public boolean isPluginDisabled() {
        return this.pluginDisabled;
    }

    public void checkAll() {
        Object object;
        Object object52;
        ArrayList<PlayerData> arrayList = this.plugin.getJugadorManager().getPlayers();
        for (PlayerData object82 : arrayList) {
            for (PlayerTurret playerTurret : object82.getTurrets()) {
                Turret turret = this.plugin.getTurretsManager().getTurret(playerTurret.getTurretName());
                if (turret != null) continue;
                this.addInvalidTurretType(playerTurret.getTurretName(), String.valueOf(playerTurret.getOwnerUUID()) + ".yml");
            }
        }
        ArrayList<TurretConfig> arrayList2 = this.plugin.getConfigsManager().getTurretsConfigsManager().getConfigTurrets();
        for (Object object52 : arrayList2) {
            Object object2 = ((TurretConfig)object52).getConfig();
            String string = "turret.effects.shoot_effect.sound";
            this.addInvalidSound((FileConfiguration)object2, ((TurretConfig)object52).getPath(), string);
            String string2 = "turret.effects.impact_effect.sound";
            this.addInvalidSound((FileConfiguration)object2, ((TurretConfig)object52).getPath(), string2);
        }
        object52 = this.plugin.getConfig();
        FileConfiguration fileConfiguration = this.plugin.getConfigsManager().getInventoryConfigManager().getInventory();
        this.addInvalidSound((FileConfiguration)object52, "config.yml", "turret_destroy_sound");
        for (Object object2 : arrayList2) {
            Object object32;
            object = ((TurretConfig)object2).getConfig();
            List list = object.getStringList("turret.structure");
            for (Object object32 : list) {
                this.addInvalidMaterial((String)object32, ((TurretConfig)object2).getPath(), "turret.structure");
            }
            object32 = "items.block.id";
            this.addInvalidMaterial(object.getString((String)object32), ((TurretConfig)object2).getPath(), (String)object32);
            object32 = "items.ammunition.id";
            this.addInvalidMaterial(object.getString((String)object32), ((TurretConfig)object2).getPath(), (String)object32);
            object32 = "inventory.upgrade.id";
            this.addInvalidMaterial(object.getString((String)object32), ((TurretConfig)object2).getPath(), (String)object32);
            object32 = "inventory.last_upgrade.id";
            this.addInvalidMaterial(object.getString((String)object32), ((TurretConfig)object2).getPath(), (String)object32);
        }
        for (Object object2 : object52.getConfigurationSection("items").getKeys(false)) {
            object = "";
            if (object52.contains("items." + (String)object2 + ".id")) {
                String string = "items." + (String)object2 + ".id";
                object = object52.getString(string);
                this.addInvalidMaterial((String)object, "config.yml", string);
                continue;
            }
            String string = "items." + (String)object2 + ".id_enabled";
            this.addInvalidMaterial(object52.getString(string), "config.yml", string);
            String string3 = "items." + (String)object2 + ".id_disabled";
            this.addInvalidMaterial(object52.getString(string3), "config.yml", string3);
        }
        for (Object object2 : fileConfiguration.getConfigurationSection("Inventories").getKeys(false)) {
            object = "Inventories." + (String)object2;
            for (String string : fileConfiguration.getConfigurationSection((String)object).getKeys(false)) {
                String string4 = String.valueOf(object) + "." + string;
                if (!fileConfiguration.contains(String.valueOf(string4) + ".id")) continue;
                String string5 = String.valueOf(string4) + ".id";
                String string6 = fileConfiguration.getString(String.valueOf(string4) + ".id");
                this.addInvalidMaterial(string6, "inventory.yml", string5);
            }
        }
        for (Object object2 : arrayList2) {
            object = ((TurretConfig)object2).getConfig();
            String string = "turret.effects.shoot_effect.list_of_effects";
            this.addInvalidParticle((FileConfiguration)object, ((TurretConfig)object2).getPath(), string);
            String string7 = "turret.effects.impact_effect.list_of_effects";
            this.addInvalidParticle((FileConfiguration)object, ((TurretConfig)object2).getPath(), string7);
        }
        boolean bl = false;
        for (PlayerData playerData : arrayList) {
            for (PlayerTurret playerTurret : playerData.getTurrets()) {
                if (playerTurret.getLocation() != null && playerTurret.getLocation().getWorld() != null) continue;
                this.addInvalidWorld();
                bl = true;
            }
            if (bl) break;
        }
    }

    public void addInvalidParticle(FileConfiguration fileConfiguration, String string, String string2) {
        if (fileConfiguration.contains(string2)) {
            for (String string3 : fileConfiguration.getConfigurationSection(string2).getKeys(false)) {
                String string4 = fileConfiguration.getString(String.valueOf(string2) + "." + string3 + ".particle");
                if (UtilsEffects.particleExists(string4)) continue;
                PluginError pluginError = new PluginError(PluginErrorType.INVALID_PARTICLE, null, string, string4, String.valueOf(string2) + "." + string3 + ".particle", null, false);
                this.errors.add(pluginError);
            }
        }
    }

    public void addInvalidMaterial(String string, String string2, String string3) {
        if (!string.startsWith("ey")) {
            try {
                ItemManager.crearItem(string);
            }
            catch (Exception exception) {
                PluginError pluginError = new PluginError(PluginErrorType.INVALID_MATERIAL, null, string2, string, string3, null, true);
                this.errors.add(pluginError);
                this.pluginDisabled = true;
            }
        }
    }

    public void addInvalidTurretType(String string, String string2) {
        PluginError pluginError = new PluginError(PluginErrorType.INVALID_TURRET_TYPE, string, string2, null, null, null, true);
        this.errors.add(pluginError);
        this.pluginDisabled = true;
    }

    public void addInvalidWorld() {
        PluginError pluginError = new PluginError(PluginErrorType.INVALID_WORLD, null, null, null, null, null, true);
        this.errors.add(pluginError);
        this.pluginDisabled = true;
    }

    public void addInvalidSound(FileConfiguration fileConfiguration, String string, String string2) {
        if (fileConfiguration.contains(string2)) {
            String string3 = fileConfiguration.getString(string2);
            String[] stringArray = string3.split(";");
            try {
                Sound.valueOf((String)stringArray[0]);
            }
            catch (Exception exception) {
                PluginError pluginError = new PluginError(PluginErrorType.INVALID_SOUND, null, string, stringArray[0], string2, null, false);
                this.errors.add(pluginError);
            }
        }
    }

    public void sendMessage(Player player) {
        int n = 0;
        while (n < 20) {
            player.sendMessage(" ");
            ++n;
        }
        player.sendMessage(MensajesManager.getMensajeColor("&f&l- - - - - &b&lCOMPLEX TURRETS VERIFY &f&l- - - - -"));
        player.sendMessage(" ");
        n = 1;
        if (this.errors.isEmpty()) {
            player.sendMessage(MensajesManager.getMensajeColor("&aThere are no errors with the plugin ;)"));
        } else {
            for (PluginError pluginError : this.errors) {
                pluginError.sendMessage(player, n);
                player.sendMessage(" ");
                ++n;
            }
        }
        player.sendMessage(" ");
        player.sendMessage(MensajesManager.getMensajeColor("&f&l- - - - - &b&lCOMPLEX TURRETS VERIFY &f&l- - - - -"));
    }

    public void fixInvalidWorld(Player player) {
        ArrayList<PlayerData> arrayList = this.plugin.getJugadorManager().getPlayers();
        for (PlayerData playerData : arrayList) {
            ArrayList<PlayerTurret> arrayList2 = playerData.getTurrets();
            int n = 0;
            while (n < arrayList2.size()) {
                if (arrayList2.get(n).getLocation() == null || arrayList2.get(n).getLocation().getWorld() == null) {
                    arrayList2.get(n).remove();
                    arrayList2.remove(n);
                    --n;
                }
                ++n;
            }
        }
        this.fix(player);
    }

    public void fixInvalidTurretType(Player player, String string, String string2) {
        PlayerData playerData = this.plugin.getJugadorManager().getPlayerDataByUUID(string2.replace(".yml", ""));
        if (playerData != null) {
            ArrayList<PlayerTurret> arrayList = playerData.getTurrets();
            int n = 0;
            while (n < arrayList.size()) {
                if (arrayList.get(n).getTurretName().equals(string)) {
                    arrayList.get(n).remove();
                    arrayList.remove(n);
                    --n;
                }
                ++n;
            }
            this.fix(player);
        }
    }

    public void fixInvalidSound(Player player, String string, String string2) {
        ArrayList<TurretConfig> arrayList = this.plugin.getConfigsManager().getTurretsConfigsManager().getConfigTurrets();
        for (TurretConfig turretConfig : arrayList) {
            if (!turretConfig.getPath().equals(string2)) continue;
            FileConfiguration fileConfiguration = turretConfig.getConfig();
            if (UtilsOthers.isLegacy()) {
                fileConfiguration.set(string, (Object)"NOTE_PLING;1;2");
            } else {
                fileConfiguration.set(string, (Object)"BLOCK_NOTE_BLOCK_PLING;1;2");
            }
            turretConfig.saveTurretConfig();
            this.fix(player);
            break;
        }
    }

    public void fixInvalidParticle(Player player, String string, String string2) {
        ArrayList<TurretConfig> arrayList = this.plugin.getConfigsManager().getTurretsConfigsManager().getConfigTurrets();
        for (TurretConfig turretConfig : arrayList) {
            if (!turretConfig.getPath().equals(string2)) continue;
            FileConfiguration fileConfiguration = turretConfig.getConfig();
            fileConfiguration.set(string, (Object)"CRIT");
            turretConfig.saveTurretConfig();
            this.fix(player);
            break;
        }
    }

    public void fixInvalidMaterial(Player player, String string, String string2, String string3) {
        ArrayList<TurretConfig> arrayList = this.plugin.getConfigsManager().getTurretsConfigsManager().getConfigTurrets();
        if (string2.equals("config.yml")) {
            FileConfiguration fileConfiguration = this.plugin.getConfig();
            fileConfiguration.set(string, (Object)"STONE");
            this.plugin.saveConfig();
            this.fix(player);
        } else if (string2.equals("inventory.yml")) {
            InventoryConfigManager inventoryConfigManager = this.plugin.getConfigsManager().getInventoryConfigManager();
            FileConfiguration fileConfiguration = inventoryConfigManager.getInventory();
            fileConfiguration.set(string, (Object)"STONE");
            inventoryConfigManager.saveInventory();
            this.fix(player);
        } else {
            for (TurretConfig turretConfig : arrayList) {
                if (!turretConfig.getPath().equals(string2)) continue;
                FileConfiguration fileConfiguration = turretConfig.getConfig();
                if (fileConfiguration.isList(string)) {
                    List list = fileConfiguration.getStringList(string);
                    int n = 0;
                    while (n < list.size()) {
                        if (((String)list.get(n)).equals(string3)) {
                            list.set(n, "STONE");
                        }
                        ++n;
                    }
                    fileConfiguration.set(string, (Object)list);
                } else {
                    fileConfiguration.set(string, (Object)"STONE");
                }
                turretConfig.saveTurretConfig();
                this.fix(player);
                break;
            }
        }
    }

    public void fix(Player player) {
        String string = "BLOCK_NOTE_BLOCK_PLING;1;2";
        if (UtilsOthers.isLegacy()) {
            string = "NOTE_PLING;1;2";
        }
        UtilsEffects.playSoundPlayer(player, string, this.plugin);
        this.plugin.recargarConfigs();
        this.sendMessage(player);
    }
}

