/*
 * Decompiled with CFR 0.152.
 */
package ct.ajneb97.managers;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WGBukkit;
import com.sk89q.worldguard.domains.DefaultDomain;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import ct.ajneb97.ComplexTurrets;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class WorldGuardManager {
    private ComplexTurrets plugin;
    private int version;

    public WorldGuardManager(ComplexTurrets complexTurrets) {
        this.plugin = complexTurrets;
        this.version = this.getVersion();
    }

    public int getVersion() {
        String string = Bukkit.getServer().getPluginManager().getPlugin("WorldGuard").getDescription().getVersion();
        if (string.startsWith("6")) {
            return 6;
        }
        return 7;
    }

    public boolean isOwnerCurrentRegion(Location location, Player player) {
        ApplicableRegionSet applicableRegionSet = this.getRegionsFromLocation(location);
        for (ProtectedRegion protectedRegion : applicableRegionSet) {
            DefaultDomain defaultDomain = protectedRegion.getOwners();
            for (UUID uUID : defaultDomain.getUniqueIds()) {
                if (!uUID.toString().equals(player.getUniqueId().toString())) continue;
                return true;
            }
        }
        return false;
    }

    public ApplicableRegionSet getRegionsFromLocation(Location location) {
        if (this.version == 6) {
            RegionManager regionManager = WGBukkit.getRegionManager((World)location.getWorld());
            ApplicableRegionSet applicableRegionSet = regionManager.getApplicableRegions(location);
            return applicableRegionSet;
        }
        com.sk89q.worldedit.util.Location location2 = BukkitAdapter.adapt((Location)location);
        RegionContainer regionContainer = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionQuery regionQuery = regionContainer.createQuery();
        ApplicableRegionSet applicableRegionSet = regionQuery.getApplicableRegions(location2);
        return applicableRegionSet;
    }
}

