/*
 * Decompiled with CFR 0.152.
 */
package ct.ajneb97.tasks;

import ct.ajneb97.ComplexTurrets;
import ct.ajneb97.model.PlayerTurret;
import ct.ajneb97.model.estructura.Turret;
import ct.ajneb97.model.estructura.TurretUpgrade;
import ct.ajneb97.utils.UtilsEffects;
import ct.ajneb97.utils.UtilsMath;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class ParabolicShootTask {
    private ComplexTurrets plugin;
    private Turret turret;
    private PlayerTurret playerTurret;
    private TurretUpgrade turretUpgrade;
    double currentLength;

    public ParabolicShootTask(ComplexTurrets complexTurrets, Turret turret, PlayerTurret playerTurret, TurretUpgrade turretUpgrade) {
        this.plugin = complexTurrets;
        this.turret = turret;
        this.playerTurret = playerTurret;
        this.turretUpgrade = turretUpgrade;
    }

    public void startParabolic(Location location, final Location location2) {
        final double d = location2.distance(location);
        Location location3 = location2.clone();
        location3.setY(location.getY());
        Vector vector = location2.toVector().clone();
        double d2 = vector.getY();
        final Vector vector2 = location.toVector().clone();
        double d3 = vector2.getY();
        double d4 = 0.0;
        d4 = d2 >= d3 ? d2 + 2.0 : d3 + 2.0;
        final double d5 = (2.0 * d2 - 4.0 * d4 + 2.0 * d3) / Math.pow(d, 2.0);
        final double d6 = (4.0 * d4 - d2 - 3.0 * d3) / d;
        final double d7 = d3;
        double d8 = d / this.turret.getShootEffect().getParabolicSeparation();
        long l = (long)(this.turret.getShootEffect().getParabolicSpeed() * 20.0);
        final Vector vector3 = vector.clone().subtract(vector2).normalize().multiply(d8);
        final World world = location2.getWorld();
        this.currentLength = 0.0;
        final double d9 = d8;
        final boolean bl = this.plugin.getConfigsManager().getMainConfigManager().isForceParticles();
        new BukkitRunnable(){

            public void run() {
                if (!ParabolicShootTask.this.execute(d5, d6, d7, vector3, vector2, world, d, d9, bl)) {
                    ParabolicShootTask.this.end(location2, bl);
                    this.cancel();
                }
            }
        }.runTaskTimerAsynchronously((Plugin)this.plugin, 0L, l);
    }

    public boolean execute(double d, double d2, double d3, Vector vector, Vector vector2, World world, double d4, double d5, boolean bl) {
        double d6 = UtilsMath.calculateParabolicAltitude(d, d2, d3, this.currentLength);
        vector2.add(vector);
        Location location = new Location(world, vector2.getX(), d6, vector2.getZ());
        if (this.currentLength >= d4) {
            return false;
        }
        UtilsEffects.turretEffectAtLocation(location, this.turret.getShootEffect(), vector, bl);
        this.currentLength += d5;
        return true;
    }

    public void end(Location location, boolean bl) {
        UtilsEffects.playSound(location, this.turret.getImpactEffect().getSound(), this.plugin);
        UtilsEffects.turretEffectAtLocation(location, this.turret.getImpactEffect(), null, bl);
        this.plugin.getShootManager().hitEntity(null, location, this.turret, this.playerTurret, this.turretUpgrade);
    }
}

