/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketContainer;
import java.util.TimeZone;
import net.momirealms.customnameplates.api.CustomNameplatesAPI;
import net.momirealms.customnameplates.command.BubblesCommand;
import net.momirealms.customnameplates.command.NameplateCommand;
import net.momirealms.customnameplates.helper.LibraryLoader;
import net.momirealms.customnameplates.helper.VersionHelper;
import net.momirealms.customnameplates.libs.net.kyori.adventure.platform.bukkit.BukkitAudiences;
import net.momirealms.customnameplates.libs.org.bstats.bukkit.Metrics;
import net.momirealms.customnameplates.manager.ActionBarManager;
import net.momirealms.customnameplates.manager.BackgroundManager;
import net.momirealms.customnameplates.manager.BossBarManager;
import net.momirealms.customnameplates.manager.ChatBubblesManager;
import net.momirealms.customnameplates.manager.ConfigManager;
import net.momirealms.customnameplates.manager.DataManager;
import net.momirealms.customnameplates.manager.FontManager;
import net.momirealms.customnameplates.manager.ImageManager;
import net.momirealms.customnameplates.manager.MessageManager;
import net.momirealms.customnameplates.manager.NameplateManager;
import net.momirealms.customnameplates.manager.PlaceholderManager;
import net.momirealms.customnameplates.manager.ResourceManager;
import net.momirealms.customnameplates.manager.TeamManager;
import net.momirealms.customnameplates.object.scheduler.Scheduler;
import net.momirealms.customnameplates.object.scheduler.SchedulerPlatform;
import net.momirealms.customnameplates.utils.AdventureUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class CustomNameplates
extends JavaPlugin {
    private static CustomNameplates plugin;
    private static BukkitAudiences adventure;
    private static ProtocolManager protocolManager;
    private ResourceManager resourceManager;
    private BossBarManager bossBarManager;
    private ActionBarManager actionBarManager;
    private PlaceholderManager placeholderManager;
    private NameplateManager nameplateManager;
    private ChatBubblesManager chatBubblesManager;
    private DataManager dataManager;
    private ConfigManager configManager;
    private MessageManager messageManager;
    private FontManager fontManager;
    private VersionHelper versionHelper;
    private TeamManager teamManager;
    private BackgroundManager backgroundManager;
    private ImageManager imageManager;
    private CustomNameplatesAPI customNameplatesAPI;
    private Scheduler scheduler;

    public void onLoad() {
        plugin = this;
        this.loadLibs();
    }

    public void onEnable() {
        adventure = BukkitAudiences.create((Plugin)this);
        protocolManager = ProtocolLibrary.getProtocolManager();
        AdventureUtils.consoleMessage("[CustomNameplates] Running on <white>" + Bukkit.getVersion());
        this.fix();
        this.versionHelper = new VersionHelper(this);
        this.scheduler = new Scheduler(this);
        this.configManager = new ConfigManager();
        this.messageManager = new MessageManager();
        this.teamManager = new TeamManager(this);
        this.placeholderManager = new PlaceholderManager(this);
        this.actionBarManager = new ActionBarManager(this);
        this.bossBarManager = new BossBarManager(this);
        this.resourceManager = new ResourceManager(this);
        this.dataManager = new DataManager(this);
        this.nameplateManager = new NameplateManager(this);
        this.backgroundManager = new BackgroundManager(this);
        this.fontManager = new FontManager(this);
        this.imageManager = new ImageManager(this);
        this.chatBubblesManager = new ChatBubblesManager(this);
        this.customNameplatesAPI = new CustomNameplatesAPI(this);
        this.customNameplatesAPI.init();
        this.registerCommands();
        this.reload(false);
        AdventureUtils.consoleMessage("[CustomNameplates] Plugin Enabled!");
        if (ConfigManager.enableBStats) {
            new Metrics(this, 16649);
        }
        if (ConfigManager.checkUpdate) {
            this.versionHelper.checkUpdate();
        }
        if (ConfigManager.generatePackOnStart) {
            this.resourceManager.generateResourcePack();
        }
    }

    public void onDisable() {
        if (this.actionBarManager != null) {
            this.actionBarManager.unload();
        }
        if (this.nameplateManager != null) {
            this.nameplateManager.unload();
        }
        if (this.bossBarManager != null) {
            this.bossBarManager.unload();
        }
        if (this.chatBubblesManager != null) {
            this.chatBubblesManager.unload();
        }
        if (this.placeholderManager != null) {
            this.placeholderManager.unload();
        }
        if (this.fontManager != null) {
            this.fontManager.unload();
        }
        if (this.teamManager != null) {
            this.teamManager.unload();
        }
        if (this.imageManager != null) {
            this.imageManager.unload();
        }
        if (this.backgroundManager != null) {
            this.backgroundManager.unload();
        }
        if (this.dataManager != null) {
            this.dataManager.disable();
        }
        if (adventure != null) {
            adventure.close();
        }
    }

    private void loadLibs() {
        TimeZone timeZone = TimeZone.getDefault();
        String libRepo = timeZone.getID().startsWith("Asia") ? "https://maven.aliyun.com/repository/public/" : "https://repo.maven.apache.org/maven2/";
        LibraryLoader.load("commons-io", "commons-io", "2.13.0", libRepo);
        LibraryLoader.load("org.apache.commons", "commons-lang3", "3.13.0", libRepo);
        LibraryLoader.load("com.zaxxer", "HikariCP", "5.0.1", libRepo);
        LibraryLoader.load("dev.dejvokep", "boosted-yaml", "1.3.1", libRepo);
        LibraryLoader.load("org.mariadb.jdbc", "mariadb-java-client", "3.1.4", libRepo);
        LibraryLoader.load("mysql", "mysql-connector-java", "8.0.30", libRepo);
    }

    private void registerCommands() {
        NameplateCommand nameplateCommand = new NameplateCommand();
        PluginCommand main = Bukkit.getPluginCommand((String)"customnameplates");
        if (main != null) {
            main.setExecutor((CommandExecutor)nameplateCommand);
            main.setTabCompleter((TabCompleter)nameplateCommand);
        }
        BubblesCommand bubblesCommand = new BubblesCommand();
        PluginCommand bubble = Bukkit.getPluginCommand((String)"bubbles");
        if (bubble != null) {
            bubble.setExecutor((CommandExecutor)bubblesCommand);
            bubble.setTabCompleter((TabCompleter)bubblesCommand);
        }
    }

    private void fix() {
        new PacketContainer(PacketType.Play.Server.SCOREBOARD_TEAM);
    }

    public void reload(boolean generate) {
        this.configManager.unload();
        this.messageManager.unload();
        this.bossBarManager.unload();
        this.actionBarManager.unload();
        this.placeholderManager.unload();
        this.nameplateManager.unload();
        this.teamManager.unload();
        this.chatBubblesManager.unload();
        this.imageManager.unload();
        this.fontManager.unload();
        this.backgroundManager.unload();
        this.dataManager.unload();
        this.configManager.load();
        this.messageManager.load();
        this.dataManager.load();
        this.imageManager.load();
        this.fontManager.load();
        this.teamManager.load();
        this.nameplateManager.load();
        this.chatBubblesManager.load();
        this.backgroundManager.load();
        this.bossBarManager.load();
        this.actionBarManager.load();
        this.placeholderManager.load();
        if (generate) {
            this.resourceManager.generateResourcePack();
        }
    }

    public static CustomNameplates getInstance() {
        return plugin;
    }

    public static BukkitAudiences getAdventure() {
        return adventure;
    }

    public static ProtocolManager getProtocolManager() {
        return protocolManager;
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public DataManager getDataManager() {
        return this.dataManager;
    }

    public PlaceholderManager getPlaceholderManager() {
        return this.placeholderManager;
    }

    public BossBarManager getBossBarManager() {
        return this.bossBarManager;
    }

    public ActionBarManager getActionBarManager() {
        return this.actionBarManager;
    }

    public NameplateManager getNameplateManager() {
        return this.nameplateManager;
    }

    public ChatBubblesManager getChatBubblesManager() {
        return this.chatBubblesManager;
    }

    public VersionHelper getVersionHelper() {
        return this.versionHelper;
    }

    public FontManager getFontManager() {
        return this.fontManager;
    }

    public TeamManager getTeamManager() {
        return this.teamManager;
    }

    public BackgroundManager getBackgroundManager() {
        return this.backgroundManager;
    }

    public ImageManager getImageManager() {
        return this.imageManager;
    }

    public CustomNameplatesAPI getAPI() {
        return this.customNameplatesAPI;
    }

    public SchedulerPlatform getScheduler() {
        return this.scheduler.getInstance();
    }
}

