/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.bungeecord;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.util.Objects;
import java.util.Optional;
import me.neznamy.tab.api.TabAPI;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.tablist.SortingManager;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.PluginMessageEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.event.EventHandler;
import net.momirealms.customnameplates.bungeecord.CustomNameplatesBC;

public class BungeeEventListener
implements Listener {
    private final CustomNameplatesBC plugin;
    private final SortingManager sortingManager;

    public BungeeEventListener(CustomNameplatesBC plugin) {
        this.plugin = plugin;
        this.sortingManager = TabAPI.getInstance().getSortingManager();
    }

    @EventHandler
    public void onReceived(PluginMessageEvent event) {
        String channel = event.getTag();
        if (event.isCancelled() || !Objects.equals("customnameplates:cnp", channel)) {
            return;
        }
        ByteArrayDataInput dataInput = ByteStreams.newDataInput((byte[])event.getData());
        this.parseMessage(dataInput);
    }

    private void parseMessage(ByteArrayDataInput dataInput) {
        TabPlayer tabPlayer;
        String playerName;
        String teamName = playerName = dataInput.readUTF();
        if (this.plugin.getBungeeConfig().isTab() && (tabPlayer = TabAPI.getInstance().getPlayer(playerName)) != null) {
            teamName = Optional.ofNullable(this.sortingManager.getOriginalTeamName(tabPlayer)).orElse(playerName);
        }
        ProxiedPlayer proxiedPlayer = this.plugin.getProxy().getPlayer(playerName);
        ByteArrayDataOutput byteArrayDataOutput = ByteStreams.newDataOutput();
        byteArrayDataOutput.writeUTF(playerName);
        byteArrayDataOutput.writeUTF(teamName);
        proxiedPlayer.getServer().sendData("customnameplates:cnp", byteArrayDataOutput.toByteArray());
    }
}

