/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.command;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.momirealms.customnameplates.CustomNameplates;
import net.momirealms.customnameplates.api.CustomNameplatesAPI;
import net.momirealms.customnameplates.manager.MessageManager;
import net.momirealms.customnameplates.utils.AdventureUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;

public abstract class AbstractSubCommand {
    private final String command;
    private Map<String, AbstractSubCommand> subCommandMap;

    public AbstractSubCommand(String command) {
        this.command = command;
    }

    public boolean onCommand(CommandSender sender, List<String> args) {
        if (this.subCommandMap == null || args.size() < 1) {
            return true;
        }
        AbstractSubCommand subCommand = this.subCommandMap.get(args.get(0));
        if (subCommand == null) {
            AdventureUtils.sendMessage(sender, MessageManager.prefix + MessageManager.unavailableArgs);
        } else {
            subCommand.onCommand(sender, args.subList(1, args.size()));
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, List<String> args) {
        if (this.subCommandMap == null) {
            return Collections.singletonList("");
        }
        if (args.size() <= 1) {
            ArrayList<String> returnList = new ArrayList<String>(this.subCommandMap.keySet());
            returnList.removeIf(str -> !str.startsWith((String)args.get(0)));
            return returnList;
        }
        AbstractSubCommand subCmd = this.subCommandMap.get(args.get(0));
        if (subCmd != null) {
            return this.subCommandMap.get(args.get(0)).onTabComplete(sender, args.subList(1, args.size()));
        }
        return Collections.singletonList("");
    }

    public String getSubCommand() {
        return this.command;
    }

    public Map<String, AbstractSubCommand> getSubCommands() {
        return Collections.unmodifiableMap(this.subCommandMap);
    }

    public void regSubCommand(AbstractSubCommand command) {
        if (this.subCommandMap == null) {
            this.subCommandMap = new ConcurrentHashMap<String, AbstractSubCommand>();
        }
        this.subCommandMap.put(command.getSubCommand(), command);
    }

    protected List<String> online_players() {
        return Bukkit.getOnlinePlayers().stream().map(HumanEntity::getName).collect(Collectors.toList());
    }

    protected List<String> allNameplates() {
        return new ArrayList<String>(CustomNameplates.getInstance().getNameplateManager().getNameplateConfigMap().keySet());
    }

    protected List<String> allBubbles() {
        return new ArrayList<String>(CustomNameplates.getInstance().getChatBubblesManager().getBubbleConfigMap().keySet());
    }

    protected boolean notExist(CommandSender commandSender, String type, String value) {
        if (type.equals("nameplate")) {
            if (!CustomNameplatesAPI.getInstance().doesNameplateExist(value)) {
                AdventureUtils.sendMessage(commandSender, MessageManager.prefix + MessageManager.np_not_exist);
                return true;
            }
        } else if (type.equals("bubble") && !CustomNameplatesAPI.getInstance().doesBubbleExist(value)) {
            AdventureUtils.sendMessage(commandSender, MessageManager.prefix + MessageManager.bb_not_exist);
            return true;
        }
        return false;
    }

    protected boolean noConsoleExecute(CommandSender commandSender) {
        if (!(commandSender instanceof Player)) {
            AdventureUtils.consoleMessage(MessageManager.prefix + MessageManager.no_console);
            return true;
        }
        return false;
    }

    protected boolean lackArgs(CommandSender commandSender, int required, int current) {
        if (required > current) {
            AdventureUtils.sendMessage(commandSender, MessageManager.prefix + MessageManager.lackArgs);
            return true;
        }
        return false;
    }

    protected boolean playerNotOnline(CommandSender commandSender, String player) {
        if (Bukkit.getPlayer((String)player) == null) {
            AdventureUtils.sendMessage(commandSender, MessageManager.prefix + MessageManager.not_online.replace("{Player}", player));
            return true;
        }
        return false;
    }

    protected List<String> filterStartingWith(List<String> list, String prefix) {
        return list.stream().filter(s -> s.startsWith(prefix)).collect(Collectors.toList());
    }
}

