/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.listener.compatibility;

import com.francobm.magicosmetics.api.Cosmetic;
import com.francobm.magicosmetics.api.CosmeticType;
import com.francobm.magicosmetics.cache.cosmetics.Hat;
import com.francobm.magicosmetics.events.CosmeticChangeEquipEvent;
import com.francobm.magicosmetics.events.CosmeticEquipEvent;
import com.francobm.magicosmetics.events.CosmeticUnEquipEvent;
import com.francobm.magicosmetics.events.PlayerDataLoadEvent;
import net.momirealms.customnameplates.object.carrier.NamedEntityCarrier;
import net.momirealms.customnameplates.object.carrier.NamedEntityManager;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class MagicCosmeticsListener
implements Listener {
    private final NamedEntityCarrier namedEntityCarrier;

    public MagicCosmeticsListener(NamedEntityCarrier namedEntityCarrier) {
        this.namedEntityCarrier = namedEntityCarrier;
    }

    @EventHandler
    public void onChangeCos(CosmeticChangeEquipEvent event) {
        Cosmetic cosmetic = event.getNewCosmetic();
        Player player = event.getPlayer();
        if (cosmetic instanceof Hat) {
            Hat hat = (Hat)cosmetic;
            NamedEntityManager nem = this.namedEntityCarrier.getNamedEntityManager(player);
            if (nem != null) {
                nem.setHatOffset(hat.isHideCosmetic() ? 0.0 : hat.getOffSetY());
            }
        }
    }

    @EventHandler
    public void onEquip(CosmeticEquipEvent event) {
        Cosmetic cosmetic = event.getCosmetic();
        Player player = event.getPlayer();
        if (cosmetic instanceof Hat) {
            Hat hat = (Hat)cosmetic;
            NamedEntityManager nem = this.namedEntityCarrier.getNamedEntityManager(player);
            if (nem != null) {
                nem.setHatOffset(hat.isHideCosmetic() ? 0.0 : hat.getOffSetY());
            }
        }
    }

    @EventHandler
    public void onUnEquip(CosmeticUnEquipEvent event) {
        NamedEntityManager nem;
        Player player = event.getPlayer();
        if (event.getCosmeticType() == CosmeticType.HAT && (nem = this.namedEntityCarrier.getNamedEntityManager(player)) != null) {
            nem.setHatOffset(0.0);
        }
    }

    @EventHandler
    public void onDataLoaded(PlayerDataLoadEvent event) {
        for (Cosmetic cosmetic : event.getEquippedCosmetics()) {
            if (!(cosmetic instanceof Hat)) continue;
            Hat hat = (Hat)cosmetic;
            NamedEntityManager nem = this.namedEntityCarrier.getNamedEntityManager(event.getPlayerData().getOfflinePlayer().getPlayer());
            if (nem == null) continue;
            nem.setHatOffset(hat.isHideCosmetic() ? 0.0 : hat.getOffSetY());
        }
    }
}

