/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.object.scheduler;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import net.momirealms.customnameplates.CustomNameplates;
import net.momirealms.customnameplates.object.scheduler.BukkitTimerTask;
import net.momirealms.customnameplates.object.scheduler.SchedulerPlatform;
import net.momirealms.customnameplates.object.scheduler.TimerTask;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class BukkitSchedulerImpl
implements SchedulerPlatform {
    private final CustomNameplates plugin;

    public BukkitSchedulerImpl(CustomNameplates plugin) {
        this.plugin = plugin;
    }

    @Override
    public <T> Future<T> callSyncMethod(@NotNull Callable<T> task) {
        return Bukkit.getScheduler().callSyncMethod((Plugin)this.plugin, task);
    }

    @Override
    public void runTask(Runnable runnable, Location location) {
        Bukkit.getScheduler().runTask((Plugin)this.plugin, runnable);
    }

    @Override
    public void runTaskLater(Runnable runnable, Location location, long delay) {
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, runnable, delay);
    }

    @Override
    public void runTaskAsync(Runnable runnable) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, runnable);
    }

    @Override
    public void runTaskAsyncLater(Runnable runnable, long delay) {
        Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this.plugin, runnable, delay);
    }

    @Override
    public TimerTask runTaskAsyncTimer(Runnable runnable, long delay, long interval) {
        return new BukkitTimerTask(Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, runnable, delay, interval));
    }

    @Override
    public TimerTask runTaskTimer(Runnable runnable, Location location, long delay, long interval) {
        return new BukkitTimerTask(Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, runnable, delay, interval));
    }
}

