/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.utils;

import net.momirealms.customnameplates.CustomNameplates;
import net.momirealms.customnameplates.libs.net.kyori.adventure.audience.Audience;
import net.momirealms.customnameplates.libs.net.kyori.adventure.text.Component;
import net.momirealms.customnameplates.libs.net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AdventureUtils {
    public static Component getComponentFromMiniMessage(String text) {
        return MiniMessage.miniMessage().deserialize(AdventureUtils.replaceLegacy(text));
    }

    public static void sendMessage(CommandSender sender, String s) {
        if (s == null) {
            return;
        }
        if (sender instanceof Player) {
            Player player = (Player)sender;
            AdventureUtils.playerMessage(player, s);
        } else {
            AdventureUtils.consoleMessage(s);
        }
    }

    public static void consoleMessage(String s) {
        if (s == null) {
            return;
        }
        Audience au = CustomNameplates.getAdventure().sender((CommandSender)Bukkit.getConsoleSender());
        au.sendMessage(AdventureUtils.getComponentFromMiniMessage(s));
    }

    public static void playerMessage(Player player, String s) {
        if (s == null) {
            return;
        }
        Audience au = CustomNameplates.getAdventure().player(player);
        au.sendMessage(AdventureUtils.getComponentFromMiniMessage(s));
    }

    public static void playerActionbar(Player player, Component component) {
        Audience au = CustomNameplates.getAdventure().player(player);
        au.sendActionBar(component);
    }

    public static String replaceLegacy(String legacy) {
        StringBuilder stringBuilder = new StringBuilder();
        char[] chars = legacy.toCharArray();
        block25: for (int i = 0; i < chars.length; ++i) {
            if (AdventureUtils.isColorCode(chars[i])) {
                if (i + 1 < chars.length) {
                    switch (chars[i + 1]) {
                        case '0': {
                            stringBuilder.append("<black>");
                            break;
                        }
                        case '1': {
                            stringBuilder.append("<dark_blue>");
                            break;
                        }
                        case '2': {
                            stringBuilder.append("<dark_green>");
                            break;
                        }
                        case '3': {
                            stringBuilder.append("<dark_aqua>");
                            break;
                        }
                        case '4': {
                            stringBuilder.append("<dark_red>");
                            break;
                        }
                        case '5': {
                            stringBuilder.append("<dark_purple>");
                            break;
                        }
                        case '6': {
                            stringBuilder.append("<gold>");
                            break;
                        }
                        case '7': {
                            stringBuilder.append("<gray>");
                            break;
                        }
                        case '8': {
                            stringBuilder.append("<dark_gray>");
                            break;
                        }
                        case '9': {
                            stringBuilder.append("<blue>");
                            break;
                        }
                        case 'a': {
                            stringBuilder.append("<green>");
                            break;
                        }
                        case 'b': {
                            stringBuilder.append("<aqua>");
                            break;
                        }
                        case 'c': {
                            stringBuilder.append("<red>");
                            break;
                        }
                        case 'd': {
                            stringBuilder.append("<light_purple>");
                            break;
                        }
                        case 'e': {
                            stringBuilder.append("<yellow>");
                            break;
                        }
                        case 'f': {
                            stringBuilder.append("<white>");
                            break;
                        }
                        case 'r': {
                            stringBuilder.append("<reset><!italic>");
                            break;
                        }
                        case 'l': {
                            stringBuilder.append("<bold>");
                            break;
                        }
                        case 'm': {
                            stringBuilder.append("<strikethrough>");
                            break;
                        }
                        case 'o': {
                            stringBuilder.append("<italic>");
                            break;
                        }
                        case 'n': {
                            stringBuilder.append("<underlined>");
                            break;
                        }
                        case 'k': {
                            stringBuilder.append("<obfuscated>");
                            break;
                        }
                        case 'x': {
                            if (!(i + 13 < chars.length && AdventureUtils.isColorCode(chars[i + 2]) && AdventureUtils.isColorCode(chars[i + 4]) && AdventureUtils.isColorCode(chars[i + 6]) && AdventureUtils.isColorCode(chars[i + 8]) && AdventureUtils.isColorCode(chars[i + 10]) && AdventureUtils.isColorCode(chars[i + 12]))) {
                                stringBuilder.append(chars[i]);
                                continue block25;
                            }
                            stringBuilder.append("<#").append(chars[i + 3]).append(chars[i + 5]).append(chars[i + 7]).append(chars[i + 9]).append(chars[i + 11]).append(chars[i + 13]).append(">");
                            i += 12;
                            break;
                        }
                        default: {
                            stringBuilder.append(chars[i]);
                            continue block25;
                        }
                    }
                    ++i;
                    continue;
                }
                stringBuilder.append(chars[i]);
                continue;
            }
            stringBuilder.append(chars[i]);
        }
        return stringBuilder.toString();
    }

    private static boolean isColorCode(char c) {
        return c == '\u00a7' || c == '&';
    }

    public static int colorToDecimal(ChatColor color) {
        switch (String.valueOf(color.getChar())) {
            case "0": {
                return 0;
            }
            case "c": {
                return 0xFF5555;
            }
            case "6": {
                return 0xFFAA00;
            }
            case "4": {
                return 0xAA0000;
            }
            case "e": {
                return 0xFFFF55;
            }
            case "2": {
                return 43520;
            }
            case "a": {
                return 0x55FF55;
            }
            case "b": {
                return 0x55FFFF;
            }
            case "3": {
                return 43690;
            }
            case "1": {
                return 170;
            }
            case "9": {
                return 0x5555FF;
            }
            case "d": {
                return 0xFF55FF;
            }
            case "5": {
                return 0xAA00AA;
            }
            case "8": {
                return 0x555555;
            }
            case "7": {
                return 0xAAAAAA;
            }
        }
        return 0xFFFFFF;
    }

    public static String stripAllTags(String text) {
        return MiniMessage.miniMessage().stripTags(AdventureUtils.replaceLegacy(text));
    }

    public static String getMiniMessageFormat(Component component) {
        return (String)MiniMessage.miniMessage().serialize(component);
    }
}

