/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.api.mechanic.background;

import net.momirealms.customnameplates.api.mechanic.character.ConfiguredChar;
import net.momirealms.customnameplates.api.mechanic.font.OffsetFont;

public class BackGround {
    private ConfiguredChar left;
    private ConfiguredChar offset_1;
    private ConfiguredChar offset_2;
    private ConfiguredChar offset_4;
    private ConfiguredChar offset_8;
    private ConfiguredChar offset_16;
    private ConfiguredChar offset_32;
    private ConfiguredChar offset_64;
    private ConfiguredChar offset_128;
    private ConfiguredChar right;
    private int leftMargin;
    private int rightMargin;

    private BackGround() {
    }

    public BackGround(ConfiguredChar left, ConfiguredChar offset_1, ConfiguredChar offset_2, ConfiguredChar offset_4, ConfiguredChar offset_8, ConfiguredChar offset_16, ConfiguredChar offset_32, ConfiguredChar offset_64, ConfiguredChar offset_128, ConfiguredChar right, int leftMargin, int rightMargin, boolean removeShadow) {
        this.left = left;
        this.offset_1 = offset_1;
        this.offset_2 = offset_2;
        this.offset_4 = offset_4;
        this.offset_8 = offset_8;
        this.offset_16 = offset_16;
        this.offset_32 = offset_32;
        this.offset_64 = offset_64;
        this.offset_128 = offset_128;
        this.right = right;
        this.leftMargin = leftMargin;
        this.rightMargin = rightMargin;
    }

    public ConfiguredChar getLeft() {
        return this.left;
    }

    public ConfiguredChar getOffset_1() {
        return this.offset_1;
    }

    public ConfiguredChar getOffset_2() {
        return this.offset_2;
    }

    public ConfiguredChar getOffset_4() {
        return this.offset_4;
    }

    public ConfiguredChar getOffset_8() {
        return this.offset_8;
    }

    public ConfiguredChar getOffset_16() {
        return this.offset_16;
    }

    public ConfiguredChar getOffset_32() {
        return this.offset_32;
    }

    public ConfiguredChar getOffset_64() {
        return this.offset_64;
    }

    public ConfiguredChar getOffset_128() {
        return this.offset_128;
    }

    public ConfiguredChar getRight() {
        return this.right;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getBackGroundImage(int n) {
        String offset = OffsetFont.getShortestNegChars(n + this.rightMargin + 2);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.left.getCharacter());
        for (n = n + this.leftMargin + this.rightMargin + 2; n >= 128; n -= 128) {
            stringBuilder.append(OffsetFont.NEG_1.getCharacter());
            stringBuilder.append(this.offset_128.getCharacter());
        }
        if (n - 64 >= 0) {
            stringBuilder.append(OffsetFont.NEG_1.getCharacter());
            stringBuilder.append(this.offset_64.getCharacter());
            n -= 64;
        }
        if (n - 32 >= 0) {
            stringBuilder.append(OffsetFont.NEG_1.getCharacter());
            stringBuilder.append(this.offset_32.getCharacter());
            n -= 32;
        }
        if (n - 16 >= 0) {
            stringBuilder.append(OffsetFont.NEG_1.getCharacter());
            stringBuilder.append(this.offset_16.getCharacter());
            n -= 16;
        }
        if (n - 8 >= 0) {
            stringBuilder.append(OffsetFont.NEG_1.getCharacter());
            stringBuilder.append(this.offset_8.getCharacter());
            n -= 8;
        }
        if (n - 4 >= 0) {
            stringBuilder.append(OffsetFont.NEG_1.getCharacter());
            stringBuilder.append(this.offset_4.getCharacter());
            n -= 4;
        }
        if (n - 2 >= 0) {
            stringBuilder.append(OffsetFont.NEG_1.getCharacter());
            stringBuilder.append(this.offset_2.getCharacter());
            n -= 2;
        }
        if (n - 1 >= 0) {
            stringBuilder.append(OffsetFont.NEG_1.getCharacter());
            stringBuilder.append(this.offset_1.getCharacter());
        }
        stringBuilder.append(OffsetFont.NEG_1.getCharacter());
        stringBuilder.append(this.right.getCharacter());
        stringBuilder.append(offset);
        return stringBuilder.toString();
    }

    public static class Builder {
        private final BackGround backGround = new BackGround();

        public static Builder of() {
            return new Builder();
        }

        public Builder left(ConfiguredChar configuredChar) {
            this.backGround.left = configuredChar;
            return this;
        }

        public Builder right(ConfiguredChar configuredChar) {
            this.backGround.right = configuredChar;
            return this;
        }

        public Builder offset_1(ConfiguredChar configuredChar) {
            this.backGround.offset_1 = configuredChar;
            return this;
        }

        public Builder offset_2(ConfiguredChar configuredChar) {
            this.backGround.offset_2 = configuredChar;
            return this;
        }

        public Builder offset_4(ConfiguredChar configuredChar) {
            this.backGround.offset_4 = configuredChar;
            return this;
        }

        public Builder offset_8(ConfiguredChar configuredChar) {
            this.backGround.offset_8 = configuredChar;
            return this;
        }

        public Builder offset_16(ConfiguredChar configuredChar) {
            this.backGround.offset_16 = configuredChar;
            return this;
        }

        public Builder offset_32(ConfiguredChar configuredChar) {
            this.backGround.offset_32 = configuredChar;
            return this;
        }

        public Builder offset_64(ConfiguredChar configuredChar) {
            this.backGround.offset_64 = configuredChar;
            return this;
        }

        public Builder offset_128(ConfiguredChar configuredChar) {
            this.backGround.offset_128 = configuredChar;
            return this;
        }

        public Builder leftMargin(int margin) {
            this.backGround.leftMargin = margin;
            return this;
        }

        public Builder rightMargin(int margin) {
            this.backGround.rightMargin = margin;
            return this;
        }

        public BackGround build() {
            return this.backGround;
        }
    }
}

