/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.api.mechanic.character;

import net.momirealms.customnameplates.api.util.LogUtils;

public class ConfiguredChar {
    private char character;
    private String pngFile;
    private int height;
    private int width;
    private int ascent;

    private ConfiguredChar() {
    }

    public ConfiguredChar(char character, String pngFile, int height, int width, int ascent) {
        this.character = character;
        this.pngFile = pngFile;
        this.height = height;
        this.width = width;
        this.ascent = ascent;
    }

    public char getCharacter() {
        return this.character;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getPngFile() {
        return this.pngFile;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getAscent() {
        return this.ascent;
    }

    public String getFile() {
        return this.pngFile + ".png";
    }

    public static class Builder {
        private final ConfiguredChar configuredChar = new ConfiguredChar();

        public static Builder of() {
            return new Builder();
        }

        public Builder character(char character) {
            this.configuredChar.character = character;
            return this;
        }

        public Builder png(String png) {
            this.configuredChar.pngFile = png;
            return this;
        }

        public Builder height(int height) {
            this.configuredChar.height = height;
            return this;
        }

        public Builder ascent(int ascent) {
            this.configuredChar.ascent = ascent;
            if (ascent >= this.configuredChar.height) {
                LogUtils.warn("Invalid config for " + this.configuredChar.pngFile);
                LogUtils.warn("Ascent " + ascent + " should be no higher than Height " + this.configuredChar.height);
            }
            return this;
        }

        public Builder descent(int descent) {
            if (descent < 0) {
                LogUtils.warn("Invalid config for " + this.configuredChar.pngFile);
                LogUtils.warn("Descent " + descent + " should be no lower than 0");
            }
            this.configuredChar.ascent = this.configuredChar.height - descent;
            return this;
        }

        public Builder width(int width) {
            this.configuredChar.width = width;
            return this;
        }

        public ConfiguredChar build() {
            return this.configuredChar;
        }
    }
}

