/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.api.mechanic.tag.unlimited;

import net.momirealms.customnameplates.api.requirement.Requirement;

public class DynamicTextTagSetting {
    private double verticalOffset;
    private String rawText;
    private int checkFrequency;
    private int refreshFrequency;
    private Requirement[] viewerRequirements;
    private Requirement[] ownerRequirements;

    private DynamicTextTagSetting() {
        this.verticalOffset = 0.0;
        this.rawText = "";
        this.checkFrequency = 10;
        this.refreshFrequency = 10;
        this.viewerRequirements = new Requirement[0];
        this.ownerRequirements = new Requirement[0];
    }

    public DynamicTextTagSetting(double verticalOffset, String rawText, int checkFrequency, int refreshFrequency, Requirement[] viewerRequirements, Requirement[] ownerRequirements) {
        this.verticalOffset = verticalOffset;
        this.rawText = rawText;
        this.checkFrequency = checkFrequency;
        this.refreshFrequency = refreshFrequency;
        this.viewerRequirements = viewerRequirements;
        this.ownerRequirements = ownerRequirements;
    }

    public static Builder builder() {
        return new Builder();
    }

    public double getVerticalOffset() {
        return this.verticalOffset;
    }

    public String getRawText() {
        return this.rawText;
    }

    public int getCheckFrequency() {
        return this.checkFrequency;
    }

    public int getRefreshFrequency() {
        return this.refreshFrequency;
    }

    public Requirement[] getViewerRequirements() {
        return this.viewerRequirements;
    }

    public Requirement[] getOwnerRequirements() {
        return this.ownerRequirements;
    }

    public static class Builder {
        private final DynamicTextTagSetting setting = new DynamicTextTagSetting();

        public static Builder of() {
            return new Builder();
        }

        public Builder checkFrequency(int checkFrequency) {
            this.setting.checkFrequency = checkFrequency;
            return this;
        }

        public Builder refreshFrequency(int refreshFrequency) {
            this.setting.refreshFrequency = refreshFrequency;
            return this;
        }

        public Builder rawText(String rawText) {
            this.setting.rawText = rawText;
            return this;
        }

        public Builder verticalOffset(double verticalOffset) {
            this.setting.verticalOffset = verticalOffset;
            return this;
        }

        public Builder ownerRequirements(Requirement[] ownerRequirements) {
            this.setting.ownerRequirements = ownerRequirements;
            return this;
        }

        public Builder viewerRequirements(Requirement[] viewerRequirements) {
            this.setting.viewerRequirements = viewerRequirements;
            return this;
        }

        public DynamicTextTagSetting build() {
            return this.setting;
        }
    }
}

