/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.paper.helper;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Objects;
import java.util.StringJoiner;
import net.momirealms.customnameplates.api.CustomNameplatesPlugin;
import net.momirealms.customnameplates.api.util.LogUtils;
import net.momirealms.customnameplates.paper.CustomNameplatesPluginImpl;
import net.momirealms.customnameplates.paper.helper.MavenLibrary;
import net.momirealms.customnameplates.paper.helper.URLClassLoaderAccess;

public final class LibraryLoader {
    private static final Supplier<URLClassLoaderAccess> URL_INJECTOR = Suppliers.memoize(() -> URLClassLoaderAccess.create((URLClassLoader)((Object)((Object)CustomNameplatesPluginImpl.getInstance())).getClass().getClassLoader()));

    public static void loadAll(Object object) {
        LibraryLoader.loadAll(object.getClass());
    }

    public static void loadAll(Class<?> clazz) {
        MavenLibrary[] libs;
        for (MavenLibrary lib : libs = (MavenLibrary[])clazz.getDeclaredAnnotationsByType(MavenLibrary.class)) {
            LibraryLoader.load(lib.groupId(), lib.artifactId(), lib.version(), lib.repo().url());
        }
    }

    public static void load(String groupId, String artifactId, String version, String repoUrl) {
        LibraryLoader.load(new Dependency(groupId, artifactId, version, repoUrl));
    }

    public static void loadDependencies(String ... libs) {
        if (libs == null || libs.length % 2 != 0) {
            return;
        }
        for (int i = 0; i < libs.length; i += 2) {
            String[] split = libs[i].split(":");
            LibraryLoader.load(new Dependency(split[0], split[1], split[2], libs[i + 1]));
        }
    }

    public static void load(Dependency d) {
        String name = d.artifactId() + "-" + d.version();
        File saveLocation = new File(LibraryLoader.getLibFolder(d), name + ".jar");
        if (!saveLocation.exists()) {
            try {
                LogUtils.info("Dependency '" + name + "' is not already in the libraries folder. Attempting to download...");
                URL url = d.getUrl();
                try (InputStream is = url.openStream();){
                    Files.copy(is, saveLocation.toPath(), new CopyOption[0]);
                    LogUtils.info("Dependency '" + name + "' successfully downloaded.");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!saveLocation.exists()) {
            throw new RuntimeException("Unable to download dependency: " + d);
        }
        try {
            ((URLClassLoaderAccess)URL_INJECTOR.get()).addURL(saveLocation.toURI().toURL());
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load dependency: " + saveLocation, e);
        }
    }

    private static File getLibFolder(Dependency dependency) {
        File pluginDataFolder = CustomNameplatesPlugin.getInstance().getDataFolder();
        File serverDir = pluginDataFolder.getParentFile().getParentFile();
        File helperDir = new File(serverDir, "libraries");
        String[] split = dependency.groupId().split("\\.");
        StringJoiner stringJoiner = new StringJoiner(File.separator);
        for (String str : split) {
            stringJoiner.add(str);
        }
        File jarDir = new File(helperDir, stringJoiner + File.separator + dependency.artifactId + File.separator + dependency.version);
        jarDir.mkdirs();
        return jarDir;
    }

    public record Dependency(String groupId, String artifactId, String version, String repoUrl) {
        public Dependency(String groupId, String artifactId, String version, String repoUrl) {
            this.groupId = Objects.requireNonNull(groupId, "groupId");
            this.artifactId = Objects.requireNonNull(artifactId, "artifactId");
            this.version = Objects.requireNonNull(version, "version");
            this.repoUrl = Objects.requireNonNull(repoUrl, "repoUrl");
        }

        public URL getUrl() throws MalformedURLException {
            Object repo = this.repoUrl;
            if (!((String)repo).endsWith("/")) {
                repo = (String)repo + "/";
            }
            repo = (String)repo + "%s/%s/%s/%s-%s.jar";
            String url = String.format((String)repo, this.groupId.replace(".", "/"), this.artifactId, this.version, this.artifactId, this.version);
            return new URL(url);
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Dependency)) {
                return false;
            }
            Dependency other = (Dependency)o;
            return this.groupId().equals(other.groupId()) && this.artifactId().equals(other.artifactId()) && this.version().equals(other.version()) && this.repoUrl().equals(other.repoUrl());
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.groupId().hashCode();
            result = result * 59 + this.artifactId().hashCode();
            result = result * 59 + this.version().hashCode();
            result = result * 59 + this.repoUrl().hashCode();
            return result;
        }

        @Override
        public String toString() {
            return "LibraryLoader.Dependency(groupId=" + this.groupId() + ", artifactId=" + this.artifactId() + ", version=" + this.version() + ", repoUrl=" + this.repoUrl() + ")";
        }
    }
}

