/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.paper.mechanic.actionbar;

import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import java.io.File;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.momirealms.customnameplates.api.CustomNameplatesPlugin;
import net.momirealms.customnameplates.api.manager.ActionBarManager;
import net.momirealms.customnameplates.api.util.LogUtils;
import net.momirealms.customnameplates.libraries.adventure.text.Component;
import net.momirealms.customnameplates.libraries.adventure.text.TranslatableComponent;
import net.momirealms.customnameplates.libraries.adventure.text.serializer.gson.GsonComponentSerializer;
import net.momirealms.customnameplates.paper.adventure.AdventureManagerImpl;
import net.momirealms.customnameplates.paper.mechanic.actionbar.ActionBarConfig;
import net.momirealms.customnameplates.paper.mechanic.actionbar.ActionBarReceiver;
import net.momirealms.customnameplates.paper.mechanic.actionbar.listener.ActionBarListener;
import net.momirealms.customnameplates.paper.mechanic.actionbar.listener.ChatMessageListener;
import net.momirealms.customnameplates.paper.mechanic.actionbar.listener.SystemChatListener;
import net.momirealms.customnameplates.paper.mechanic.misc.DisplayController;
import net.momirealms.customnameplates.paper.setting.CNConfig;
import net.momirealms.customnameplates.paper.util.ConfigUtils;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class ActionBarManagerImpl
implements ActionBarManager,
Listener {
    private final ConcurrentHashMap<UUID, ActionBarReceiver> receiverMap = new ConcurrentHashMap();
    private final CustomNameplatesPlugin plugin;
    private final ActionBarListener actionBarListener;
    private ActionBarConfig config;
    private ChatMessageListener chatMessageListener;
    private SystemChatListener systemChatListener;

    public ActionBarManagerImpl(CustomNameplatesPlugin plugin) {
        this.plugin = plugin;
        this.actionBarListener = new ActionBarListener(this);
        if (plugin.getVersionManager().isVersionNewerThan1_19()) {
            this.systemChatListener = new SystemChatListener(this);
        } else {
            this.chatMessageListener = new ChatMessageListener(this);
        }
    }

    public void load() {
        if (!CNConfig.actionBarModule) {
            return;
        }
        this.loadConfigs();
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.createActionBarFor(player);
        }
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        if (this.actionBarListener != null) {
            ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)this.actionBarListener);
        }
        if (this.systemChatListener != null) {
            ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)this.systemChatListener);
        }
        if (this.chatMessageListener != null) {
            ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)this.chatMessageListener);
        }
    }

    public void unload() {
        for (ActionBarReceiver receiver : this.receiverMap.values()) {
            receiver.cancelTask();
            receiver.destroy();
        }
        this.receiverMap.clear();
        HandlerList.unregisterAll((Listener)this);
        if (this.actionBarListener != null) {
            ProtocolLibrary.getProtocolManager().removePacketListener((PacketListener)this.actionBarListener);
        }
        if (this.systemChatListener != null) {
            ProtocolLibrary.getProtocolManager().removePacketListener((PacketListener)this.systemChatListener);
        }
        if (this.chatMessageListener != null) {
            ProtocolLibrary.getProtocolManager().removePacketListener((PacketListener)this.chatMessageListener);
        }
    }

    public void reload() {
        this.unload();
        this.load();
    }

    private void loadConfigs() {
        YamlConfiguration config = this.plugin.getConfig("configs" + File.separator + "actionbar.yml");
        boolean temp = false;
        for (Map.Entry barEntry : config.getValues(false).entrySet()) {
            Object v = barEntry.getValue();
            if (!(v instanceof ConfigurationSection)) {
                return;
            }
            ConfigurationSection section = (ConfigurationSection)v;
            if (temp) {
                LogUtils.warn("You can create at most 1 actionbar in actionbar.yml. Actionbar " + (String)barEntry.getKey() + " would not work.");
                continue;
            }
            this.config = ActionBarConfig.builder().checkFrequency(section.getInt("check-frequency", 10)).requirement(this.plugin.getRequirementManager().getRequirements(section.getConfigurationSection("conditions"))).displayOrder(ConfigUtils.getTimeLimitTexts(section.getConfigurationSection("text-display-order"))).build();
            temp = true;
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (CNConfig.sendDelay == 0) {
            this.createActionBarFor(player);
            return;
        }
        this.plugin.getScheduler().runTaskAsyncLater(() -> this.createActionBarFor(player), (long)CNConfig.sendDelay * 50L, TimeUnit.MILLISECONDS);
    }

    private void createActionBarFor(Player player) {
        if (player == null || !player.isOnline()) {
            return;
        }
        ActionBarReceiver receiver = new ActionBarReceiver(this.plugin, player, new DisplayController(player, this.config.getCheckFrequency(), this.config.getRequirements(), this.config.getTextDisplayOrder()));
        receiver.arrangeTask();
        this.putReceiverToMap(player.getUniqueId(), receiver);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        ActionBarReceiver receiver = this.receiverMap.remove(event.getPlayer().getUniqueId());
        if (receiver != null) {
            receiver.cancelTask();
        }
    }

    private void putReceiverToMap(UUID uuid, ActionBarReceiver actionBarReceiver) {
        ActionBarReceiver previous = this.receiverMap.put(uuid, actionBarReceiver);
        if (previous != null) {
            LogUtils.warn("Unexpected error: Duplicated actionbar created");
            previous.cancelTask();
        }
    }

    private ActionBarReceiver getReceiver(UUID uuid) {
        return this.receiverMap.get(uuid);
    }

    public void onReceiveSystemChatPacket(PacketEvent event) {
        ActionBarReceiver receiver;
        PacketContainer packet = event.getPacket();
        Boolean overlay = (Boolean)packet.getBooleans().readSafely(0);
        if (overlay != null && overlay.booleanValue() && (receiver = this.getReceiver(event.getPlayer().getUniqueId())) != null) {
            event.setCancelled(true);
            String json = (String)packet.getStrings().readSafely(0);
            if (json != null && !json.equals("")) {
                Object component = GsonComponentSerializer.gson().deserialize(json);
                if (component instanceof TranslatableComponent) {
                    return;
                }
                receiver.setOtherPluginText(AdventureManagerImpl.getInstance().getMiniMessageFormat((Component)component), System.currentTimeMillis());
            }
        }
    }

    public void onReceiveChatMessagePacket(PacketEvent event) {
        ActionBarReceiver receiver;
        PacketContainer packet = event.getPacket();
        EnumWrappers.ChatType type = (EnumWrappers.ChatType)packet.getChatTypes().readSafely(0);
        if (type == EnumWrappers.ChatType.GAME_INFO && (receiver = this.getReceiver(event.getPlayer().getUniqueId())) != null) {
            event.setCancelled(true);
            WrappedChatComponent wrappedChatComponent = (WrappedChatComponent)packet.getChatComponents().read(0);
            if (wrappedChatComponent != null) {
                String json = wrappedChatComponent.getJson();
                Object component = GsonComponentSerializer.gson().deserialize(json);
                if (component instanceof TranslatableComponent) {
                    return;
                }
                receiver.setOtherPluginText(AdventureManagerImpl.getInstance().getMiniMessageFormat((Component)component), System.currentTimeMillis());
            }
        }
    }

    public void onReceiveActionBarPacket(PacketEvent event) {
        ActionBarReceiver receiver;
        PacketContainer packet = event.getPacket();
        WrappedChatComponent wrappedChatComponent = (WrappedChatComponent)packet.getChatComponents().read(0);
        if (wrappedChatComponent != null && (receiver = this.getReceiver(event.getPlayer().getUniqueId())) != null) {
            String strJson = wrappedChatComponent.getJson();
            if (strJson.contains("\"name\":\"np\",\"objective\":\"ab\"")) {
                return;
            }
            event.setCancelled(true);
            receiver.setOtherPluginText(AdventureManagerImpl.getInstance().getMiniMessageFormat((Component)GsonComponentSerializer.gson().deserialize(strJson)), System.currentTimeMillis());
        }
    }

    @Override
    @NotNull
    public String getOtherPluginActionBar(Player player) {
        ActionBarReceiver receiver = this.getReceiver(player.getUniqueId());
        if (receiver != null) {
            return receiver.getOtherPluginText();
        }
        return "";
    }
}

