/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.paper.mechanic.actionbar;

import java.util.concurrent.TimeUnit;
import net.momirealms.customnameplates.api.CustomNameplatesPlugin;
import net.momirealms.customnameplates.api.requirement.Condition;
import net.momirealms.customnameplates.api.scheduler.CancellableTask;
import net.momirealms.customnameplates.api.util.LogUtils;
import net.momirealms.customnameplates.paper.adventure.AdventureManagerImpl;
import net.momirealms.customnameplates.paper.mechanic.misc.DisplayController;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class ActionBarReceiver {
    private final CustomNameplatesPlugin plugin;
    private final Player player;
    private CancellableTask actionBarTask;
    private final DisplayController controller;
    private long lastUpdateTime;
    private String otherPluginText;
    private long expireTime;

    public ActionBarReceiver(CustomNameplatesPlugin plugin, Player player, DisplayController controller) {
        this.plugin = plugin;
        this.player = player;
        this.controller = controller;
        this.otherPluginText = "";
    }

    public void timer() {
        if (System.currentTimeMillis() > this.expireTime) {
            this.otherPluginText = "";
        }
        Condition condition = new Condition((OfflinePlayer)this.player);
        switch (this.controller.stateCheck(condition)) {
            case KEEP: {
                if (!this.controller.isShown()) {
                    return;
                }
                long current = System.currentTimeMillis();
                if (!this.controller.updateText(condition) && !this.shouldSendBeatPack(current)) break;
                AdventureManagerImpl.getInstance().sendActionbar(this.player, this.controller.getLatestContent());
                this.lastUpdateTime = current;
                break;
            }
            case UPDATE: {
                if (this.controller.isShown()) {
                    this.controller.initialize(condition);
                    AdventureManagerImpl.getInstance().sendActionbar(this.player, this.controller.getLatestContent());
                    break;
                }
                AdventureManagerImpl.getInstance().sendActionbar(this.player, "");
            }
        }
    }

    public void arrangeTask() {
        if (this.actionBarTask != null && !this.actionBarTask.isCancelled()) {
            LogUtils.warn("There's already an ActionBar task running");
            return;
        }
        this.actionBarTask = this.plugin.getScheduler().runTaskAsyncTimer(() -> {
            try {
                this.timer();
            }
            catch (Exception e) {
                LogUtils.severe("Error occurred when sending ActionBars. This might not be a bug in CustomNameplates. Please report to the Plugin on the top of the following stack trace.");
                e.printStackTrace();
            }
        }, 50L, 50L, TimeUnit.MILLISECONDS);
    }

    public void cancelTask() {
        if (this.actionBarTask == null) {
            LogUtils.warn("ActionBar task has been already cancelled");
            return;
        }
        this.actionBarTask.cancel();
        this.actionBarTask = null;
    }

    public boolean shouldSendBeatPack(long current) {
        return current - this.lastUpdateTime > 1700L;
    }

    public void setOtherPluginText(String text, long current) {
        this.otherPluginText = text;
        this.expireTime = current + 3000L;
    }

    public String getOtherPluginText() {
        return this.otherPluginText;
    }

    public void destroy() {
        AdventureManagerImpl.getInstance().sendActionbar(this.player, "");
    }
}

