/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.paper.mechanic.background;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import net.momirealms.customnameplates.api.CustomNameplatesPlugin;
import net.momirealms.customnameplates.api.manager.BackGroundManager;
import net.momirealms.customnameplates.api.mechanic.background.BackGround;
import net.momirealms.customnameplates.api.mechanic.character.CharacterArranger;
import net.momirealms.customnameplates.api.mechanic.character.ConfiguredChar;
import net.momirealms.customnameplates.api.util.LogUtils;
import net.momirealms.customnameplates.paper.setting.CNConfig;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;

public class BackGroundManagerImpl
implements BackGroundManager {
    private final HashMap<String, BackGround> backGroundMap;
    private final CustomNameplatesPlugin plugin;

    public BackGroundManagerImpl(CustomNameplatesPlugin plugin) {
        this.plugin = plugin;
        this.backGroundMap = new HashMap();
    }

    public void reload() {
        this.unload();
        this.load();
    }

    public void load() {
        if (!CNConfig.backgroundModule) {
            return;
        }
        this.loadConfigs();
    }

    public void unload() {
        this.backGroundMap.clear();
    }

    private void loadConfigs() {
        File[] bgConfigFiles;
        File bgFolder = new File(this.plugin.getDataFolder(), "contents" + File.separator + "backgrounds");
        if (!bgFolder.exists() && bgFolder.mkdirs()) {
            this.saveDefaultBackgrounds();
        }
        if ((bgConfigFiles = bgFolder.listFiles(file -> file.getName().endsWith(".yml"))) == null) {
            return;
        }
        Arrays.sort(bgConfigFiles, Comparator.comparing(File::getName));
        for (File bgConfigFile : bgConfigFiles) {
            BackGround background;
            String key = bgConfigFile.getName().substring(0, bgConfigFile.getName().length() - 4);
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)bgConfigFile);
            int height = config.getInt("middle.height", 14);
            int ascent = config.getInt("middle.ascent", 8);
            if (config.contains("middle.descent")) {
                ascent = height - config.getInt("middle.descent");
            }
            if (this.registerBackGround(key, background = BackGround.builder().leftMargin(config.getInt("left-margin", 1)).rightMargin(config.getInt("right-margin", 1)).left(ConfiguredChar.builder().character(CharacterArranger.getAndIncrease()).png(config.getString("left.image")).height(config.getInt("left.height")).ascent(config.getInt("left.ascent")).width(config.getInt("left.width")).build()).offset_1(ConfiguredChar.builder().character(CharacterArranger.getAndIncrease()).png(config.getString("middle.1")).height(height).ascent(ascent).width(1).build()).offset_2(ConfiguredChar.builder().character(CharacterArranger.getAndIncrease()).png(config.getString("middle.2")).height(height).ascent(ascent).width(2).build()).offset_4(ConfiguredChar.builder().character(CharacterArranger.getAndIncrease()).png(config.getString("middle.4")).height(height).ascent(ascent).width(4).build()).offset_8(ConfiguredChar.builder().character(CharacterArranger.getAndIncrease()).png(config.getString("middle.8")).height(height).ascent(ascent).width(8).build()).offset_16(ConfiguredChar.builder().character(CharacterArranger.getAndIncrease()).png(config.getString("middle.16")).height(height).ascent(ascent).width(16).build()).offset_32(ConfiguredChar.builder().character(CharacterArranger.getAndIncrease()).png(config.getString("middle.32")).height(height).ascent(ascent).width(32).build()).offset_64(ConfiguredChar.builder().character(CharacterArranger.getAndIncrease()).png(config.getString("middle.64")).height(height).ascent(ascent).width(64).build()).offset_128(ConfiguredChar.builder().character(CharacterArranger.getAndIncrease()).png(config.getString("middle.128")).height(height).ascent(ascent).width(128).build()).right(ConfiguredChar.builder().character(CharacterArranger.getAndIncrease()).png(config.getString("right.image")).height(config.getInt("right.height")).ascent(config.getInt("right.ascent")).width(config.getInt("right.width")).build()).build())) continue;
            LogUtils.warn("Found duplicated background: " + key);
        }
    }

    @Override
    public BackGround getBackGround(@NotNull String key) {
        return this.backGroundMap.get(key);
    }

    @Override
    public Collection<BackGround> getBackGrounds() {
        return this.backGroundMap.values();
    }

    @Override
    public boolean registerBackGround(@NotNull String key, @NotNull BackGround backGround) {
        if (this.backGroundMap.containsKey(key)) {
            return false;
        }
        this.backGroundMap.put(key, backGround);
        return true;
    }

    @Override
    public boolean unregisterBackGround(@NotNull String key) {
        return this.backGroundMap.remove(key) != null;
    }

    private void saveDefaultBackgrounds() {
        String[] config_list;
        String[] bg_list;
        for (String bg : bg_list = new String[]{"b0", "b1", "b2", "b4", "b8", "b16", "b32", "b64", "b128"}) {
            this.plugin.saveResource("contents" + File.separator + "backgrounds" + File.separator + bg + ".png", false);
        }
        for (String config : config_list = new String[]{"bedrock_1", "bedrock_2"}) {
            this.plugin.saveResource("contents" + File.separator + "backgrounds" + File.separator + config + ".yml", false);
        }
    }
}

