/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.paper.mechanic.bubble.provider;

import java.util.UUID;
import net.momirealms.customnameplates.api.CustomNameplatesPlugin;
import net.momirealms.customnameplates.api.manager.BubbleManager;
import net.momirealms.customnameplates.api.mechanic.bubble.provider.AbstractChatProvider;
import net.momirealms.customnameplates.api.util.LogUtils;
import net.william278.huskchat.bukkit.BukkitHuskChat;
import net.william278.huskchat.bukkit.event.ChatMessageEvent;
import net.william278.huskchat.channel.Channel;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class HuskChatProvider
extends AbstractChatProvider {
    public HuskChatProvider(BubbleManager chatBubblesManager) {
        super(chatBubblesManager);
    }

    @Override
    public void register() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)CustomNameplatesPlugin.get());
    }

    @Override
    public void unregister() {
        HandlerList.unregisterAll((Listener)this);
    }

    @Override
    public boolean hasJoinedChannel(Player player, String channelID) {
        String channel = BukkitHuskChat.getInstance().getPlayerCache().getPlayerChannel(player.getUniqueId());
        if (channel == null) {
            LogUtils.warn("Channel " + channelID + " doesn't exist.");
            return false;
        }
        return channel.equals(channelID);
    }

    @Override
    public boolean canJoinChannel(Player player, String channelID) {
        Channel channel = (Channel)BukkitHuskChat.getInstance().getSettings().getChannels().get(channelID);
        if (channel == null) {
            LogUtils.warn("Channel " + channelID + " doesn't exist.");
            return false;
        }
        String receivePerm = channel.getReceivePermission();
        if (receivePerm == null) {
            return true;
        }
        return player.hasPermission(receivePerm);
    }

    @EventHandler(ignoreCancelled=true)
    public void onHuskChat(ChatMessageEvent event) {
        String channel = event.getChannelId();
        for (String black : this.chatBubblesManager.getBlacklistChannels()) {
            if (!channel.equals(black)) continue;
            return;
        }
        Player player = Bukkit.getPlayer((UUID)event.getSender().getUuid());
        if (player == null || !player.isOnline()) {
            return;
        }
        CustomNameplatesPlugin.get().getScheduler().runTaskAsync(() -> this.chatBubblesManager.onChat(player, event.getMessage(), channel));
    }
}

