/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.paper.mechanic.nameplate.tag.listener;

import com.francobm.magicosmetics.api.Cosmetic;
import com.francobm.magicosmetics.api.CosmeticType;
import com.francobm.magicosmetics.cache.PlayerData;
import com.francobm.magicosmetics.cache.cosmetics.Hat;
import com.francobm.magicosmetics.events.CosmeticChangeEquipEvent;
import com.francobm.magicosmetics.events.CosmeticEquipEvent;
import com.francobm.magicosmetics.events.CosmeticUnEquipEvent;
import com.francobm.magicosmetics.events.PlayerChangeBlacklistEvent;
import com.francobm.magicosmetics.events.PlayerDataLoadEvent;
import net.momirealms.customnameplates.paper.mechanic.nameplate.tag.unlimited.UnlimitedEntity;
import net.momirealms.customnameplates.paper.mechanic.nameplate.tag.unlimited.UnlimitedPlayer;
import net.momirealms.customnameplates.paper.mechanic.nameplate.tag.unlimited.UnlimitedTagManagerImpl;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class MagicCosmeticsListener
implements Listener {
    private final UnlimitedTagManagerImpl unlimitedTagManager;

    public MagicCosmeticsListener(UnlimitedTagManagerImpl unlimitedTagManager) {
        this.unlimitedTagManager = unlimitedTagManager;
    }

    @EventHandler
    public void onChangeCos(CosmeticChangeEquipEvent event) {
        Cosmetic cosmetic = event.getNewCosmetic();
        Player player = event.getPlayer();
        if (cosmetic instanceof Hat) {
            Hat hat = (Hat)cosmetic;
            UnlimitedEntity unlimitedEntity = this.unlimitedTagManager.getUnlimitedObject(player.getUniqueId());
            if (unlimitedEntity instanceof UnlimitedPlayer) {
                UnlimitedPlayer unlimitedPlayer = (UnlimitedPlayer)unlimitedEntity;
                unlimitedPlayer.setHatOffset(hat.isHideCosmetic() ? 0.0 : hat.getOffSetY());
            }
        }
    }

    @EventHandler
    public void onEnterBlackListWorld(PlayerChangeBlacklistEvent event) {
        Player player = event.getPlayer();
        UnlimitedEntity unlimitedEntity = this.unlimitedTagManager.getUnlimitedObject(player.getUniqueId());
        if (unlimitedEntity instanceof UnlimitedPlayer) {
            UnlimitedPlayer unlimitedPlayer = (UnlimitedPlayer)unlimitedEntity;
            if (event.isInWorldBlacklist()) {
                unlimitedPlayer.setHatOffset(0.0);
            } else {
                Hat cosmetic;
                PlayerData playerData = PlayerData.getPlayer((OfflinePlayer)player);
                if (playerData != null && (cosmetic = playerData.getHat()) instanceof Hat) {
                    Hat hat = cosmetic;
                    unlimitedPlayer.setHatOffset(hat.isHideCosmetic() ? 0.0 : hat.getOffSetY());
                }
            }
        }
    }

    @EventHandler
    public void onEquip(CosmeticEquipEvent event) {
        Cosmetic cosmetic = event.getCosmetic();
        Player player = event.getPlayer();
        if (cosmetic instanceof Hat) {
            Hat hat = (Hat)cosmetic;
            UnlimitedEntity unlimitedEntity = this.unlimitedTagManager.getUnlimitedObject(player.getUniqueId());
            if (unlimitedEntity instanceof UnlimitedPlayer) {
                UnlimitedPlayer unlimitedPlayer = (UnlimitedPlayer)unlimitedEntity;
                unlimitedPlayer.setHatOffset(hat.isHideCosmetic() ? 0.0 : hat.getOffSetY());
            }
        }
    }

    @EventHandler
    public void onUnEquip(CosmeticUnEquipEvent event) {
        UnlimitedEntity unlimitedEntity;
        Player player = event.getPlayer();
        if (event.getCosmeticType() == CosmeticType.HAT && (unlimitedEntity = this.unlimitedTagManager.getUnlimitedObject(player.getUniqueId())) instanceof UnlimitedPlayer) {
            UnlimitedPlayer unlimitedPlayer = (UnlimitedPlayer)unlimitedEntity;
            unlimitedPlayer.setHatOffset(0.0);
        }
    }

    @EventHandler
    public void onDataLoaded(PlayerDataLoadEvent event) {
        for (Cosmetic cosmetic : event.getEquippedCosmetics()) {
            if (!(cosmetic instanceof Hat)) continue;
            Hat hat = (Hat)cosmetic;
            UnlimitedEntity unlimitedEntity = this.unlimitedTagManager.getUnlimitedObject(event.getPlayerData().getUniqueId());
            if (!(unlimitedEntity instanceof UnlimitedPlayer)) continue;
            UnlimitedPlayer unlimitedPlayer = (UnlimitedPlayer)unlimitedEntity;
            unlimitedPlayer.setHatOffset(hat.isHideCosmetic() ? 0.0 : hat.getOffSetY());
        }
    }
}

