/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.paper.mechanic.nameplate.tag.team;

import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketListener;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.momirealms.customnameplates.api.CustomNameplatesPlugin;
import net.momirealms.customnameplates.api.manager.NameplateManager;
import net.momirealms.customnameplates.api.manager.TeamTagManager;
import net.momirealms.customnameplates.api.scheduler.CancellableTask;
import net.momirealms.customnameplates.api.util.LocationUtils;
import net.momirealms.customnameplates.api.util.LogUtils;
import net.momirealms.customnameplates.paper.mechanic.nameplate.tag.listener.PlayerInfoListener;
import net.momirealms.customnameplates.paper.mechanic.nameplate.tag.team.TeamPlayer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class TeamTagManagerImpl
implements TeamTagManager {
    private final NameplateManager manager;
    private final ConcurrentHashMap<UUID, TeamPlayer> teamPlayerMap;
    private CancellableTask refreshTask;
    private final PlayerInfoListener tabListener;

    public TeamTagManagerImpl(NameplateManager manager) {
        this.manager = manager;
        this.teamPlayerMap = new ConcurrentHashMap();
        this.tabListener = new PlayerInfoListener(this);
    }

    public void load(long refreshFrequency, boolean fixTab) {
        this.refreshTask = CustomNameplatesPlugin.get().getScheduler().runTaskAsyncTimer(() -> {
            try {
                for (TeamPlayer teamPlayer : this.teamPlayerMap.values()) {
                    teamPlayer.updateForNearbyPlayers(false);
                }
            }
            catch (Exception e) {
                LogUtils.severe("Error occurred when updating team tags. This might not be a bug in CustomNameplates. Please report to the Plugin on the top of the following stack trace.");
                e.printStackTrace();
            }
        }, refreshFrequency * 50L, refreshFrequency * 50L, TimeUnit.MILLISECONDS);
        if (fixTab) {
            ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)this.tabListener);
        }
    }

    public void unload() {
        if (this.refreshTask != null && !this.refreshTask.isCancelled()) {
            this.refreshTask.cancel();
        }
        for (TeamPlayer entry : this.teamPlayerMap.values()) {
            entry.destroy();
        }
        ProtocolLibrary.getProtocolManager().removePacketListener((PacketListener)this.tabListener);
    }

    @Override
    public TeamPlayer createTagForPlayer(Player player, String prefix, String suffix) {
        if (this.teamPlayerMap.containsKey(player.getUniqueId())) {
            return null;
        }
        TeamPlayer teamPlayer = new TeamPlayer(this, player, prefix, suffix);
        this.teamPlayerMap.put(player.getUniqueId(), teamPlayer);
        for (Player online : Bukkit.getOnlinePlayers()) {
            if (online == player || !online.canSee(player) || LocationUtils.getDistance((Entity)online, (Entity)player) > 48.0 || online.getWorld() != player.getWorld() || online.isDead()) continue;
            teamPlayer.addNearbyPlayer(online);
        }
        return teamPlayer;
    }

    @Override
    public TeamPlayer removeTeamPlayerFromMap(UUID uuid) {
        return this.teamPlayerMap.remove(uuid);
    }

    @Nullable
    public TeamPlayer getTeamPlayer(UUID uuid) {
        return this.teamPlayerMap.get(uuid);
    }

    public void handleEntitySpawnPacket(Player receiver, int entityId) {
        Entity spawned = this.manager.getEntityByEntityID(entityId);
        if (spawned == null) {
            return;
        }
        TeamPlayer teamPlayer = this.getTeamPlayer(spawned.getUniqueId());
        if (teamPlayer == null) {
            return;
        }
        teamPlayer.addNearbyPlayer(receiver);
    }

    public void handleEntityDestroyPacket(Player receiver, List<Integer> list) {
        for (int id : list) {
            this.handleSingleEntityDestroy(receiver, id);
        }
    }

    public void handlePlayerQuit(Player quit) {
        this.teamPlayerMap.remove(quit.getUniqueId());
        for (TeamPlayer teamPlayer : this.teamPlayerMap.values()) {
            teamPlayer.removeNearbyPlayer(quit);
        }
    }

    private void handleSingleEntityDestroy(Player receiver, int entityID) {
        Entity deSpawned = this.manager.getEntityByEntityID(entityID);
        if (deSpawned == null) {
            return;
        }
        TeamPlayer teamPlayer = this.getTeamPlayer(deSpawned.getUniqueId());
        if (teamPlayer == null) {
            return;
        }
        teamPlayer.removeNearbyPlayer(receiver);
    }
}

