/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.paper.mechanic.nameplate.tag.unlimited;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import net.momirealms.customnameplates.api.mechanic.tag.unlimited.EntityTagEntity;
import net.momirealms.customnameplates.api.mechanic.tag.unlimited.StaticTextEntity;
import net.momirealms.customnameplates.api.mechanic.tag.unlimited.StaticTextTagSetting;
import net.momirealms.customnameplates.api.util.LocationUtils;
import net.momirealms.customnameplates.paper.mechanic.nameplate.tag.unlimited.UnlimitedTagManagerImpl;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Pose;

public class UnlimitedEntity
implements EntityTagEntity {
    protected final UnlimitedTagManagerImpl manager;
    protected final Entity entity;
    protected final Vector<Player> nearbyPlayers;
    protected Player[] nearbyPlayerArray;
    protected final Vector<StaticTextEntity> staticTags;
    protected StaticTextEntity[] staticTagArray;

    public UnlimitedEntity(UnlimitedTagManagerImpl manager, Entity entity) {
        this.manager = manager;
        this.entity = entity;
        this.nearbyPlayers = new Vector();
        this.staticTags = new Vector();
        this.staticTagVectorToArray();
        this.playerVectorToArray();
    }

    @Override
    public Entity getEntity() {
        return this.entity;
    }

    public Player[] getNearbyPlayers() {
        return this.nearbyPlayerArray;
    }

    public void addNearbyPlayerNaturally(Player player) {
        if (this.nearbyPlayers.contains(player)) {
            return;
        }
        this.nearbyPlayers.add(player);
        this.playerVectorToArray();
        for (StaticTextEntity tag : this.staticTagArray) {
            if (!tag.getComeRule().isPassed(player, this.entity)) continue;
            tag.addPlayerToViewers(player);
        }
    }

    public void removeNearbyPlayerNaturally(Player player) {
        if (!this.nearbyPlayers.contains(player)) {
            return;
        }
        this.nearbyPlayers.remove(player);
        this.playerVectorToArray();
        for (StaticTextEntity tag : this.staticTagArray) {
            if (!tag.getLeaveRule().isPassed(player, this.entity)) continue;
            tag.removePlayerFromViewers(player);
        }
    }

    public void addNearByPlayerToMap(int range) {
        for (Player online : Bukkit.getOnlinePlayers()) {
            if (online == this.entity || LocationUtils.getDistance((Entity)online, this.entity) > (double)range || online.getWorld() != this.entity.getWorld() || online.isDead()) continue;
            this.addNearbyPlayerNaturally(online);
        }
    }

    @Override
    public void addTag(StaticTextEntity tag) {
        if (this.staticTags.contains(tag)) {
            return;
        }
        this.staticTags.add(tag);
        this.staticTagVectorToArray();
        for (Player all : this.nearbyPlayers) {
            if (!tag.getComeRule().isPassed(all, this.entity)) continue;
            tag.addPlayerToViewers(all);
        }
    }

    @Override
    public StaticTextEntity addTag(StaticTextTagSetting setting) {
        StaticTextEntity tag = this.manager.createNamedEntity(this, setting);
        this.addTag(tag);
        return tag;
    }

    @Override
    public void removeTag(StaticTextEntity tag) {
        if (this.staticTags.remove(tag)) {
            tag.destroy();
            this.staticTagVectorToArray();
        }
    }

    @Override
    public Collection<StaticTextEntity> getStaticTags() {
        return new ArrayList<StaticTextEntity>(this.staticTags);
    }

    @Override
    public void forceAddNearbyPlayer(Player player) {
        if (this.nearbyPlayers.contains(player)) {
            return;
        }
        this.nearbyPlayers.add(player);
        this.playerVectorToArray();
        for (StaticTextEntity tag : this.staticTagArray) {
            tag.addPlayerToViewers(player);
        }
    }

    @Override
    public void forceRemoveNearbyPlayer(Player player) {
        if (!this.nearbyPlayers.contains(player)) {
            return;
        }
        this.nearbyPlayers.remove(player);
        this.playerVectorToArray();
        for (StaticTextEntity tag : this.staticTagArray) {
            tag.removePlayerFromViewers(player);
        }
    }

    public void move(Player receiver, short x, short y, short z, boolean onGround) {
        for (StaticTextEntity tag : this.staticTagArray) {
            tag.move(receiver, x, y, z, onGround);
        }
    }

    public void teleport(Player receiver, double x, double y, double z, boolean onGround) {
        for (StaticTextEntity tag : this.staticTagArray) {
            tag.teleport(receiver, x, y, z, onGround);
        }
    }

    public void teleport() {
        for (StaticTextEntity tag : this.staticTagArray) {
            tag.teleport();
        }
    }

    public void handlePose(Pose previous, Pose pose) {
        for (StaticTextEntity tag : this.staticTagArray) {
            tag.handlePose(previous, pose);
        }
    }

    @Override
    public void destroy() {
        this.manager.removeUnlimitedEntityFromMap(this.entity.getUniqueId());
        for (StaticTextEntity tag : this.staticTagArray) {
            tag.destroy();
        }
        this.nearbyPlayers.clear();
        this.staticTags.clear();
        this.staticTagArray = null;
        this.nearbyPlayerArray = null;
    }

    public void respawn() {
        for (StaticTextEntity tag : this.staticTagArray) {
            tag.respawn(this.entity.getPose());
        }
    }

    protected void staticTagVectorToArray() {
        this.staticTagArray = this.staticTags.toArray(new StaticTextEntity[0]);
    }

    protected void playerVectorToArray() {
        this.nearbyPlayerArray = this.nearbyPlayers.toArray(new Player[0]);
    }
}

