/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.paper.mechanic.nameplate.tag.unlimited;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import net.momirealms.customnameplates.api.CustomNameplatesPlugin;
import net.momirealms.customnameplates.api.mechanic.nameplate.TagMode;
import net.momirealms.customnameplates.api.mechanic.tag.unlimited.DynamicTextEntity;
import net.momirealms.customnameplates.api.mechanic.tag.unlimited.DynamicTextTagSetting;
import net.momirealms.customnameplates.api.mechanic.tag.unlimited.EntityTagPlayer;
import net.momirealms.customnameplates.api.mechanic.tag.unlimited.StaticTextEntity;
import net.momirealms.customnameplates.api.mechanic.tag.unlimited.StaticTextTagSetting;
import net.momirealms.customnameplates.common.team.TeamColor;
import net.momirealms.customnameplates.common.team.TeamTagVisibility;
import net.momirealms.customnameplates.paper.mechanic.nameplate.tag.unlimited.UnlimitedEntity;
import net.momirealms.customnameplates.paper.mechanic.nameplate.tag.unlimited.UnlimitedTagManagerImpl;
import net.momirealms.customnameplates.paper.setting.CNConfig;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Pose;

public class UnlimitedPlayer
extends UnlimitedEntity
implements EntityTagPlayer {
    private final Player owner;
    private final Vector<DynamicTextEntity> dynamicTags;
    private DynamicTextEntity[] dynamicTagArray;
    private double hatOffset;
    private boolean isPreviewing;

    public UnlimitedPlayer(UnlimitedTagManagerImpl manager, Player player) {
        super(manager, (Entity)player);
        this.owner = player;
        this.dynamicTags = new Vector();
        this.dynamicTagVectorToArray();
    }

    @Override
    public void addTag(DynamicTextEntity tag) {
        if (this.dynamicTags.contains(tag)) {
            return;
        }
        this.dynamicTags.add(tag);
        this.dynamicTagVectorToArray();
        for (Player all : this.getNearbyPlayers()) {
            if (!tag.canShow() || !tag.canSee(all)) continue;
            tag.addPlayerToViewers(all);
        }
    }

    @Override
    public void addTag(StaticTextEntity tag) {
        if (this.staticTags.contains(tag)) {
            return;
        }
        this.staticTags.add(tag);
        this.dynamicTagVectorToArray();
        for (Player all : this.getNearbyPlayers()) {
            if (!tag.getComeRule().isPassed(all, (Entity)this.owner)) continue;
            tag.addPlayerToViewers(all);
        }
    }

    @Override
    public DynamicTextEntity addTag(DynamicTextTagSetting setting) {
        DynamicTextEntity tag = this.manager.createNamedEntity(this, setting);
        this.addTag(tag);
        return tag;
    }

    @Override
    public StaticTextEntity addTag(StaticTextTagSetting setting) {
        StaticTextEntity tag = this.manager.createNamedEntity(this, setting);
        this.addTag(tag);
        return tag;
    }

    @Override
    public void removeTag(DynamicTextEntity tag) {
        if (this.dynamicTags.remove(tag)) {
            tag.destroy();
            this.dynamicTagVectorToArray();
        }
    }

    @Override
    public Collection<DynamicTextEntity> getDynamicTags() {
        return new ArrayList<DynamicTextEntity>(this.dynamicTags);
    }

    @Override
    public void setHatOffset(double hatOffset) {
        this.hatOffset = hatOffset;
    }

    @Override
    public void setPreview(boolean preview) {
        if (this.isPreviewing == preview) {
            return;
        }
        this.isPreviewing = preview;
        if (this.isPreviewing) {
            this.addNearbyPlayerNaturally(this.owner);
        } else {
            this.removeNearbyPlayerNaturally(this.owner);
        }
    }

    @Override
    public boolean isPreviewing() {
        return this.isPreviewing;
    }

    @Override
    public Player getPlayer() {
        return this.owner;
    }

    @Override
    public void updateText() {
        for (DynamicTextEntity tag : this.dynamicTagArray) {
            tag.updateText();
        }
    }

    @Override
    public double getHatOffset() {
        return this.hatOffset;
    }

    @Override
    public void addNearbyPlayerNaturally(Player player) {
        if (this.nearbyPlayers.contains(player)) {
            return;
        }
        this.nearbyPlayers.add(player);
        this.playerVectorToArray();
        this.setNameInvisibleFor(player);
        for (StaticTextEntity staticTextEntity : this.staticTagArray) {
            if (!staticTextEntity.getComeRule().isPassed(player, this.entity)) continue;
            staticTextEntity.addPlayerToViewers(player);
        }
        for (DynamicTextEntity dynamicTextEntity : this.dynamicTagArray) {
            if (!dynamicTextEntity.canShow() || !dynamicTextEntity.canSee(player)) continue;
            dynamicTextEntity.addPlayerToViewers(player);
        }
    }

    @Override
    public void removeNearbyPlayerNaturally(Player player) {
        if (!this.nearbyPlayers.contains(player)) {
            return;
        }
        this.nearbyPlayers.remove(player);
        this.playerVectorToArray();
        this.setNameVisibleFor(player);
        for (StaticTextEntity staticTextEntity : this.staticTagArray) {
            if (!staticTextEntity.getLeaveRule().isPassed(player, this.entity)) continue;
            staticTextEntity.removePlayerFromViewers(player);
        }
        for (DynamicTextEntity dynamicTextEntity : this.dynamicTagArray) {
            dynamicTextEntity.removePlayerFromViewers(player);
        }
    }

    @Override
    public void destroy() {
        this.manager.removeUnlimitedEntityFromMap(this.entity.getUniqueId());
        for (Player player : this.getNearbyPlayers()) {
            this.setNameVisibleFor(player);
        }
        for (DynamicTextEntity dynamicTextEntity : this.dynamicTagArray) {
            dynamicTextEntity.destroy();
        }
        for (StaticTextEntity staticTextEntity : this.staticTagArray) {
            staticTextEntity.destroy();
        }
        this.nearbyPlayers.clear();
        this.dynamicTags.clear();
        this.staticTags.clear();
        this.staticTagArray = null;
    }

    public void sneak(boolean sneaking, boolean flying) {
        for (DynamicTextEntity tag : this.dynamicTagArray) {
            tag.setSneak(sneaking, !flying);
        }
    }

    @Override
    public void respawn() {
        super.respawn();
        for (DynamicTextEntity tag : this.dynamicTagArray) {
            tag.respawn(this.owner.getPose());
        }
    }

    @Override
    public void move(Player receiver, short x, short y, short z, boolean onGround) {
        super.move(receiver, x, y, z, onGround);
        for (DynamicTextEntity tag : this.dynamicTagArray) {
            tag.move(receiver, x, y, z, onGround);
        }
    }

    @Override
    public void teleport(Player receiver, double x, double y, double z, boolean onGround) {
        super.teleport(receiver, x, y, z, onGround);
        for (DynamicTextEntity tag : this.dynamicTagArray) {
            tag.teleport(receiver, x, y, z, onGround);
        }
    }

    @Override
    public void teleport() {
        super.teleport();
        for (DynamicTextEntity tag : this.dynamicTagArray) {
            tag.teleport();
        }
    }

    @Override
    public void handlePose(Pose previous, Pose pose) {
        super.handlePose(previous, pose);
        for (DynamicTextEntity tag : this.dynamicTagArray) {
            tag.handlePose(previous, pose);
        }
    }

    private void setNameInvisibleFor(Player viewer) {
        if (CNConfig.nameplateModule && CustomNameplatesPlugin.get().getNameplateManager().getTagMode() == TagMode.UNLIMITED) {
            CustomNameplatesPlugin.get().getTeamManager().updateTeam(this.owner, viewer, "", "", TeamColor.WHITE, TeamTagVisibility.NEVER);
        }
    }

    private void setNameVisibleFor(Player viewer) {
        if (CNConfig.nameplateModule && CustomNameplatesPlugin.get().getNameplateManager().getTagMode() == TagMode.UNLIMITED) {
            CustomNameplatesPlugin.get().getTeamManager().updateTeam(this.owner, viewer, "", "", TeamColor.WHITE, TeamTagVisibility.ALWAYS);
        }
    }

    public void timer() {
        for (DynamicTextEntity tag : this.dynamicTagArray) {
            tag.timer();
        }
    }

    private void dynamicTagVectorToArray() {
        this.dynamicTagArray = this.dynamicTags.toArray(new DynamicTextEntity[0]);
    }
}

