/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.paper.mechanic.placeholder;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.momirealms.customnameplates.api.CustomNameplatesPlugin;
import net.momirealms.customnameplates.api.manager.PlaceholderManager;
import net.momirealms.customnameplates.api.mechanic.background.BackGround;
import net.momirealms.customnameplates.api.mechanic.character.ConfiguredChar;
import net.momirealms.customnameplates.api.mechanic.nameplate.Nameplate;
import net.momirealms.customnameplates.api.mechanic.placeholder.BackGroundText;
import net.momirealms.customnameplates.api.mechanic.placeholder.ConditionalText;
import net.momirealms.customnameplates.api.mechanic.placeholder.DescentText;
import net.momirealms.customnameplates.api.mechanic.placeholder.NameplateText;
import net.momirealms.customnameplates.api.mechanic.placeholder.StaticText;
import net.momirealms.customnameplates.api.mechanic.placeholder.SwitchText;
import net.momirealms.customnameplates.api.mechanic.placeholder.VanillaHud;
import net.momirealms.customnameplates.api.requirement.Requirement;
import net.momirealms.customnameplates.api.util.LogUtils;
import net.momirealms.customnameplates.common.Pair;
import net.momirealms.customnameplates.paper.mechanic.placeholder.PluginPlaceholders;
import net.momirealms.customnameplates.paper.setting.CNConfig;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;

public class PlaceholderManagerImpl
implements PlaceholderManager {
    private final Pattern placeholderPattern = Pattern.compile("%([^%]*)%");
    private final PluginPlaceholders pluginPlaceholders;
    private final HashMap<String, StaticText> staticTextMap;
    private final HashMap<String, SwitchText> switchTextMap;
    private final HashMap<String, DescentText> descentTextMap;
    private final HashMap<String, ConditionalText> conditionalTextMap;
    private final HashMap<String, NameplateText> nameplateTextMap;
    private final HashMap<String, BackGroundText> backGroundTextMap;
    private final HashMap<String, VanillaHud> vanillaHudMap;
    private final CustomNameplatesPlugin plugin;

    public PlaceholderManagerImpl(CustomNameplatesPlugin plugin) {
        this.plugin = plugin;
        this.pluginPlaceholders = new PluginPlaceholders(plugin, this);
        this.staticTextMap = new HashMap();
        this.switchTextMap = new HashMap();
        this.descentTextMap = new HashMap();
        this.conditionalTextMap = new HashMap();
        this.nameplateTextMap = new HashMap();
        this.backGroundTextMap = new HashMap();
        this.vanillaHudMap = new HashMap();
    }

    @Override
    @NotNull
    public List<String> detectPlaceholders(String text) {
        ArrayList<String> placeholders = new ArrayList<String>();
        Matcher matcher = this.placeholderPattern.matcher(text);
        while (matcher.find()) {
            placeholders.add(matcher.group());
        }
        return placeholders;
    }

    public void reload() {
        this.unload();
        this.load();
    }

    public void load() {
        this.loadConfigs();
        if (!this.pluginPlaceholders.isRegistered()) {
            this.pluginPlaceholders.register();
        }
    }

    public void unload() {
        if (this.pluginPlaceholders.isRegistered()) {
            this.pluginPlaceholders.unregister();
        }
        this.staticTextMap.clear();
        this.switchTextMap.clear();
        this.descentTextMap.clear();
        this.conditionalTextMap.clear();
        this.nameplateTextMap.clear();
        this.backGroundTextMap.clear();
        this.vanillaHudMap.clear();
    }

    @Override
    public StaticText getStaticText(String key) {
        return this.staticTextMap.get(key);
    }

    @Override
    public Collection<StaticText> getStaticTexts() {
        return this.staticTextMap.values();
    }

    @Override
    public SwitchText getSwitchText(String key) {
        return this.switchTextMap.get(key);
    }

    @Override
    public Collection<SwitchText> getSwitchTexts() {
        return this.switchTextMap.values();
    }

    @Override
    public DescentText getDescentText(String key) {
        return this.descentTextMap.get(key);
    }

    @Override
    public Collection<DescentText> getDescentTexts() {
        return this.descentTextMap.values();
    }

    @Override
    public ConditionalText getConditionalText(String key) {
        return this.conditionalTextMap.get(key);
    }

    @Override
    public Collection<ConditionalText> getConditionalTexts() {
        return this.conditionalTextMap.values();
    }

    @Override
    public NameplateText getNameplateText(String key) {
        return this.nameplateTextMap.get(key);
    }

    @Override
    public Collection<NameplateText> getNameplateTexts() {
        return this.nameplateTextMap.values();
    }

    @Override
    public BackGroundText getBackGroundText(String key) {
        return this.backGroundTextMap.get(key);
    }

    @Override
    public Collection<BackGroundText> getBackGroundTexts() {
        return this.backGroundTextMap.values();
    }

    @Override
    public VanillaHud getVanillaHud(String key) {
        return this.vanillaHudMap.get(key);
    }

    @Override
    public Collection<VanillaHud> getVanillaHuds() {
        return this.vanillaHudMap.values();
    }

    public void loadConfigs() {
        ConfigurationSection vanillaSection;
        ConfigurationSection backgroundSection;
        ConfigurationSection nameplateSection;
        ConfigurationSection conditionalSection;
        ConfigurationSection unicodeSection;
        ConfigurationSection descentSection;
        ConfigurationSection switchSection;
        YamlConfiguration config = this.plugin.getConfig("configs" + File.separator + "custom-placeholders.yml");
        ConfigurationSection staticSection = config.getConfigurationSection("static-text");
        if (staticSection != null) {
            this.loadStaticTexts(staticSection);
        }
        if ((switchSection = config.getConfigurationSection("switch-text")) != null) {
            this.loadSwitchTexts(switchSection);
        }
        if ((descentSection = config.getConfigurationSection("descent-text")) != null) {
            this.loadDescentTexts(descentSection, false);
        }
        if ((unicodeSection = config.getConfigurationSection("descent-unicode")) != null) {
            this.loadDescentTexts(unicodeSection, true);
        }
        if ((conditionalSection = config.getConfigurationSection("conditional-text")) != null) {
            this.loadConditionalTexts(conditionalSection);
        }
        if ((nameplateSection = config.getConfigurationSection("nameplate-text")) != null) {
            this.loadNameplateTexts(nameplateSection);
        }
        if ((backgroundSection = config.getConfigurationSection("background-text")) != null) {
            this.loadBackGroundTexts(backgroundSection);
        }
        if ((vanillaSection = config.getConfigurationSection("vanilla-hud")) != null) {
            this.loadVanillaHuds(vanillaSection);
        }
    }

    private void loadVanillaHuds(ConfigurationSection section) {
        for (Map.Entry entry : section.getValues(false).entrySet()) {
            Object v = entry.getValue();
            if (!(v instanceof ConfigurationSection)) continue;
            ConfigurationSection innerSection = (ConfigurationSection)v;
            ConfiguredChar fullC = this.plugin.getImageManager().getImage(innerSection.getString("images.full", ""));
            if (fullC == null) {
                LogUtils.warn("Vanilla hud placeholder wouldn't work because image " + innerSection.getString("full", "") + " doesn't exist.");
                continue;
            }
            ConfiguredChar emptyC = this.plugin.getImageManager().getImage(innerSection.getString("images.empty", ""));
            if (emptyC == null) {
                LogUtils.warn("Vanilla hud placeholder wouldn't work because image " + innerSection.getString("empty", "") + " doesn't exist.");
                continue;
            }
            ConfiguredChar halfC = this.plugin.getImageManager().getImage(innerSection.getString("images.half", ""));
            if (halfC == null) {
                LogUtils.warn("Vanilla hud placeholder wouldn't work because image " + innerSection.getString("half", "") + " doesn't exist.");
                continue;
            }
            this.vanillaHudMap.put((String)entry.getKey(), VanillaHud.builder().reverse(innerSection.getBoolean("reverse", true)).half(halfC.getCharacter()).empty(emptyC.getCharacter()).full(fullC.getCharacter()).max(innerSection.getString("placeholder.max-value")).current(innerSection.getString("placeholder.value")).build());
        }
    }

    private void loadBackGroundTexts(ConfigurationSection section) {
        if (!CNConfig.backgroundModule) {
            return;
        }
        for (Map.Entry entry : section.getValues(false).entrySet()) {
            ConfigurationSection innerSection;
            Object v = entry.getValue();
            if (!(v instanceof ConfigurationSection) || !(innerSection = (ConfigurationSection)v).contains("background")) continue;
            String bg = innerSection.getString("background");
            BackGround background = this.plugin.getBackGroundManager().getBackGround(bg);
            if (background == null) {
                LogUtils.warn("Background: " + bg + " doesn't exist");
                continue;
            }
            this.backGroundTextMap.put((String)entry.getKey(), BackGroundText.builder().background(background).text(innerSection.getString("text", "")).removeShadow(innerSection.getBoolean("remove-shadow")).build());
        }
    }

    private void loadNameplateTexts(ConfigurationSection section) {
        if (!CNConfig.nameplateModule) {
            return;
        }
        for (Map.Entry entry : section.getValues(false).entrySet()) {
            Object v = entry.getValue();
            if (!(v instanceof ConfigurationSection)) continue;
            ConfigurationSection innerSection = (ConfigurationSection)v;
            Nameplate nameplate = this.plugin.getNameplateManager().getNameplate(innerSection.getString("nameplate"));
            if (nameplate == null) {
                LogUtils.warn("Nameplate: " + innerSection.getString("nameplate") + " doesn't exist. nameplate-text: " + (String)entry.getKey() + " would not take effect");
                continue;
            }
            this.nameplateTextMap.put((String)entry.getKey(), NameplateText.builder().nameplate(nameplate).text(innerSection.getString("text", "")).build());
        }
    }

    private void loadDescentTexts(ConfigurationSection section, boolean unicode) {
        for (Map.Entry entry : section.getValues(false).entrySet()) {
            Object v = entry.getValue();
            if (!(v instanceof ConfigurationSection)) continue;
            ConfigurationSection innerSection = (ConfigurationSection)v;
            this.descentTextMap.put((String)entry.getKey(), DescentText.builder().descent(innerSection.getInt("descent", 0)).text(innerSection.getString("text", "")).unicode(unicode || innerSection.getBoolean("is-unicode")).build());
        }
    }

    private void loadStaticTexts(ConfigurationSection section) {
        for (Map.Entry entry : section.getValues(false).entrySet()) {
            Object v = entry.getValue();
            if (!(v instanceof ConfigurationSection)) continue;
            ConfigurationSection innerSection = (ConfigurationSection)v;
            this.staticTextMap.put((String)entry.getKey(), StaticText.builder().value(innerSection.getInt("value")).text(innerSection.getString("text")).state(StaticText.StaticState.valueOf(innerSection.getString("position", "middle").toUpperCase(Locale.ENGLISH))).build());
        }
    }

    private void loadSwitchTexts(ConfigurationSection section) {
        for (Map.Entry entry : section.getValues(false).entrySet()) {
            Object v = entry.getValue();
            if (!(v instanceof ConfigurationSection)) continue;
            ConfigurationSection innerSection = (ConfigurationSection)v;
            HashMap<String, String> valueMap = new HashMap<String, String>();
            ConfigurationSection valueSection = innerSection.getConfigurationSection("case");
            if (valueSection != null) {
                for (String key : valueSection.getKeys(false)) {
                    valueMap.put(key, valueSection.getString(key));
                }
            }
            this.switchTextMap.put((String)entry.getKey(), SwitchText.builder().toParse(Objects.requireNonNull(innerSection.getString("switch"))).defaultValue(innerSection.getString("default")).valueMap(valueMap).build());
        }
    }

    private void loadConditionalTexts(ConfigurationSection section) {
        for (Map.Entry entry : section.getValues(false).entrySet()) {
            Object v = entry.getValue();
            if (!(v instanceof ConfigurationSection)) continue;
            ConfigurationSection innerSection = (ConfigurationSection)v;
            ArrayList<Pair<String, Requirement[]>> list = new ArrayList<Pair<String, Requirement[]>>();
            for (Map.Entry innerEntry : innerSection.getValues(false).entrySet()) {
                Object v2 = innerEntry.getValue();
                if (!(v2 instanceof ConfigurationSection)) continue;
                ConfigurationSection prioritySection = (ConfigurationSection)v2;
                list.add(Pair.of(prioritySection.getString("text"), this.plugin.getRequirementManager().getRequirements(prioritySection.getConfigurationSection("conditions"))));
            }
            this.conditionalTextMap.put((String)entry.getKey(), ConditionalText.builder().textList(list).build());
        }
    }
}

