/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.paper.mechanic.team;

import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketListener;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import net.momirealms.customnameplates.api.CustomNameplatesPlugin;
import net.momirealms.customnameplates.api.manager.TeamManager;
import net.momirealms.customnameplates.api.util.LogUtils;
import net.momirealms.customnameplates.common.team.TeamCollisionRule;
import net.momirealms.customnameplates.common.team.TeamColor;
import net.momirealms.customnameplates.common.team.TeamTagVisibility;
import net.momirealms.customnameplates.paper.mechanic.misc.PacketManager;
import net.momirealms.customnameplates.paper.mechanic.team.packet.TeamCreate;
import net.momirealms.customnameplates.paper.mechanic.team.packet.TeamPacketAdaptor;
import net.momirealms.customnameplates.paper.mechanic.team.packet.TeamPacket_1_17;
import net.momirealms.customnameplates.paper.mechanic.team.packet.TeamRemove;
import net.momirealms.customnameplates.paper.mechanic.team.packet.TeamUpdate;
import net.momirealms.customnameplates.paper.mechanic.team.provider.CMIProvider;
import net.momirealms.customnameplates.paper.mechanic.team.provider.DefaultProvider;
import net.momirealms.customnameplates.paper.mechanic.team.provider.TABProvider;
import net.momirealms.customnameplates.paper.mechanic.team.provider.TeamProvider;
import net.momirealms.customnameplates.paper.mechanic.team.provider.UnknownProvider;
import net.momirealms.customnameplates.paper.setting.CNConfig;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;
import org.jetbrains.annotations.NotNull;

public class TeamManagerImpl
implements TeamManager,
PluginMessageListener {
    private final CustomNameplatesPlugin plugin;
    private final TeamPacketAdaptor teamPacketAdaptor;
    private TeamProvider teamProvider;
    private static final String CHANNEL = "customnameplates:cnp";

    public TeamManagerImpl(CustomNameplatesPlugin plugin) {
        this.plugin = plugin;
        this.teamPacketAdaptor = new TeamPacket_1_17();
    }

    @Override
    public void createTeam(Player player) {
        if (CNConfig.disableTeamManage) {
            return;
        }
        if (CNConfig.isOtherTeamPluginHooked()) {
            return;
        }
        String team = this.teamProvider.getTeam(player, null);
        if (!team.equals(player.getName())) {
            return;
        }
        if (CNConfig.createRealTeam) {
            Scoreboard scoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
            Team playerTeam = scoreboard.getTeam(team);
            if (playerTeam == null) {
                playerTeam = scoreboard.registerNewTeam(team);
            }
            playerTeam.addPlayer((OfflinePlayer)player);
        } else {
            PacketContainer createOwner = this.teamPacketAdaptor.getTeamCreatePacket(TeamCreate.builder().teamName(team).color(TeamColor.WHITE).display("").prefix("").suffix("").members(Collections.singletonList(player.getName())).collisionRule(TeamCollisionRule.ALWAYS).tagVisibility(TeamTagVisibility.ALWAYS).build());
            for (Player online : Bukkit.getOnlinePlayers()) {
                PacketManager.getInstance().send(online, createOwner);
                if (online == player) continue;
                String onlineTeam = this.teamProvider.getTeam(online, null);
                PacketContainer createOther = this.teamPacketAdaptor.getTeamCreatePacket(TeamCreate.builder().teamName(onlineTeam).color(TeamColor.WHITE).display("").prefix("").suffix("").members(Collections.singletonList(online.getName())).collisionRule(TeamCollisionRule.ALWAYS).tagVisibility(TeamTagVisibility.ALWAYS).build());
                PacketManager.getInstance().send(player, createOther);
            }
        }
    }

    @Override
    public void removeTeam(Player player) {
        if (CNConfig.disableTeamManage) {
            return;
        }
        if (CNConfig.isOtherTeamPluginHooked()) {
            return;
        }
        String team = this.teamProvider.getTeam(player, null);
        if (!team.equals(player.getName())) {
            return;
        }
        if (CNConfig.createRealTeam) {
            Scoreboard scoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
            Optional.ofNullable(scoreboard.getTeam(team)).ifPresent(Team::unregister);
        } else {
            PacketContainer packet = this.teamPacketAdaptor.getTeamRemovePacket(TeamRemove.builder().teamName(team).build());
            for (Player online : Bukkit.getOnlinePlayers()) {
                if (player == online) continue;
                PacketManager.getInstance().send(online, packet);
            }
        }
    }

    @Override
    public void updateTeam(Player owner, Player viewer, String prefix, String suffix, TeamColor color, TeamTagVisibility visibility) {
        if (CNConfig.disableTeamManage) {
            return;
        }
        String team = this.teamProvider.getTeam(owner, viewer);
        if (team == null) {
            LogUtils.warn("Failed to get player " + owner.getName() + "'s team for viewer " + viewer.getName());
            return;
        }
        if (color == TeamColor.NONE || color == TeamColor.CUSTOM) {
            color = TeamColor.WHITE;
        }
        if (this.plugin.getNameplateManager().isProxyMode()) {
            this.sendPluginMessage("2", owner.getName(), viewer.getName(), prefix, suffix, color.name(), visibility.name());
        } else {
            PacketContainer packet = this.teamPacketAdaptor.getTeamUpdatePacket(TeamUpdate.builder().teamName(team).color(color).display("").prefix(prefix).suffix(suffix).tagVisibility(visibility).collisionRule(TeamCollisionRule.ALWAYS).build());
            PacketManager.getInstance().send(viewer, packet);
        }
    }

    public void reload() {
        this.unload();
        this.load();
    }

    public void unload() {
        TeamProvider teamProvider = this.teamProvider;
        if (teamProvider instanceof Listener) {
            Listener listener = (Listener)teamProvider;
            HandlerList.unregisterAll((Listener)listener);
        }
        if ((teamProvider = this.teamProvider) instanceof PacketAdapter) {
            PacketAdapter adapter = (PacketAdapter)teamProvider;
            ProtocolLibrary.getProtocolManager().removePacketListener((PacketListener)adapter);
        }
        Bukkit.getServer().getMessenger().unregisterIncomingPluginChannel((Plugin)this.plugin, CHANNEL);
        Bukkit.getServer().getMessenger().unregisterOutgoingPluginChannel((Plugin)this.plugin, CHANNEL);
    }

    public void load() {
        this.teamProvider = CNConfig.tabTeam ? new TABProvider() : (CNConfig.cmiTeam ? new CMIProvider() : (CNConfig.unknownTeam ? new UnknownProvider() : new DefaultProvider()));
        TeamProvider teamProvider = this.teamProvider;
        if (teamProvider instanceof Listener) {
            Listener listener = (Listener)teamProvider;
            Bukkit.getPluginManager().registerEvents(listener, (Plugin)this.plugin);
        }
        if ((teamProvider = this.teamProvider) instanceof PacketAdapter) {
            PacketAdapter adapter = (PacketAdapter)teamProvider;
            ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)adapter);
        }
        Bukkit.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this.plugin, CHANNEL);
        Bukkit.getServer().getMessenger().registerIncomingPluginChannel((Plugin)this.plugin, CHANNEL, (PluginMessageListener)this);
    }

    @Override
    public String getTeamName(Player player, Player viewer) {
        return this.teamProvider.getTeam(player, viewer);
    }

    private void handleMessage(String ... message) {
    }

    public void onPluginMessageReceived(@NotNull String channel, @NotNull Player player, @NotNull byte[] message) {
        if (!Objects.equals(CHANNEL, channel)) {
            return;
        }
        ByteArrayDataInput dataInput = ByteStreams.newDataInput((byte[])message);
        int args = dataInput.readByte();
        String[] messages = new String[args];
        for (int i = 0; i < args; ++i) {
            messages[i] = dataInput.readUTF();
        }
        this.handleMessage(messages);
    }

    public void sendPluginMessage(String ... messages) {
        ByteArrayDataOutput dataOutput = ByteStreams.newDataOutput();
        dataOutput.writeByte(messages.length);
        for (String message : messages) {
            dataOutput.writeUTF(message);
        }
        Bukkit.getOnlinePlayers().stream().findAny().ifPresent(player -> player.sendPluginMessage((Plugin)this.plugin, CHANNEL, dataOutput.toByteArray()));
    }

    public void disable() {
        this.unload();
        if (CNConfig.disableTeamManage) {
            return;
        }
        if (CNConfig.isOtherTeamPluginHooked()) {
            return;
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.removeTeam(player);
        }
    }
}

