/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.paper.mechanic.team.packet;

import java.util.Collection;
import net.momirealms.customnameplates.common.team.TeamCollisionRule;
import net.momirealms.customnameplates.common.team.TeamColor;
import net.momirealms.customnameplates.common.team.TeamTagVisibility;
import net.momirealms.customnameplates.libraries.adventure.text.Component;
import net.momirealms.customnameplates.paper.adventure.AdventureManagerImpl;

public class TeamCreate {
    private String teamName;
    private Collection<String> members;
    private Object teamDisplay;
    private Object teamPrefix;
    private Object teamSuffix;
    private TeamTagVisibility tagVisibility;
    private TeamCollisionRule collisionRule;
    private TeamColor teamColor;

    private TeamCreate() {
    }

    public TeamCreate(String teamName, Collection<String> members, Component teamDisplay, Component teamPrefix, Component teamSuffix, TeamTagVisibility tagVisibility, TeamCollisionRule collisionRule, TeamColor teamColor) {
        this.teamName = teamName;
        this.members = members;
        this.teamDisplay = teamDisplay;
        this.teamPrefix = teamPrefix;
        this.teamSuffix = teamSuffix;
        this.tagVisibility = tagVisibility;
        this.collisionRule = collisionRule;
        this.teamColor = teamColor;
    }

    public String getTeamName() {
        return this.teamName;
    }

    public Collection<String> getMembers() {
        return this.members;
    }

    public Object getTeamDisplay() {
        return this.teamDisplay;
    }

    public Object getTeamPrefix() {
        return this.teamPrefix;
    }

    public Object getTeamSuffix() {
        return this.teamSuffix;
    }

    public TeamTagVisibility getTagVisibility() {
        return this.tagVisibility;
    }

    public TeamCollisionRule getCollisionRule() {
        return this.collisionRule;
    }

    public TeamColor getTeamColor() {
        return this.teamColor;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final TeamCreate packet = new TeamCreate();

        public static Builder of() {
            return new Builder();
        }

        public Builder teamName(String name) {
            this.packet.teamName = name;
            return this;
        }

        public Builder members(Collection<String> members) {
            this.packet.members = members;
            return this;
        }

        public Builder display(String display) {
            this.packet.teamDisplay = AdventureManagerImpl.getInstance().getIChatComponentFromMiniMessage(display);
            return this;
        }

        public Builder prefix(String prefix) {
            this.packet.teamPrefix = AdventureManagerImpl.getInstance().getIChatComponentFromMiniMessage(prefix);
            return this;
        }

        public Builder suffix(String suffix) {
            this.packet.teamSuffix = AdventureManagerImpl.getInstance().getIChatComponentFromMiniMessage(suffix);
            return this;
        }

        public Builder color(TeamColor color) {
            this.packet.teamColor = color;
            return this;
        }

        public Builder tagVisibility(TeamTagVisibility visibility) {
            this.packet.tagVisibility = visibility;
            return this;
        }

        public Builder collisionRule(TeamCollisionRule rule) {
            this.packet.collisionRule = rule;
            return this;
        }

        public TeamCreate build() {
            return this.packet;
        }
    }
}

