/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.paper.mechanic.team.provider;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.UUID;
import net.momirealms.customnameplates.api.CustomNameplatesPlugin;
import net.momirealms.customnameplates.paper.mechanic.team.provider.TeamProvider;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class UnknownProvider
extends PacketAdapter
implements TeamProvider,
Listener {
    private final HashMap<UUID, PlayerTeamView> teamViewMap = new HashMap();

    public UnknownProvider() {
        super((Plugin)CustomNameplatesPlugin.getInstance(), ListenerPriority.HIGHEST, new PacketType[]{PacketType.Play.Server.SCOREBOARD_TEAM});
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.teamViewMap.put(event.getPlayer().getUniqueId(), new PlayerTeamView());
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.teamViewMap.remove(event.getPlayer().getUniqueId());
    }

    public void onPacketSending(PacketEvent event) {
        Player receiver = event.getPlayer();
        PlayerTeamView view = this.teamViewMap.get(receiver.getUniqueId());
        if (view == null) {
            return;
        }
        PacketContainer packet = event.getPacket();
        String team = (String)packet.getModifier().read(1);
        switch ((Integer)packet.getModifier().read(0)) {
            case 0: 
            case 3: {
                view.addMembers(team, (Collection)packet.getModifier().read(2));
                break;
            }
            case 1: {
                view.removeTeam(team);
                break;
            }
            case 4: {
                view.removeMembers(team, (Collection)packet.getModifier().read(2));
                break;
            }
        }
    }

    @Override
    public String getTeam(Player player, Player viewer) {
        String team;
        PlayerTeamView view = this.teamViewMap.get(viewer.getUniqueId());
        if (view != null && (team = view.getTeam(player)) != null) {
            return team;
        }
        CustomNameplatesPlugin.get().debug("Getting real teams for " + player.getName() + " viewer: " + viewer.getName());
        Scoreboard scoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
        Team team2 = scoreboard.getPlayerTeam((OfflinePlayer)player);
        if (team2 == null) {
            return null;
        }
        return team2.getName();
    }

    public static class PlayerTeamView {
        private final HashMap<String, String> playerToTeamMap = new HashMap();
        private final HashMap<String, String[]> teamToPlayerMap = new HashMap();

        public String getTeam(Player player) {
            return this.playerToTeamMap.get(player.getName());
        }

        public void removeTeam(String team) {
            String[] removedMembers = this.teamToPlayerMap.remove(team);
            if (removedMembers != null) {
                for (String member : removedMembers) {
                    this.playerToTeamMap.remove(member);
                }
            }
        }

        public void addMembers(String team, Collection<String> members) {
            String[] oldMembers = this.teamToPlayerMap.remove(team);
            if (oldMembers != null) {
                String[] newMembers = new String[members.size() + oldMembers.length];
                int i = 0;
                Object object = oldMembers;
                int n = ((String[])object).length;
                for (int j = 0; j < n; ++j) {
                    String m;
                    newMembers[i] = m = object[j];
                    ++i;
                }
                object = members.iterator();
                while (object.hasNext()) {
                    String m;
                    newMembers[i] = m = (String)object.next();
                    ++i;
                }
                this.teamToPlayerMap.put(team, newMembers);
                for (String member : newMembers) {
                    this.playerToTeamMap.put(member, team);
                }
            } else {
                this.teamToPlayerMap.put(team, members.toArray(new String[0]));
                for (String member : members) {
                    this.playerToTeamMap.put(member, team);
                }
            }
        }

        public void removeMembers(String team, Collection<String> members) {
            String[] oldMembers = this.teamToPlayerMap.remove(team);
            if (oldMembers != null) {
                ArrayList<String> newMembers = new ArrayList<String>(Arrays.asList(oldMembers));
                for (String member : members) {
                    this.playerToTeamMap.remove(member);
                    newMembers.remove(member);
                }
                this.teamToPlayerMap.put(team, newMembers.toArray(new String[0]));
            }
        }
    }
}

