/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.paper.scheduler;

import net.momirealms.customnameplates.api.scheduler.CancellableTask;
import net.momirealms.customnameplates.paper.CustomNameplatesPluginImpl;
import net.momirealms.customnameplates.paper.scheduler.SyncScheduler;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class BukkitSchedulerImpl
implements SyncScheduler {
    private final CustomNameplatesPluginImpl plugin;

    public BukkitSchedulerImpl(CustomNameplatesPluginImpl plugin) {
        this.plugin = plugin;
    }

    @Override
    public void runSyncTask(Runnable runnable, Location location) {
        if (Bukkit.isPrimaryThread()) {
            runnable.run();
        } else {
            Bukkit.getScheduler().runTask((Plugin)this.plugin, runnable);
        }
    }

    @Override
    public CancellableTask runTaskSyncTimer(Runnable runnable, Location location, long delay, long period) {
        return new BukkitCancellableTask(Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, runnable, delay, period));
    }

    @Override
    public CancellableTask runTaskSyncLater(Runnable runnable, Location location, long delay) {
        return new BukkitCancellableTask(Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, runnable, delay));
    }

    public static class BukkitCancellableTask
    implements CancellableTask {
        private final BukkitTask bukkitTask;

        public BukkitCancellableTask(BukkitTask bukkitTask) {
            this.bukkitTask = bukkitTask;
        }

        @Override
        public void cancel() {
            this.bukkitTask.cancel();
        }

        @Override
        public boolean isCancelled() {
            return this.bukkitTask.isCancelled();
        }
    }
}

