/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.paper.storage.method.file;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.momirealms.customnameplates.api.data.PlayerData;
import net.momirealms.customnameplates.api.data.StorageType;
import net.momirealms.customnameplates.paper.CustomNameplatesPluginImpl;
import net.momirealms.customnameplates.paper.storage.method.AbstractStorage;
import org.bukkit.Bukkit;

public class JsonImpl
extends AbstractStorage {
    public JsonImpl(CustomNameplatesPluginImpl plugin) {
        super(plugin);
        File folder = new File(plugin.getDataFolder(), "data");
        if (!folder.exists()) {
            folder.mkdirs();
        }
    }

    @Override
    public StorageType getStorageType() {
        return StorageType.JSON;
    }

    @Override
    public CompletableFuture<Optional<PlayerData>> getPlayerData(UUID uuid) {
        File file = this.getPlayerDataFile(uuid);
        PlayerData playerData = file.exists() ? this.readFromJsonFile(file, PlayerData.class) : (Bukkit.getPlayer((UUID)uuid) != null ? PlayerData.empty() : null);
        return CompletableFuture.completedFuture(Optional.ofNullable(playerData));
    }

    public File getPlayerDataFile(UUID uuid) {
        return new File(this.plugin.getDataFolder(), "data" + File.separator + uuid + ".json");
    }

    public void saveToJsonFile(Object obj, File filepath) {
        Gson gson = new Gson();
        try (FileWriter file = new FileWriter(filepath);){
            gson.toJson(obj, (Appendable)file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public <T> T readFromJsonFile(File file, Class<T> classOfT) {
        Gson gson = new Gson();
        String jsonContent = new String(this.readFileToByteArray(file), StandardCharsets.UTF_8);
        return (T)gson.fromJson(jsonContent, classOfT);
    }

    public byte[] readFileToByteArray(File file) {
        byte[] fileBytes = new byte[(int)file.length()];
        try (FileInputStream fis = new FileInputStream(file);){
            fis.read(fileBytes);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return fileBytes;
    }

    @Override
    public CompletableFuture<Boolean> updatePlayerData(UUID uuid, PlayerData playerData) {
        this.saveToJsonFile(playerData, this.getPlayerDataFile(uuid));
        return CompletableFuture.completedFuture(true);
    }

    @Override
    public Set<UUID> getUniqueUsers(boolean legacy) {
        File[] files;
        File folder = new File(this.plugin.getDataFolder(), "data");
        HashSet<UUID> uuids = new HashSet<UUID>();
        if (folder.exists() && (files = folder.listFiles()) != null) {
            for (File file : files) {
                uuids.add(UUID.fromString(file.getName().substring(file.getName().length() - 5)));
            }
        }
        return uuids;
    }
}

