/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.velocity;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import com.google.inject.Inject;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.PluginMessageEvent;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.Dependency;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.proxy.messages.MinecraftChannelIdentifier;
import java.time.Duration;
import java.util.Optional;
import net.momirealms.customnameplates.common.team.TeamColor;
import net.momirealms.customnameplates.common.team.TeamTagVisibility;
import net.momirealms.customnameplates.libraries.adventure.text.Component;
import net.momirealms.customnameplates.libraries.adventure.text.minimessage.MiniMessage;
import net.momirealms.customnameplates.velocity.team.VelocitabManager;
import net.momirealms.customnameplates.velocity.team.VelocityTeamManager;
import org.slf4j.Logger;

@Plugin(id="customnameplates", name="CustomNameplates", version="2.3", authors={"XiaoMoMi"}, dependencies={@Dependency(id="velocitab", optional=true)})
public class CustomNameplatesVelocity {
    private static final String CHANNEL = "customnameplates:cnp";
    private static CustomNameplatesVelocity instance;
    private final ProxyServer server;
    private final Logger logger;
    private VelocityTeamManager teamManager;

    @Inject
    public CustomNameplatesVelocity(ProxyServer server, Logger logger) {
        this.server = server;
        this.logger = logger;
    }

    @Subscribe
    public void onInit(ProxyInitializeEvent event) {
        instance = this;
        this.server.getChannelRegistrar().register(new ChannelIdentifier[]{MinecraftChannelIdentifier.from((String)CHANNEL)});
        Optional optContainer = this.server.getPluginManager().getPlugin("velocitab");
        if (optContainer.isEmpty()) {
            this.logger.warn("You don't have to install CustomNameplates on Velocity if you don't use Velocitab");
            this.server.shutdown();
        } else {
            this.teamManager = new VelocitabManager((PluginContainer)optContainer.get());
        }
    }

    @Subscribe
    public void onShutdown(ProxyShutdownEvent event) {
        this.server.getChannelRegistrar().unregister(new ChannelIdentifier[]{MinecraftChannelIdentifier.from((String)CHANNEL)});
    }

    @Subscribe
    public void onPluginMessage(PluginMessageEvent event) {
        if (!event.getIdentifier().getId().equals(CHANNEL)) {
            return;
        }
        if (this.teamManager == null) {
            this.logger.warn("No team manager available");
            return;
        }
        ByteArrayDataInput dataInput = ByteStreams.newDataInput((byte[])event.getData());
        byte length = dataInput.readByte();
        if (length != 7) {
            return;
        }
        String type = dataInput.readUTF();
        if (!type.equals("2")) {
            return;
        }
        Optional optionalOwner = this.server.getPlayer(dataInput.readUTF());
        if (optionalOwner.isEmpty()) {
            return;
        }
        Player owner = (Player)optionalOwner.get();
        Optional optionalViewer = this.server.getPlayer(dataInput.readUTF());
        if (optionalViewer.isEmpty()) {
            return;
        }
        Player viewer = (Player)optionalViewer.get();
        String prefix = dataInput.readUTF();
        String suffix = dataInput.readUTF();
        TeamColor teamColor = TeamColor.valueOf(dataInput.readUTF());
        TeamTagVisibility visibility = TeamTagVisibility.valueOf(dataInput.readUTF());
        if (this.teamManager instanceof VelocitabManager) {
            this.server.getScheduler().buildTask((Object)this, () -> {
                if (!owner.isActive() || !viewer.isActive()) {
                    return;
                }
                String teamNameRetry = this.teamManager.getTeam(owner, null);
                if (teamNameRetry != null) {
                    this.teamManager.sendTeamUpdatePacket(viewer, teamNameRetry, teamColor, visibility, (Component)MiniMessage.miniMessage().deserialize(prefix), (Component)MiniMessage.miniMessage().deserialize(suffix));
                } else {
                    this.logger.warn("Failed to get player " + owner.getUsername() + "'s team name.");
                }
            }).delay(Duration.ofMillis(500L)).schedule();
        }
    }

    public static CustomNameplatesVelocity get() {
        return instance;
    }

    public static CustomNameplatesVelocity getPlugin() {
        return instance;
    }
}

