/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.velocity.team;

import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.proxy.connection.client.ConnectedPlayer;
import java.util.List;
import java.util.Optional;
import net.momirealms.customnameplates.common.team.TeamColor;
import net.momirealms.customnameplates.common.team.TeamTagVisibility;
import net.momirealms.customnameplates.libraries.adventure.text.Component;
import net.momirealms.customnameplates.velocity.team.VelocityTeamManager;
import net.william278.velocitab.Velocitab;
import net.william278.velocitab.api.VelocitabAPI;
import net.william278.velocitab.packet.UpdateTeamsPacket;
import net.william278.velocitab.player.TabPlayer;
import org.jetbrains.annotations.Nullable;

public class VelocitabManager
implements VelocityTeamManager {
    private final Velocitab velocitab;
    private final VelocitabAPI velocitabAPI;

    public VelocitabManager(PluginContainer pluginContainer) {
        this.velocitab = (Velocitab)pluginContainer.getInstance().get();
        this.velocitabAPI = VelocitabAPI.getInstance();
    }

    @Override
    @Nullable
    public String getTeam(Player player, Player viewer) {
        Optional playerOptional = this.velocitabAPI.getUser(player);
        return playerOptional.map(TabPlayer::getTeamName).orElse(null);
    }

    @Override
    public void sendTeamUpdatePacket(Player receiver, String team, TeamColor color, TeamTagVisibility visibility, Component prefix, Component suffix) {
        UpdateTeamsPacket packet = new UpdateTeamsPacket(this.velocitab).teamName(team.length() > 16 ? team.substring(0, 16) : team).mode(UpdateTeamsPacket.UpdateMode.UPDATE_INFO).displayName((Component)Component.empty()).friendlyFlags(List.of(UpdateTeamsPacket.FriendlyFlag.CAN_HURT_FRIENDLY)).nametagVisibility(UpdateTeamsPacket.NametagVisibility.valueOf((String)visibility.name())).collisionRule(UpdateTeamsPacket.CollisionRule.ALWAYS).color(UpdateTeamsPacket.TeamColor.valueOf((String)color.name()).ordinal()).prefix(prefix).suffix(suffix);
        ConnectedPlayer connectedPlayer = (ConnectedPlayer)receiver;
        connectedPlayer.getConnection().write((Object)packet);
    }
}

