/*
 * Decompiled with CFR 0.152.
 */
package com.valorin.arenas;

import com.valorin.Main;
import com.valorin.arenas.ArenaCommands;
import com.valorin.arenas.FinishGame;
import com.valorin.configuration.ConfigManager;
import com.valorin.configuration.languagefile.MessageSender;
import com.valorin.dan.CustomDan;
import com.valorin.data.encapsulation.ArenaInfo;
import com.valorin.util.ItemTaker;
import com.valorin.util.ViaVersion;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class Arena {
    private final String name;
    private String p1;
    private String p2;
    private List<String> watchers;
    private boolean enable = false;
    private BukkitTask timer;
    private int taskId;
    private int time;
    private int countDown;
    private int timeout;
    private int stage = -1;
    private double player1Damage;
    private double player1MaxDamage;
    private double player2Damage;
    private double player2MaxDamage;
    private int player1Exp;
    private int player2Exp;
    private int player1MultiHit;
    private int player2MultiHit;
    private Location player1Location;
    private Location player2Location;
    private CustomDan player1Dan;
    private CustomDan player2Dan;
    private List<ItemStack> player1InventoryItems;
    private List<ItemStack> player2InventoryItems;
    private ItemStack player1Helmet;
    private ItemStack player2Helmet;
    private ItemStack player1ChestPlate;
    private ItemStack player2ChestPlate;
    private ItemStack player1Leggings;
    private ItemStack player2Leggings;
    private ItemStack player1Boots;
    private ItemStack player2Boots;
    private ItemStack player1OffHandItem;
    private ItemStack player2OffHandItem;
    private boolean canTeleport;
    private boolean watchersTeleport;
    private int startWay;

    public Arena(String name) {
        this.name = name;
    }

    public void start(final String p1, final String p2, int startWay) {
        this.p1 = p1;
        this.p2 = p2;
        this.startWay = startWay;
        this.watchers = new ArrayList<String>();
        this.canTeleport = false;
        this.watchersTeleport = false;
        this.enable = true;
        this.time = this.getCountDown();
        final ConfigManager configManager = Main.getInstance().getConfigManager();
        this.timeout = configManager.getGameTimeOut();
        this.stage = 0;
        Player player1 = Bukkit.getPlayerExact((String)p1);
        Player player2 = Bukkit.getPlayerExact((String)p2);
        MessageSender.sm("&7\u6bd4\u8d5b\u5373\u5c06\u5f00\u59cb..", player1, player2);
        ArenaInfo arenaInfo = Main.getInstance().getCacheHandler().getArenaInfo().get(this.name);
        if (arenaInfo.isKitMode()) {
            PlayerInventory player1Inventory = player1.getInventory();
            PlayerInventory player2Inventory = player2.getInventory();
            ItemStack air = new ItemStack(Material.AIR, 1);
            this.player1InventoryItems = new ArrayList<ItemStack>();
            this.player2InventoryItems = new ArrayList<ItemStack>();
            for (int i = 0; i < 36; ++i) {
                if (player1Inventory.getItem(i) != null) {
                    this.player1InventoryItems.add(player1Inventory.getItem(i));
                } else {
                    this.player1InventoryItems.add(air);
                }
                if (player2Inventory.getItem(i) != null) {
                    this.player2InventoryItems.add(player2Inventory.getItem(i));
                    continue;
                }
                this.player2InventoryItems.add(air);
            }
            this.player1Helmet = player1Inventory.getItem(36) != null ? player1Inventory.getItem(36) : air;
            this.player2Helmet = player2Inventory.getItem(36) != null ? player2Inventory.getItem(36) : air;
            this.player1ChestPlate = player1Inventory.getItem(37) != null ? player1Inventory.getItem(37) : air;
            this.player2ChestPlate = player2Inventory.getItem(37) != null ? player2Inventory.getItem(37) : air;
            this.player1Leggings = player1Inventory.getItem(38) != null ? player1Inventory.getItem(38) : air;
            this.player2Leggings = player2Inventory.getItem(38) != null ? player2Inventory.getItem(38) : air;
            this.player1Boots = player1Inventory.getItem(39) != null ? player1Inventory.getItem(39) : air;
            this.player2Boots = player2Inventory.getItem(39) != null ? player2Inventory.getItem(39) : air;
            if (ViaVersion.isHasOffHandMethod()) {
                this.player1OffHandItem = ViaVersion.getItemInOffHand(player1);
                this.player2OffHandItem = ViaVersion.getItemInOffHand(player2);
            }
            ItemTaker.cleanInventory(player1);
            ItemTaker.cleanInventory(player2);
            if (arenaInfo.getKit() != null) {
                for (ItemStack kitItem : arenaInfo.getKit()) {
                    Material material = kitItem.getType();
                    if (ViaVersion.isHelmet(material) && player1.getInventory().getItem(39) == null) {
                        player1.getInventory().setItem(39, kitItem);
                        player2.getInventory().setItem(39, kitItem);
                        continue;
                    }
                    if (ViaVersion.isChestPlate(material) && player1.getInventory().getItem(38) == null) {
                        player1.getInventory().setItem(38, kitItem);
                        player2.getInventory().setItem(38, kitItem);
                        continue;
                    }
                    if (ViaVersion.isLeggings(material) && player1.getInventory().getItem(37) == null) {
                        player1.getInventory().setItem(37, kitItem);
                        player2.getInventory().setItem(37, kitItem);
                        continue;
                    }
                    if (ViaVersion.isBoots(material) && player1.getInventory().getItem(36) == null) {
                        player1.getInventory().setItem(36, kitItem);
                        player2.getInventory().setItem(36, kitItem);
                        continue;
                    }
                    if (Material.getMaterial((String)"SHIELD") != null && material.toString().equals("SHIELD")) {
                        ViaVersion.setItemInOffHand(player1, new ItemStack(Material.getMaterial((String)"SHIELD")));
                        ViaVersion.setItemInOffHand(player2, new ItemStack(Material.getMaterial((String)"SHIELD")));
                        continue;
                    }
                    player1.getInventory().addItem(new ItemStack[]{kitItem});
                    player2.getInventory().addItem(new ItemStack[]{kitItem});
                }
            }
            for (PotionEffect potionEffect : player1.getActivePotionEffects()) {
                player1.removePotionEffect(potionEffect.getType());
            }
            for (PotionEffect potionEffect : player2.getActivePotionEffects()) {
                player2.removePotionEffect(potionEffect.getType());
            }
        }
        this.timer = new BukkitRunnable(){

            public void run() {
                Player player1 = Bukkit.getPlayerExact((String)p1);
                Player player2 = Bukkit.getPlayerExact((String)p2);
                Arena.this.time = Arena.this.time + 1;
                if (Arena.this.time >= 0) {
                    if (Arena.this.time == 0) {
                        Arena.this.stage = 1;
                        player1.playSound(player1.getLocation(), ViaVersion.getSound("ENTITY_PLAYER_LEVELUP", "LEVELUP"), 1.0f, 0.0f);
                        player2.playSound(player2.getLocation(), ViaVersion.getSound("ENTITY_PLAYER_LEVELUP", "LEVELUP"), 1.0f, 0.0f);
                        MessageSender.sm("&a\u6bd4\u8d5b\u5f00\u59cb\uff01\uff01\u4eae\u5251\u5427\uff01", player1, player2);
                        ViaVersion.sendTitle(player1, MessageSender.gm("&a&l\u6218\u6597\u5f00\u59cb", player1), MessageSender.gm("&2\u6bd4\u8d5b\u5c06\u5728 &a&l{time} &2\u79d2\u540e\u7ed3\u675f\uff0c\u8bf7\u5c3d\u5feb\u51fb\u8d25\u5bf9\u624b\uff01", player1, "time", new String[]{"" + Arena.this.timeout}), 20, 40, 10);
                        ViaVersion.sendTitle(player2, MessageSender.gm("&a&l\u6218\u6597\u5f00\u59cb", player2), MessageSender.gm("&2\u6bd4\u8d5b\u5c06\u5728 &a&l{time} &2\u79d2\u540e\u7ed3\u675f\uff0c\u8bf7\u5c3d\u5feb\u51fb\u8d25\u5bf9\u624b\uff01", player2, "time", new String[]{"" + Arena.this.timeout}), 20, 40, 10);
                        ArenaCommands.executeArenaCommands(Arena.this.name, player1, player2);
                    }
                    ViaVersion.sendActionBar(player1, MessageSender.gm("&b\u6bd4\u8d5b\u65f6\u95f4\u5269\u4f59 &6{second} &b\u79d2", player1, "second", new String[]{"" + (Arena.this.timeout - Arena.this.time)}));
                    ViaVersion.sendActionBar(player2, MessageSender.gm("&b\u6bd4\u8d5b\u65f6\u95f4\u5269\u4f59 &6{second} &b\u79d2", player1, "second", new String[]{"" + (Arena.this.timeout - Arena.this.time)}));
                    if (Arena.this.time >= Arena.this.timeout) {
                        if (configManager.isTimeOutHandlingSchemeEnabled()) {
                            ConfigManager.TimeOutHandlingScheme scheme = configManager.getTimeOutHandlingScheme();
                            if (scheme.equals((Object)ConfigManager.TimeOutHandlingScheme.COMPARE_HEALTH_VALUE)) {
                                double player2HealthValue;
                                double player1HealthValue = BigDecimal.valueOf(player1.getHealth()).setScale(1, 4).doubleValue();
                                if (player1HealthValue != (player2HealthValue = BigDecimal.valueOf(player2.getHealth()).setScale(1, 4).doubleValue())) {
                                    if (player1HealthValue > player2HealthValue) {
                                        MessageSender.sm("&3\u6bd4\u8d5b\u8d85\u65f6\uff0c\u73a9\u5bb6 &b{winner} &3\u7684\u8840\u91cf\u4e3a &b{winner_health_value} &3\u70b9\uff0c\u591a\u4e8e\u73a9\u5bb6 &b{loser} &3\u7684 &b{loser_health_value} &3\u70b9\u3002\u8840\u91cf\u591a\u7684\u4e00\u65b9\u5224\u4e3a\u80dc\u8005", player1, "winner winner_health_value loser loser_health_value", new String[]{p1, "" + player1HealthValue, p2, "" + player2HealthValue});
                                        MessageSender.sm("&3\u6bd4\u8d5b\u8d85\u65f6\uff0c\u73a9\u5bb6 &b{winner} &3\u7684\u8840\u91cf\u4e3a &b{winner_health_value} &3\u70b9\uff0c\u591a\u4e8e\u73a9\u5bb6 &b{loser} &3\u7684 &b{loser_health_value} &3\u70b9\u3002\u8840\u91cf\u591a\u7684\u4e00\u65b9\u5224\u4e3a\u80dc\u8005", player2, "winner winner_health_value loser loser_health_value", new String[]{p1, "" + player1HealthValue, p2, "" + player2HealthValue});
                                        Bukkit.getScheduler().runTask((Plugin)Main.getInstance(), () -> FinishGame.normalEnd(Arena.this.name, p1, p2, false));
                                    } else {
                                        MessageSender.sm("&3\u6bd4\u8d5b\u8d85\u65f6\uff0c\u73a9\u5bb6 &b{winner} &3\u7684\u8840\u91cf\u4e3a &b{winner_health_value} &3\u70b9\uff0c\u591a\u4e8e\u73a9\u5bb6 &b{loser} &3\u7684 &b{loser_health_value} &3\u70b9\u3002\u8840\u91cf\u591a\u7684\u4e00\u65b9\u5224\u4e3a\u80dc\u8005", player1, "winner winner_health_value loser loser_health_value", new String[]{p2, "" + player2HealthValue, p1, "" + player1HealthValue});
                                        MessageSender.sm("&3\u6bd4\u8d5b\u8d85\u65f6\uff0c\u73a9\u5bb6 &b{winner} &3\u7684\u8840\u91cf\u4e3a &b{winner_health_value} &3\u70b9\uff0c\u591a\u4e8e\u73a9\u5bb6 &b{loser} &3\u7684 &b{loser_health_value} &3\u70b9\u3002\u8840\u91cf\u591a\u7684\u4e00\u65b9\u5224\u4e3a\u80dc\u8005", player2, "winner winner_health_value loser loser_health_value", new String[]{p2, "" + player2HealthValue, p1, "" + player1HealthValue});
                                        Bukkit.getScheduler().runTask((Plugin)Main.getInstance(), () -> FinishGame.normalEnd(Arena.this.name, p2, p1, false));
                                    }
                                } else {
                                    MessageSender.sm("&3\u6bd4\u8d5b\u8d85\u65f6\uff0c\u53cc\u65b9\u8840\u91cf\u503c\u76f8\u5f53\uff0c\u5224\u4e3a\u5e73\u5c40\uff01", player1, player2);
                                    Bukkit.getScheduler().runTask((Plugin)Main.getInstance(), () -> FinishGame.normalEnd(Arena.this.name, p1, p2, true));
                                }
                            }
                            if (scheme.equals((Object)ConfigManager.TimeOutHandlingScheme.COMPARE_HEALTH_PERCENTAGE)) {
                                double player2HealthPercentage;
                                double player1HealthPercentage = player1.getHealth() / player1.getMaxHealth();
                                if (player1HealthPercentage != (player2HealthPercentage = player2.getHealth() / player2.getMaxHealth())) {
                                    double player1HealthPercentageShowed = BigDecimal.valueOf(player1HealthPercentage * 100.0).setScale(2, 0).doubleValue();
                                    double player2HealthPercentageShowed = BigDecimal.valueOf(player2HealthPercentage * 100.0).setScale(2, 0).doubleValue();
                                    if (player1HealthPercentage > player2HealthPercentage) {
                                        MessageSender.sm("&3\u6bd4\u8d5b\u8d85\u65f6\uff0c\u73a9\u5bb6 &b{winner} &3\u7684\u8840\u91cf\u767e\u5206\u6bd4\u4e3a &b{winner_health_percentage}% &3\uff0c\u9ad8\u4e8e\u73a9\u5bb6 &b{loser} &3\u7684 &b{loser_health_percentage}% &3\u3002\u8840\u91cf\u767e\u5206\u6bd4\u9ad8\u7684\u4e00\u65b9\u5224\u4e3a\u80dc\u8005", player1, "winner winner_health_percentage loser loser_health_percentage", new String[]{p1, "" + player1HealthPercentageShowed, p2, "" + player2HealthPercentageShowed});
                                        MessageSender.sm("&3\u6bd4\u8d5b\u8d85\u65f6\uff0c\u73a9\u5bb6 &b{winner} &3\u7684\u8840\u91cf\u767e\u5206\u6bd4\u4e3a &b{winner_health_percentage}% &3\uff0c\u9ad8\u4e8e\u73a9\u5bb6 &b{loser} &3\u7684 &b{loser_health_percentage}% &3\u3002\u8840\u91cf\u767e\u5206\u6bd4\u9ad8\u7684\u4e00\u65b9\u5224\u4e3a\u80dc\u8005", player2, "winner winner_health_percentage loser loser_health_percentage", new String[]{p1, "" + player1HealthPercentageShowed, p2, "" + player2HealthPercentageShowed});
                                        Bukkit.getScheduler().runTask((Plugin)Main.getInstance(), () -> FinishGame.normalEnd(Arena.this.name, p1, p2, false));
                                    } else {
                                        MessageSender.sm("&3\u6bd4\u8d5b\u8d85\u65f6\uff0c\u73a9\u5bb6 &b{winner} &3\u7684\u8840\u91cf\u767e\u5206\u6bd4\u4e3a &b{winner_health_percentage}% &3\uff0c\u9ad8\u4e8e\u73a9\u5bb6 &b{loser} &3\u7684 &b{loser_health_percentage}% &3\u3002\u8840\u91cf\u767e\u5206\u6bd4\u9ad8\u7684\u4e00\u65b9\u5224\u4e3a\u80dc\u8005", player1, "winner winner_health_percentage loser loser_health_percentage", new String[]{p2, "" + player2HealthPercentageShowed, p1, "" + player1HealthPercentageShowed});
                                        MessageSender.sm("&3\u6bd4\u8d5b\u8d85\u65f6\uff0c\u73a9\u5bb6 &b{winner} &3\u7684\u8840\u91cf\u767e\u5206\u6bd4\u4e3a &b{winner_health_percentage}% &3\uff0c\u9ad8\u4e8e\u73a9\u5bb6 &b{loser} &3\u7684 &b{loser_health_percentage}% &3\u3002\u8840\u91cf\u767e\u5206\u6bd4\u9ad8\u7684\u4e00\u65b9\u5224\u4e3a\u80dc\u8005", player2, "winner winner_health_percentage loser loser_health_percentage", new String[]{p2, "" + player2HealthPercentageShowed, p1, "" + player1HealthPercentageShowed});
                                        Bukkit.getScheduler().runTask((Plugin)Main.getInstance(), () -> FinishGame.normalEnd(Arena.this.name, p2, p1, false));
                                    }
                                } else {
                                    MessageSender.sm("&3\u6bd4\u8d5b\u8d85\u65f6\uff0c\u53cc\u65b9\u8840\u91cf\u767e\u5206\u6bd4\u76f8\u5f53\uff0c\u5224\u4e3a\u5e73\u5c40\uff01", player1, player2);
                                    Bukkit.getScheduler().runTask((Plugin)Main.getInstance(), () -> FinishGame.normalEnd(Arena.this.name, p1, p2, true));
                                }
                            }
                        } else {
                            Bukkit.getScheduler().runTask((Plugin)Main.getInstance(), () -> FinishGame.normalEnd(Arena.this.name, p1, p2, true));
                        }
                        this.cancel();
                    }
                } else {
                    String p2SubTitle;
                    String p1SubTitle;
                    MessageSender.sm("&7\u6bd4\u8d5b\u5f00\u59cb\u5012\u8ba1\u65f6 &b{time}s", player1, "time", new String[]{"" + -Arena.this.time});
                    MessageSender.sm("&7\u6bd4\u8d5b\u5f00\u59cb\u5012\u8ba1\u65f6 &b{time}s", player2, "time", new String[]{"" + -Arena.this.time});
                    player1.playSound(player1.getLocation(), ViaVersion.getSound("BLOCK_NOTE_BASS", "NOTE_BASS"), 1.0f, 0.0f);
                    player2.playSound(player2.getLocation(), ViaVersion.getSound("BLOCK_NOTE_BASS", "NOTE_BASS"), 1.0f, 0.0f);
                    if (Arena.this.time < -3) {
                        p1SubTitle = MessageSender.gm("&f\u4f60\u5c06\u4e0e\u73a9\u5bb6 &7&l{opponent} &f\u8fdb\u884c\u5bf9\u6218\uff01", player1, "opponent", new String[]{player2.getName()});
                        p2SubTitle = MessageSender.gm("&f\u4f60\u5c06\u4e0e\u73a9\u5bb6 &7&l{opponent} &f\u8fdb\u884c\u5bf9\u6218\uff01", player2, "opponent", new String[]{player1.getName()});
                    } else {
                        p1SubTitle = MessageSender.gm("&3\u6218\u6597\u5373\u5c06\u5f00\u59cb...", player1);
                        p2SubTitle = MessageSender.gm("&3\u6218\u6597\u5373\u5c06\u5f00\u59cb...", player2);
                    }
                    ViaVersion.sendTitle(player1, "\u00a7b\u00a7l" + -Arena.this.time, p1SubTitle, 0, 20, 20);
                    ViaVersion.sendTitle(player2, "\u00a7b\u00a7l" + -Arena.this.time, p2SubTitle, 0, 20, 20);
                }
            }
        }.runTaskTimerAsynchronously((Plugin)Main.getInstance(), 20L, 20L);
        this.taskId = this.timer.getTaskId();
    }

    public void finish() {
        block3: {
            try {
                if (!this.timer.isCancelled()) {
                    this.timer.cancel();
                }
            }
            catch (NoSuchMethodError error) {
                if (!Bukkit.getScheduler().isCurrentlyRunning(this.taskId)) break block3;
                this.timer.cancel();
            }
        }
        this.enable = false;
        this.p1 = null;
        this.p2 = null;
        this.watchers = null;
        this.player1Damage = 0.0;
        this.player1MaxDamage = 0.0;
        this.player2Damage = 0.0;
        this.player2MaxDamage = 0.0;
        this.player1Exp = 0;
        this.player2Exp = 0;
        this.player1MultiHit = 0;
        this.player2MultiHit = 0;
        this.player1Location = null;
        this.player2Location = null;
        this.stage = -1;
        this.watchersTeleport = false;
    }

    public String getName() {
        return this.name;
    }

    public String getp1() {
        return this.p1;
    }

    public String getp2() {
        return this.p2;
    }

    public int getStartWay() {
        return this.startWay;
    }

    public List<String> getWatchers() {
        return this.watchers;
    }

    public void removeWatcher(String watcher) {
        if (!this.watchers.contains(watcher)) {
            return;
        }
        this.watchers.remove(watcher);
    }

    public void addWatcher(String watcher) {
        if (this.watchers.contains(watcher)) {
            return;
        }
        this.watchers.add(watcher);
    }

    public String getTheOtherPlayer(String pn) {
        String theother = null;
        if (pn.equals(this.p1)) {
            theother = this.p2;
        }
        if (pn.equals(this.p2)) {
            theother = this.p1;
        }
        return theother;
    }

    public boolean isp1(String pn) {
        return this.p1.equals(pn);
    }

    public int getStage() {
        return this.stage;
    }

    public int getTime() {
        return this.time;
    }

    public int getCountDown() {
        if (this.countDown == 0) {
            return -6;
        }
        return -this.countDown;
    }

    public void setCountDown(int countDown) {
        this.countDown = countDown;
    }

    public boolean getEnable() {
        return this.enable;
    }

    public double getDamage(boolean isp1) {
        if (isp1) {
            return this.player1Damage;
        }
        return this.player2Damage;
    }

    public void addDamage(boolean isp1, double d) {
        if (isp1) {
            this.player1Damage += d;
        } else {
            this.player2Damage += d;
        }
    }

    public double getMaxDamage(boolean isp1) {
        if (isp1) {
            return this.player1MaxDamage;
        }
        return this.player2MaxDamage;
    }

    public void setMaxDamage(boolean isp1, double d) {
        if (isp1) {
            this.player1MaxDamage = d;
        } else {
            this.player2MaxDamage = d;
        }
    }

    public int getExp(boolean isp1) {
        if (isp1) {
            return this.player1Exp;
        }
        return this.player2Exp;
    }

    public void addExp(boolean isp1, int i) {
        if (isp1) {
            this.player1Exp += i;
        } else {
            this.player2Exp += i;
        }
    }

    public int getHit(boolean isp1) {
        if (isp1) {
            return this.player1MultiHit;
        }
        return this.player2MultiHit;
    }

    public void addHit(boolean isp1) {
        if (isp1) {
            ++this.player1MultiHit;
            this.player2MultiHit = 0;
        } else {
            ++this.player2MultiHit;
            this.player1MultiHit = 0;
        }
    }

    public void setLocation(Player p1, Player p2) {
        if (p1 == null || p2 == null) {
            return;
        }
        this.player1Location = p1.getLocation();
        this.player2Location = p2.getLocation();
    }

    public Location getLocation(boolean isp1) {
        if (isp1) {
            return this.player1Location;
        }
        return this.player2Location;
    }

    public CustomDan getDan(boolean isp1) {
        if (isp1) {
            return this.player1Dan;
        }
        return this.player2Dan;
    }

    protected void setDan(boolean isp1, CustomDan dan) {
        if (isp1) {
            this.player1Dan = dan;
        } else {
            this.player2Dan = dan;
        }
    }

    public List<ItemStack> getPlayerInventoryItems(boolean isp1) {
        if (isp1) {
            return this.player1InventoryItems;
        }
        return this.player2InventoryItems;
    }

    public ItemStack getPlayerHelmet(boolean isp1) {
        if (isp1) {
            return this.player1Helmet;
        }
        return this.player2Helmet;
    }

    public ItemStack getPlayerChestPlate(boolean isp1) {
        if (isp1) {
            return this.player1ChestPlate;
        }
        return this.player2ChestPlate;
    }

    public ItemStack getPlayerLeggings(boolean isp1) {
        if (isp1) {
            return this.player1Leggings;
        }
        return this.player2Leggings;
    }

    public ItemStack getPlayerBoots(boolean isp1) {
        if (isp1) {
            return this.player1Boots;
        }
        return this.player2Boots;
    }

    public ItemStack getPlayerOffHandItem(boolean isp1) {
        if (isp1) {
            return this.player1OffHandItem;
        }
        return this.player2OffHandItem;
    }

    public boolean canTeleport() {
        return this.canTeleport;
    }

    protected void setCanTeleport(boolean canTeleport) {
        this.canTeleport = canTeleport;
    }

    public boolean getWatchersTeleport() {
        return this.watchersTeleport;
    }

    protected void setWatchersTeleport(boolean watchersTeleport) {
        this.watchersTeleport = watchersTeleport;
    }

    public int getTimeout() {
        return this.timeout;
    }
}

