/*
 * Decompiled with CFR 0.152.
 */
package com.valorin.arenas;

import com.valorin.Main;
import com.valorin.api.event.arena.ArenaStartEvent;
import com.valorin.arenas.Arena;
import com.valorin.arenas.ArenaManager;
import com.valorin.configuration.ConfigManager;
import com.valorin.configuration.languagefile.MessageSender;
import com.valorin.dan.DanHandler;
import com.valorin.data.Data;
import com.valorin.request.RequestsHandler;
import com.valorin.util.ItemChecker;
import java.util.List;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

public class StartGame {
    public static void start(Player player1, Player player2, String arenaEditName, Player starter, int startWay) {
        Arena arena;
        List<String> worldList;
        if (player1 == null || player2 == null) {
            MessageSender.sm("&c[x]\u8b66\u544a\uff1a\u5f00\u8d5b\u65f6\u53d1\u751f\u5f02\u5e38\uff0c\u4e0d\u4e88\u5f00\u8d5b\uff01", starter);
            return;
        }
        if (Data.getArenas().size() == 0) {
            MessageSender.sm("&c\u670d\u52a1\u5668\u5185\u6ca1\u6709\u8bbe\u7f6e\u4efb\u4f55\u7ade\u6280\u573a\uff01\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01", player1, player2);
            return;
        }
        ConfigManager configManager = Main.getInstance().getConfigManager();
        if (configManager.isWorldWhitelistEnabled() && (worldList = configManager.getWorldWhitelist()) != null) {
            if (!worldList.contains(player1.getWorld().getName())) {
                MessageSender.sm("&c[x]\u4f60\u6240\u5728\u7684\u4e16\u754c\u5df2\u88ab\u7981\u6b62\u6bd4\u8d5b\uff0c\u8bf7\u79fb\u52a8\u5230\u5141\u8bb8\u6bd4\u8d5b\u7684\u4e16\u754c\u518d\u5f00\u8d5b", player1);
                MessageSender.sm("&c[x]\u5bf9\u624b{player}\u6240\u5728\u7684\u4e16\u754c\u5df2\u88ab\u7981\u6b62\u6bd4\u8d5b\uff0c\u8bf7\u7b49\u5f85TA\u79fb\u52a8\u5230\u5141\u8bb8\u6bd4\u8d5b\u7684\u4e16\u754c\u518d\u5f00\u8d5b", player2, "player", new String[]{player1.getName()});
                return;
            }
            if (!worldList.contains(player2.getWorld().getName())) {
                MessageSender.sm("&c[x]\u4f60\u6240\u5728\u7684\u4e16\u754c\u5df2\u88ab\u7981\u6b62\u6bd4\u8d5b\uff0c\u8bf7\u79fb\u52a8\u5230\u5141\u8bb8\u6bd4\u8d5b\u7684\u4e16\u754c\u518d\u5f00\u8d5b", player2);
                MessageSender.sm("&c[x]\u5bf9\u624b{player}\u6240\u5728\u7684\u4e16\u754c\u5df2\u88ab\u7981\u6b62\u6bd4\u8d5b\uff0c\u8bf7\u7b49\u5f85TA\u79fb\u52a8\u5230\u5141\u8bb8\u6bd4\u8d5b\u7684\u4e16\u754c\u518d\u5f00\u8d5b", player1, "player", new String[]{player2.getName()});
                return;
            }
        }
        if (arenaEditName == null) {
            if (ArenaManager.busyArenasName.size() == ArenaManager.arenas.size()) {
                player1.closeInventory();
                player2.closeInventory();
                MessageSender.sm("&c\u6240\u6709\u7ade\u6280\u573a\u90fd\u6ee1\u4e86\uff01\u8bf7\u7a0d\u540e\u518d\u8bd5~&e(\u5c0f\u63d0\u793a\uff1a\u8f93\u5165/dt ainfo\u53ef\u4ee5\u67e5\u770b\u6240\u6709\u7ade\u6280\u573a\u7684\u5b9e\u65f6\u4fe1\u606f)", player1, player2);
                return;
            }
        } else {
            if (!ArenaManager.arenas.contains(Main.getInstance().getArenaManager().getArena(arenaEditName))) {
                MessageSender.sm("&c\u4e0d\u5b58\u5728\u8fd9\u4e2a\u7ade\u6280\u573a\uff0c\u8bf7\u68c0\u67e5\u8f93\u5165", starter);
                return;
            }
            if (ArenaManager.busyArenasName.contains(arenaEditName)) {
                MessageSender.sm("&c\u8fd9\u4e2a\u7ade\u6280\u573a\u6b63\u5728\u6bd4\u8d5b\u4e2d\uff01\u8bf7\u6362\u4e00\u4e2a\u8bd5\u8bd5", starter);
                return;
            }
        }
        if ((arena = arenaEditName == null ? StartGame.getRandomArena() : Main.getInstance().getArenaManager().getArena(arenaEditName)) == null) {
            MessageSender.sm("&c[x]\u8b66\u544a\uff1a\u5f00\u8d5b\u65f6\u53d1\u751f\u5f02\u5e38\uff0c\u4e0d\u4e88\u5f00\u8d5b\uff01", player1, player2);
            player1.closeInventory();
            player2.closeInventory();
            return;
        }
        String playerName1 = player1.getName();
        String playerName2 = player2.getName();
        ArenaStartEvent event = new ArenaStartEvent(player1, player2, arena);
        arenaEditName = arena.getName();
        arena.setLocation(player1, player2);
        DanHandler dh = Main.getInstance().getDanHandler();
        arena.setDan(true, dh.getPlayerDan(playerName1));
        arena.setDan(false, dh.getPlayerDan(playerName2));
        if (Main.getInstance().getCacheHandler().getArenaInfo().get(arenaEditName).isKitMode()) {
            ItemStack player2CursorItem;
            ItemStack player1CursorItem = player1.getItemOnCursor();
            if (player1CursorItem != null && !player1CursorItem.getType().equals((Object)Material.AIR)) {
                player1.getWorld().dropItem(player1.getLocation(), player1CursorItem);
                player1.setItemOnCursor(null);
            }
            if ((player2CursorItem = player2.getItemOnCursor()) != null && !player2CursorItem.getType().equals((Object)Material.AIR)) {
                player2.getWorld().dropItem(player2.getLocation(), player2CursorItem);
                player2.setItemOnCursor(null);
            }
        } else {
            List<String> materialNameLimitedList = configManager.getItemLimitByMaterial();
            List<String> loreLimitedList = configManager.getItemLimitByLore();
            List<String> displayNameLimitedList = configManager.getItemLimitByDisplayName();
            if (ItemChecker.check(player1, materialNameLimitedList, displayNameLimitedList, loreLimitedList)) {
                MessageSender.sm("&c[x]\u4f60\u7684\u80cc\u5305\u91cc\u643a\u5e26\u6709\u8fdd\u7981\u54c1\uff01\u4e0d\u4e88\u5f00\u8d5b", player1);
                MessageSender.sm("&c[x]\u5bf9\u624b{player}\u7684\u80cc\u5305\u91cc\u643a\u5e26\u6709\u8fdd\u7981\u54c1\uff01\u4e0d\u4e88\u5f00\u8d5b", player2, "player", new String[]{player1.getName()});
                player1.closeInventory();
                player2.closeInventory();
                return;
            }
            if (ItemChecker.check(player2, materialNameLimitedList, displayNameLimitedList, loreLimitedList)) {
                MessageSender.sm("&c[x]\u4f60\u7684\u80cc\u5305\u91cc\u643a\u5e26\u6709\u8fdd\u7981\u54c1\uff01\u4e0d\u4e88\u5f00\u8d5b", player2);
                MessageSender.sm("&c[x]\u5bf9\u624b{player}\u7684\u80cc\u5305\u91cc\u643a\u5e26\u6709\u8fdd\u7981\u54c1\uff01\u4e0d\u4e88\u5f00\u8d5b", player1, "player", new String[]{player2.getName()});
                player1.closeInventory();
                player2.closeInventory();
                return;
            }
        }
        player1.teleport(Data.getArenaPointA(arenaEditName));
        player2.teleport(Data.getArenaPointB(arenaEditName));
        if (player1.isFlying() && !player1.isOp()) {
            player1.setFlying(false);
        }
        if (player2.isFlying() && !player2.isOp()) {
            player2.setFlying(false);
        }
        player1.setHealth(player1.getMaxHealth());
        player2.setHealth(player2.getMaxHealth());
        player1.setFoodLevel(20);
        player2.setFoodLevel(20);
        if (configManager.isChangeGameModeWhenGameStarts()) {
            player1.setGameMode(GameMode.SURVIVAL);
            player2.setGameMode(GameMode.SURVIVAL);
        }
        arena.start(playerName1, playerName2, startWay);
        ArenaManager.busyArenasName.add(arenaEditName);
        String arenaDisplayName = Main.getInstance().getCacheHandler().getArenaInfo().get(arenaEditName).getDisplayName();
        if (arenaDisplayName == null) {
            arenaDisplayName = "";
        }
        MessageSender.sm("&b\u60a8\u5df2\u8fdb\u5165\u7ade\u6280\u573a&r{arenaname}", player1, "arenaname", new String[]{arenaDisplayName});
        MessageSender.sm("&b\u60a8\u5df2\u8fdb\u5165\u7ade\u6280\u573a&r{arenaname}", player2, "arenaname", new String[]{arenaDisplayName});
        RequestsHandler rh = Main.getInstance().getRequestsHandler();
        rh.clearRequests(playerName1, 0, playerName2);
        rh.clearRequests(playerName2, 0, playerName1);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (starter != null) {
            MessageSender.sm("&a[v]\u5df2\u5f3a\u5236\u5f00\u59cb", starter);
        }
    }

    private static Arena getRandomArena() {
        if (Data.getArenas().size() == 0) {
            return null;
        }
        List<String> freeArenasName = Data.getArenas();
        freeArenasName.removeAll(ArenaManager.busyArenasName);
        if (freeArenasName.size() == 0) {
            return null;
        }
        Random random = new Random();
        return Main.getInstance().getArenaManager().getArena(freeArenasName.get(random.nextInt(freeArenasName.size())));
    }
}

