/*
 * Decompiled with CFR 0.152.
 */
package com.valorin.caches;

import com.valorin.Main;
import com.valorin.data.Data;
import com.valorin.util.Debug;
import com.valorin.util.ViaVersion;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class LanguageFileCache {
    private final Map<String, String> map = new HashMap<String, String>();

    public LanguageFileCache() {
        try {
            for (Player player : ViaVersion.getOnlinePlayers()) {
                this.load(player.getName());
            }
            Debug.send("\u8bed\u8a00\u6587\u4ef6\u6570\u636e\u7f13\u5b58\u5df2\u5c31\u7eea", "The language file cache has been initialized");
        }
        catch (Exception e) {
            Debug.send("\u00a7c\u8bed\u8a00\u6570\u636e\u6570\u636e\u7f13\u5b58\u672a\u80fd\u52a0\u8f7d", "\u00a7cThe language file cache failed to initialize");
            e.printStackTrace();
        }
    }

    public String get(String name) {
        return this.map.get(name);
    }

    public void load(String name) {
        if (!this.map.containsKey(name)) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)Main.getInstance(), () -> {
                String language = Data.getLanguageFile(name);
                this.map.put(name, language);
            });
        }
    }

    public void set(String name, String language) {
        this.map.put(name, language);
        Data.setLanguageFile(name, this.map.get(name), true);
    }
}

