/*
 * Decompiled with CFR 0.152.
 */
package com.valorin.caches;

import com.valorin.Main;
import com.valorin.data.Data;
import com.valorin.data.encapsulation.Good;
import com.valorin.util.Debug;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ShopCache {
    private List<Good> goodList = new ArrayList<Good>();

    public ShopCache() {
        try {
            this.goodList = Data.getGoodList();
            Debug.send("\u79ef\u5206\u5546\u57ce\u7f13\u5b58\u5df2\u5c31\u7eea", "The Point Shop cache has been initialized");
        }
        catch (Exception e) {
            Debug.send("\u00a7c\u79ef\u5206\u5546\u57ce\u7f13\u5b58\u672a\u80fd\u52a0\u8f7d", "\u00a7cThe Point Shop cache failed to initialize");
            e.printStackTrace();
        }
    }

    public List<Good> getList() {
        return this.goodList;
    }

    public void add(ItemStack item, double price) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Main.getInstance(), () -> {
            int num = Data.getHistoryGood();
            Bukkit.getScheduler().runTask((Plugin)Main.getInstance(), () -> {
                this.goodList.add(new Good(num, item, price, null, null, 0, null, null));
                Data.addGood(num, item, price);
                Data.updateHistoryGood();
            });
        });
    }

    public void remove(int num) {
        Good selectedGood = null;
        for (Good good : this.goodList) {
            if (good.getNum() != num) continue;
            selectedGood = good;
            break;
        }
        if (selectedGood != null) {
            this.goodList.remove(selectedGood);
            Data.removeGood(selectedGood.getNum());
        }
    }

    public int size() {
        return this.goodList.size();
    }

    public Good get(int num) {
        for (Good good : this.goodList) {
            if (good.getNum() != num) continue;
            return good;
        }
        return null;
    }

    public int getIndexByNum(int num) {
        return this.goodList.indexOf(this.get(num));
    }

    public int getNumByIndex(int index) {
        return this.goodList.get(index).getNum();
    }

    public void setBroadcast(int num, String broadcast) {
        int index = -1;
        for (int i = 0; i < this.goodList.size(); ++i) {
            Good good = this.goodList.get(i);
            if (good.getNum() != num) continue;
            index = i;
            break;
        }
        this.goodList.get(index).setBroadcast(broadcast);
        Data.setBroadcastForGood(num, broadcast);
    }

    public void setDescription(int num, String description) {
        int index = -1;
        for (int i = 0; i < this.goodList.size(); ++i) {
            Good good = this.goodList.get(i);
            if (good.getNum() != num) continue;
            index = i;
            break;
        }
        this.goodList.get(index).setDescription(description);
        Data.setDescriptionForGood(num, description);
    }

    public void setDan(int num, String dan) {
        int index = -1;
        for (int i = 0; i < this.goodList.size(); ++i) {
            Good good = this.goodList.get(i);
            if (good.getNum() != num) continue;
            index = i;
            break;
        }
        this.goodList.get(index).setDan(dan);
        Data.setDanForGood(num, dan);
    }

    public void setCommands(int num, List<String> commands) {
        int index = -1;
        for (int i = 0; i < this.goodList.size(); ++i) {
            Good good = this.goodList.get(i);
            if (good.getNum() != num) continue;
            index = i;
            break;
        }
        this.goodList.get(index).setCommands(commands);
        Data.setCommandsForGood(num, commands);
    }

    public void updateSalesVolume(int num) {
        this.goodList.get(this.goodList.indexOf(this.get(num))).updateSalesVolume();
        Data.updateSalesVolume(num);
    }
}

