/*
 * Decompiled with CFR 0.152.
 */
package com.valorin.commands;

import com.valorin.Main;
import com.valorin.arenas.Arena;
import com.valorin.arenas.ArenaManager;
import com.valorin.commands.SimilarityComparer;
import com.valorin.commands.SubCommand;
import com.valorin.commands.sub.CMDMainHelp;
import com.valorin.commands.way.AdminCommand;
import com.valorin.commands.way.InServerCommand;
import com.valorin.configuration.languagefile.MessageSender;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;

public class CommandExecutor
implements TabExecutor {
    private final String[] SUBCOMMANDS_ARENAOP = new String[]{"mode", "create", "remove", "list", "sw", "rw", "commands"};
    private final String[] SUBCOMMANDS_ARENAOP_COMMANDS = new String[]{"add", "clear", "list"};
    private final String[] SUBCOMMANDS_BLACKLIST = new String[]{"add", "remove", "list", "clear"};
    private final String[] SUBCOMMANDS_SHOP = new String[]{"add", "remove", "des", "rdes", "bc", "rbc"};
    private final String[] SUBCOMMANDS_EXP = new String[]{"add", "take", "set"};
    private final String[] SUBCOMMANDS_POINTS = new String[]{"add", "set", "view"};
    private final String[] SUBCOMMANDS_ENERGY = new String[]{"add", "set"};
    private final String[] SUBCOMMANDS_HD = new String[]{"win", "winremove", "kd", "kdremove", "refresh"};

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Player player = null;
        if (sender instanceof Player) {
            player = (Player)sender;
        }
        if (args.length == 0) {
            return new CMDMainHelp().onCommand(sender);
        }
        SubCommand subCommand = Main.getInstance().getCommandHandler().getSubCommand(args[0]);
        if (subCommand == null) {
            String similarLabel = SimilarityComparer.getMostSimilarSubCommand(args[0]);
            if (similarLabel == null) {
                MessageSender.sm("&c\u4e0d\u5b58\u5728\u6b64\u5219\u5b50\u6307\u4ee4\uff0c\u8bf7\u68c0\u67e5\u8f93\u5165", player);
            } else {
                MessageSender.sm("&c\u4e0d\u5b58\u5728\u6b64\u5219\u5b50\u6307\u4ee4\uff0c\u4f60\u662f\u60f3\u8f93\u5165 &e/dt {subcommand} &c\u5417\uff1f", player, "subcommand", new String[]{similarLabel});
            }
            return true;
        }
        if (subCommand instanceof AdminCommand) {
            if (!sender.hasPermission("dt.admin")) {
                MessageSender.sm("&c[x]\u65e0\u6743\u9650\uff01", player);
                return true;
            }
            return subCommand.onCommand(sender, command, label, args);
        }
        if (subCommand instanceof InServerCommand) {
            if (!(sender instanceof Player)) {
                MessageSender.sm("&c[x]\u8fd9\u6761\u6307\u4ee4\u53ea\u80fd\u7531\u670d\u52a1\u5668\u5185\u7684\u73a9\u5bb6\u6267\u884c\uff01\u540e\u53f0\u65e0\u6cd5\u4f7f\u7528\uff01", player);
                return true;
            }
            return subCommand.onCommand(sender, command, label, args);
        }
        return subCommand.onCommand(sender, command, label, args);
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            return Arrays.stream(SimilarityComparer.SUBCOMMANDS).filter(s -> s.startsWith(args[0])).collect(Collectors.toList());
        }
        if (args[0].equalsIgnoreCase("send")) {
            return sender instanceof Player ? Arrays.stream(Bukkit.getOnlinePlayers().toArray(new Player[0])).map(OfflinePlayer::getName).filter(playerName -> !playerName.equals(sender.getName()) && playerName.contains(args[1])).collect(Collectors.toList()) : new ArrayList<String>();
        }
        if (args[0].equalsIgnoreCase("changelang") || args[0].equalsIgnoreCase("cl")) {
            return sender instanceof Player ? Arrays.stream(Main.getInstance().getLanguageFileLoader().getLanguagesList().toArray(new File[0])).map(File::getName).map(fileName -> fileName.replace(".txt", "")).filter(fileName -> fileName.contains(args[1])).collect(Collectors.toList()) : new ArrayList<String>();
        }
        if (args[0].equalsIgnoreCase("stop") || args[0].equalsIgnoreCase("watch") || args[0].equalsIgnoreCase("w")) {
            if (!(sender instanceof Player)) {
                return new ArrayList<String>();
            }
            List<Arena> arenaList = ArenaManager.arenas;
            ArrayList<String> arenaNameList = new ArrayList<String>();
            for (Arena arena : arenaList) {
                arenaNameList.add(arena.getName());
            }
            return arenaNameList;
        }
        if (!sender.hasPermission("dt.admin")) {
            return new ArrayList<String>();
        }
        if (args[0].equalsIgnoreCase("a") || args[0].equalsIgnoreCase("arena")) {
            if (args.length == 3) {
                if (args[1].equalsIgnoreCase("commands")) {
                    return Arrays.stream(this.SUBCOMMANDS_ARENAOP_COMMANDS).filter(s -> s.startsWith(args[2])).collect(Collectors.toList());
                }
                return new ArrayList<String>();
            }
            return Arrays.stream(this.SUBCOMMANDS_ARENAOP).filter(s -> s.startsWith(args[1])).collect(Collectors.toList());
        }
        if (args[0].equalsIgnoreCase("b") || args[0].equalsIgnoreCase("blacklist")) {
            return Arrays.stream(this.SUBCOMMANDS_BLACKLIST).filter(s -> s.startsWith(args[1])).collect(Collectors.toList());
        }
        if (args[0].equalsIgnoreCase("s") || args[0].equalsIgnoreCase("shop")) {
            return Arrays.stream(this.SUBCOMMANDS_SHOP).filter(s -> s.startsWith(args[1])).collect(Collectors.toList());
        }
        if (args[0].equalsIgnoreCase("p") || args[0].equalsIgnoreCase("points")) {
            return Arrays.stream(this.SUBCOMMANDS_POINTS).filter(s -> s.startsWith(args[1])).collect(Collectors.toList());
        }
        if (args[0].equalsIgnoreCase("exp")) {
            return Arrays.stream(this.SUBCOMMANDS_EXP).filter(s -> s.startsWith(args[1])).collect(Collectors.toList());
        }
        if (args[0].equalsIgnoreCase("e") || args[0].equalsIgnoreCase("energy")) {
            return Arrays.stream(this.SUBCOMMANDS_ENERGY).filter(s -> s.startsWith(args[1])).collect(Collectors.toList());
        }
        if (args[0].equalsIgnoreCase("hd")) {
            return Arrays.stream(this.SUBCOMMANDS_HD).filter(s -> s.startsWith(args[1])).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }
}

